/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.rules;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum NamingStrategy {
    no_change,
    underline_to_camel;


    public static String underlineToCamel(String name) {
        if (StringUtils.isBlank(name)) {
            return "";
        }
        String tempName = name;
        if (StringUtils.isCapitalMode(name) || StringUtils.isMixedMode(name)) {
            tempName = name.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        String[] camels = tempName.split("_");
        Arrays.stream(camels).filter(camel -> !StringUtils.isBlank(camel)).forEach(camel -> {
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
            } else {
                result.append(NamingStrategy.capitalFirst(camel));
            }
        });
        return result.toString();
    }

    @Deprecated
    public static String removePrefix(String name, String ... prefix) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(prefix));
        return NamingStrategy.removePrefix(name, set);
    }

    public static String removePrefix(String name, Set<String> prefix) {
        if (StringUtils.isBlank(name)) {
            return "";
        }
        if (null != prefix) {
            return prefix.stream().filter(pf -> name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")).findFirst().map(pf -> name.substring(pf.length())).orElse(name);
        }
        return name;
    }

    public static boolean isPrefixContained(String name, String ... prefix) {
        if (null == prefix || StringUtils.isBlank(name)) {
            return false;
        }
        return Arrays.stream(prefix).anyMatch(pf -> name.toLowerCase().matches("^" + pf.toLowerCase() + ".*"));
    }

    @Deprecated
    public static String removePrefixAndCamel(String name, String[] tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String removePrefixAndCamel(String name, Set<String> tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotBlank(name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

