/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.executor.AbstractExecuteCommand;
import com.kingbase8.dispatcher.executor.DispatchStatementV2;
import com.kingbase8.dispatcher.executor.command.PrepareStCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStIncreaseCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStIndexCommand;
import com.kingbase8.dispatcher.executor.command.PrepareStNamesCommand;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DispatchPreparedStatementV2
extends DispatchStatementV2
implements PreparedStatement {
    public DispatchPreparedStatementV2(DispatchConnection conn) {
        super(conn);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql, resultSetType, resultSetHoldability);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int resultSetType, int resultSetConcurrency) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql, resultSetType, resultSetConcurrency);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int autoGeneratedKeys) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStIncreaseCommand(sql, autoGeneratedKeys);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, String[] columnNames) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStNamesCommand(sql, columnNames);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int[] columnIndexes) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStIndexCommand(sql, columnIndexes);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeQuery()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t2) throws SQLException {
                KbResultSet brs;
                BaseConnection conn = (BaseConnection)t2.getConnection();
                ResultSet rs = ((PreparedStatement)t2).executeQuery();
                if (conn.isSlave() && conn.isZeroResend() && (brs = (KbResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new KSQLException("resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeUpdate()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return ((PreparedStatement)t2).executeUpdate();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t2) throws SQLException {
                return ((PreparedStatement)t2).executeBatch();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int parameterIndex, final int sqlType) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + parameterIndex + "," + sqlType + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNull(parameterIndex, sqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBoolean(final int parameterIndex, final boolean x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBoolean(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBoolean(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setByte(final int parameterIndex, final byte x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setByte(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setByte(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setShort(final int parameterIndex, final short x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setShort(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setShort(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setInt(final int parameterIndex, final int x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setInt(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setInt(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setLong(final int parameterIndex, final long x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setLong(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setLong(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFloat(final int parameterIndex, final float x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setFloat(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setFloat(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDouble(final int parameterIndex, final double x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDouble(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setDouble(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBigDecimal(final int parameterIndex, final BigDecimal x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBigDecimal(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBigDecimal(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setString(final int parameterIndex, final String x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setString(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setString(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBytes(final int parameterIndex, final byte[] x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBytes(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBytes(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int parameterIndex, final Date x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDate(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setDate(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int parameterIndex, final Time x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setTime(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int parameterIndex, final Timestamp x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setTimestamp(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int parameterIndex, final InputStream x2, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setAsciiStream(parameterIndex, x2, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setUnicodeStream(final int parameterIndex, final InputStream x2, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setUnicodeStream(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setUnicodeStream(parameterIndex, x2, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int parameterIndex, final InputStream x2, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBinaryStream(parameterIndex, x2, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearParameters() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.clearParameters()";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).clearParameters();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x2, final int targetSqlType, final int scale) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setObject(parameterIndex, x2, targetSqlType, scale);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x2, final int targetSqlType) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setObject(parameterIndex, x2, targetSqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setObject(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean execute() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.execute()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                KbResultSet brs;
                BaseConnection conn = (BaseConnection)t2.getConnection();
                Boolean result = ((PreparedStatement)t2).execute();
                if (conn.isSlave() && conn.isZeroResend() && result.booleanValue() && (brs = (KbResultSet)t2.getResultSet()).getTupleCount() == 0) {
                    brs.close();
                    throw new KSQLException("resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return result;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.addBatch()";
            }

            @Override
            public Object execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).addBatch();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
        this.add();
    }

    @Override
    public void setCharacterStream(final int parameterIndex, final Reader reader, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setCharacterStream(parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setRef(final int i2, final Ref x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setRef(" + i2 + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setRef(i2, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int i2, final Blob x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + i2 + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBlob(i2, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int i2, final Clob x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + i2 + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setClob(i2, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setArray(final int i2, final Array x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + i2 + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setArray(i2, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        AbstractExecuteCommand<ResultSetMetaData> ec = new AbstractExecuteCommand<ResultSetMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getMetaData()";
            }

            @Override
            public ResultSetMetaData execute(Statement t2) throws SQLException {
                return ((PreparedStatement)t2).getMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int parameterIndex, final Date x2, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setDate(parameterIndex, x2, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int parameterIndex, final Time x2, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setTime(parameterIndex, x2, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int parameterIndex, final Timestamp x2, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setTimestamp(parameterIndex, x2, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int paramIndex, final int sqlType, final String typeName) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + paramIndex + "," + sqlType + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNull(paramIndex, sqlType, typeName);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setURL(final int parameterIndex, final URL x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setURL(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setURL(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        AbstractExecuteCommand<ParameterMetaData> ec = new AbstractExecuteCommand<ParameterMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getParameterMetaData()";
            }

            @Override
            public ParameterMetaData execute(Statement t2) throws SQLException {
                return ((PreparedStatement)t2).getParameterMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected boolean expectionHandler(SQLException e2, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e2)) {
            return true;
        }
        return changeSuccess;
    }

    @Override
    public void setRowId(final int parameterIndex, final RowId x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setRowId(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setRowId(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNString(final int parameterIndex, final String value) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNString(" + parameterIndex + "," + value + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNString(parameterIndex, value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNCharacterStream(final int parameterIndex, final Reader value, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNCharacterStream(" + parameterIndex + "," + value + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNCharacterStream(parameterIndex, value, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int parameterIndex, final NClob value) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + parameterIndex + "," + value + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNClob(parameterIndex, value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int parameterIndex, final Reader reader, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setClob(parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int parameterIndex, final InputStream inputStream, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + parameterIndex + "," + inputStream + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBlob(parameterIndex, inputStream, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int parameterIndex, final Reader reader, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNClob(parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setSQLXML(final int parameterIndex, final SQLXML xmlObject) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setSQLXML(" + parameterIndex + "," + xmlObject + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setSQLXML(parameterIndex, xmlObject);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int parameterIndex, final InputStream x2, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + parameterIndex + "," + x2 + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setAsciiStream(parameterIndex, x2, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int parameterIndex, final InputStream x2, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + parameterIndex + "," + x2 + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBinaryStream(parameterIndex, x2, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setCharacterStream(final int parameterIndex, final Reader reader, final long length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + parameterIndex + "," + reader + "," + length + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setCharacterStream(parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int parameterIndex, final InputStream x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setAsciiStream(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int parameterIndex, final InputStream x2) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + parameterIndex + "," + x2 + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBinaryStream(parameterIndex, x2);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setCharacterStream(final int parameterIndex, final Reader reader) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setCharacterStream(parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNCharacterStream(final int parameterIndex, final Reader value) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNCharacterStream(" + parameterIndex + "," + value + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNCharacterStream(parameterIndex, value);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int parameterIndex, final Reader reader) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setClob(parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int parameterIndex, final InputStream inputStream) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + parameterIndex + "," + inputStream + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setBlob(parameterIndex, inputStream);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNClob(final int parameterIndex, final Reader reader) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNClob(" + parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                ((PreparedStatement)t2).setNClob(parameterIndex, reader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }
}

