/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBlseg
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] point = new KBpoint[2];

    public KBlseg(double x1, double y1, double x2, double y2) {
        this(new KBpoint(x1, y1), new KBpoint(x2, y2));
    }

    public KBlseg(KBpoint p1, KBpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public KBlseg(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public KBlseg() {
        this.setType("LSEG");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        KBtokenizer t2 = new KBtokenizer(KBtokenizer.removeBox(s2), ',');
        if (t2.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new KBpoint(t2.getToken(0));
        this.point[1] = new KBpoint(t2.getToken(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBlseg) {
            KBlseg p2 = (KBlseg)obj;
            return p2.point[0].equals(this.point[0]) && p2.point[1].equals(this.point[1]) || p2.point[0].equals(this.point[1]) && p2.point[1].equals(this.point[0]);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBlseg newKBlseg = (KBlseg)super.clone();
        if (newKBlseg.point != null) {
            newKBlseg.point = (KBpoint[])newKBlseg.point.clone();
            for (int i2 = 0; i2 < newKBlseg.point.length; ++i2) {
                if (newKBlseg.point[i2] == null) continue;
                newKBlseg.point[i2] = (KBpoint)newKBlseg.point[i2].clone();
            }
        }
        return newKBlseg;
    }

    @Override
    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

