/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpath
extends KBobject
implements Serializable,
Cloneable {
    public boolean open;
    public KBpoint[] points;

    public KBpath(KBpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public KBpath() {
        this.setType("PATH");
    }

    public KBpath(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    @Override
    public void setValue(String s2) throws SQLException {
        if (s2.startsWith("[") && s2.endsWith("]")) {
            this.open = true;
            s2 = KBtokenizer.removeBox(s2);
        } else if (s2.startsWith("(") && s2.endsWith(")")) {
            this.open = false;
            s2 = KBtokenizer.removePara(s2);
        } else {
            throw new KSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s2), KSQLState.DATA_TYPE_MISMATCH);
        }
        KBtokenizer t2 = new KBtokenizer(s2, ',');
        int npoints = t2.getSize();
        this.points = new KBpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new KBpoint(t2.getToken(p2));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBpath) {
            KBpath p2 = (KBpath)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            if (p2.open != this.open) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2].equals(p2.points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            hash ^= this.points[i2].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBpath newKBpath = (KBpath)super.clone();
        if (newKBpath.points != null) {
            newKBpath.points = (KBpoint[])newKBpath.points.clone();
            for (int i2 = 0; i2 < newKBpath.points.length; ++i2) {
                newKBpath.points[i2] = (KBpoint)newKBpath.points[i2].clone();
            }
        }
        return newKBpath;
    }

    @Override
    public String getValue() {
        StringBuilder b2 = new StringBuilder(this.open ? "[" : "(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(this.points[p2].toString());
        }
        b2.append(this.open ? "]" : ")");
        return b2.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

