/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpoint
extends KBobject
implements KBBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;

    public KBpoint(double x2, double y2) {
        this();
        this.x = x2;
        this.y = y2;
    }

    public KBpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public KBpoint() {
        this.setType("POINT");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        KBtokenizer t2 = new KBtokenizer(KBtokenizer.removePara(s2), ',');
        try {
            this.x = Double.parseDouble(t2.getToken(0));
            this.y = Double.parseDouble(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH, (Throwable)e2);
        }
    }

    @Override
    public void setByteValue(byte[] b2, int offset) {
        this.x = ByteConverter.float8(b2, offset);
        this.y = ByteConverter.float8(b2, offset + 8);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBpoint) {
            KBpoint p2 = (KBpoint)obj;
            return this.x == p2.x && this.y == p2.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public int lengthInBytes() {
        return 16;
    }

    @Override
    public void toBytes(byte[] b2, int offset) {
        ByteConverter.float8(b2, offset, this.x);
        ByteConverter.float8(b2, offset + 8, this.y);
    }

    public void translate(int x2, int y2) {
        this.translate((double)x2, (double)y2);
    }

    public void translate(double x2, double y2) {
        this.x += x2;
        this.y += y2;
    }

    public void move(int x2, int y2) {
        this.setLocation(x2, y2);
    }

    public void move(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public void setLocation(int x2, int y2) {
        this.move((double)x2, (double)y2);
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

