/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.Field;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.UUIDArrayAssistant;
import com.kingbase8.jdbc2.ArrayAssistant;
import com.kingbase8.jdbc2.ArrayAssistantRegistry;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class KbArray
implements java.sql.Array {
    protected BaseConnection connection = null;
    private int oid;
    protected String fieldString = null;
    private final boolean useObjects;
    protected KbArrayList arrayList;
    protected byte[] fieldBytes;

    private KbArray(BaseConnection connection, int oid) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.useObjects = true;
    }

    public KbArray(BaseConnection connection, int oid, String fieldString) throws SQLException {
        this(connection, oid);
        this.fieldString = fieldString;
    }

    public KbArray(BaseConnection connection, int oid, byte[] fieldBytes) throws SQLException {
        this(connection, oid);
        this.fieldBytes = fieldBytes;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(map);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(index, count, map);
    }

    public Object getArrayImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new KSQLException(GT.tr("The array index is out of range: {0}", index), KSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryArray((int)index, count);
        }
        if (this.fieldString == null) {
            return null;
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new KSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", index + (long)count, this.arrayList.size()), KSQLState.DATA_ERROR);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    private Object readBinaryArray(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d2 = 0; d2 < dimensions; ++d2) {
            dims[d2] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (dimensions == 0) {
            return Array.newInstance(this.elementOidToClass(elementOid), 0);
        }
        if (count > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        Object arr = Array.newInstance(this.elementOidToClass(elementOid), dims);
        try {
            this.storeValues((Object[])arr, elementOid, dims, pos, 0, index);
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)ioe);
        }
        return arr;
    }

    private int storeValues(Object[] arr, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException, IOException {
        if (thisDimension == dims.length - 1) {
            int len;
            int i2;
            for (i2 = 1; i2 < index; ++i2) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i2 = 0; i2 < dims[thisDimension]; ++i2) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                switch (elementOid) {
                    case 21: {
                        arr[i2] = ByteConverter.int2(this.fieldBytes, pos);
                        break;
                    }
                    case 23: {
                        arr[i2] = ByteConverter.int4(this.fieldBytes, pos);
                        break;
                    }
                    case 20: {
                        arr[i2] = ByteConverter.int8(this.fieldBytes, pos);
                        break;
                    }
                    case 700: {
                        arr[i2] = Float.valueOf(ByteConverter.float4(this.fieldBytes, pos));
                        break;
                    }
                    case 701: {
                        arr[i2] = ByteConverter.float8(this.fieldBytes, pos);
                        break;
                    }
                    case 25: 
                    case 1043: {
                        Encoding encoding = this.connection.getEncoding();
                        arr[i2] = encoding.decode(this.fieldBytes, pos, len);
                        break;
                    }
                    default: {
                        ArrayAssistant arrAssistant = ArrayAssistantRegistry.getAssistant(elementOid);
                        if (arrAssistant == null) break;
                        arr[i2] = arrAssistant.buildElement(this.fieldBytes, pos, len);
                    }
                }
                pos += len;
            }
        } else {
            for (int i3 = 0; i3 < dims[thisDimension]; ++i3) {
                pos = this.storeValues((Object[])arr[i3], elementOid, dims, pos, thisDimension + 1, 0);
            }
        }
        return pos;
    }

    private ResultSet readBinaryResultSet(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d2 = 0; d2 < dimensions; ++d2) {
            dims[d2] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (count > 0 && dimensions > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] fields = new Field[2];
        this.storeValues(rows, fields, elementOid, dims, pos, 0, index);
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    private int storeValues(List<byte[][]> rows, Field[] fields, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException {
        if (dims.length == 0) {
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", elementOid);
            fields[1].setFormat(1);
            for (int i2 = 1; i2 < index; ++i2) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else if (thisDimension == dims.length - 1) {
            int i3;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", elementOid);
            fields[1].setFormat(1);
            for (i3 = 1; i3 < index; ++i3) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i3 = 0; i3 < dims[thisDimension]; ++i3) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i3 + index);
                rows.add(rowData);
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                rowData[1] = new byte[len];
                System.arraycopy(this.fieldBytes, pos, rowData[1], 0, rowData[1].length);
                pos += len;
            }
        } else {
            int i4;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", this.oid);
            fields[1].setFormat(1);
            int nextDimension = thisDimension + 1;
            int dimensionsLeft = dims.length - nextDimension;
            for (i4 = 1; i4 < index; ++i4) {
                pos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
            }
            for (i4 = 0; i4 < dims[thisDimension]; ++i4) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i4 + index);
                rows.add(rowData);
                int dataEndPos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
                int dataLength = dataEndPos - pos;
                rowData[1] = new byte[12 + 8 * dimensionsLeft + dataLength];
                ByteConverter.int4(rowData[1], 0, dimensionsLeft);
                System.arraycopy(this.fieldBytes, 4, rowData[1], 4, 8);
                System.arraycopy(this.fieldBytes, 12 + nextDimension * 8, rowData[1], 12, dimensionsLeft * 8);
                System.arraycopy(this.fieldBytes, pos, rowData[1], 12 + dimensionsLeft * 8, dataLength);
                pos = dataEndPos;
            }
        }
        return pos;
    }

    private int calcRemainingDataLength(int[] dims, int pos, int elementOid, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i2 = 0; i2 < dims[thisDimension]; ++i2) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else {
            pos = this.calcRemainingDataLength(dims, elementOid, pos, thisDimension + 1);
        }
        return pos;
    }

    private Class<?> elementOidToClass(int oid) throws SQLException {
        switch (oid) {
            case 21: {
                return Short.class;
            }
            case 23: {
                return Integer.class;
            }
            case 20: {
                return Long.class;
            }
            case 700: {
                return Float.class;
            }
            case 701: {
                return Double.class;
            }
            case 25: 
            case 1043: {
                return String.class;
            }
        }
        ArrayAssistant arrElemBuilder = ArrayAssistantRegistry.getAssistant(oid);
        if (arrElemBuilder != null) {
            return arrElemBuilder.baseType();
        }
        throw Driver.notImplemented(this.getClass(), "readBinaryArray(data,oid)");
    }

    private synchronized void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = new KbArrayList();
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        if (this.fieldString != null) {
            char[] chars = this.fieldString.toCharArray();
            StringBuilder buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            ArrayList<KbArrayList> dims = new ArrayList<KbArrayList>();
            KbArrayList curArray = this.arrayList;
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i2 = startOffset; i2 < chars.length; ++i2) {
                if (chars[i2] == '\\') {
                    ++i2;
                } else {
                    if (!insideString && chars[i2] == '{') {
                        if (dims.isEmpty()) {
                            dims.add(this.arrayList);
                        } else {
                            KbArrayList a2 = new KbArrayList();
                            KbArrayList p2 = (KbArrayList)dims.get(dims.size() - 1);
                            p2.add(a2);
                            dims.add(a2);
                        }
                        curArray = (KbArrayList)dims.get(dims.size() - 1);
                        for (int t2 = i2 + 1; t2 < chars.length; ++t2) {
                            if (Character.isWhitespace(chars[t2])) continue;
                            if (chars[t2] != '{') break;
                            ++curArray.dimensionsCount;
                        }
                        buffer = new StringBuilder();
                        continue;
                    }
                    if (chars[i2] == '\"') {
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(chars[i2])) continue;
                    if (!insideString && (chars[i2] == delim || chars[i2] == '}') || i2 == chars.length - 1) {
                        String b2;
                        if (chars[i2] != '\"' && chars[i2] != '}' && chars[i2] != delim && buffer != null) {
                            buffer.append(chars[i2]);
                        }
                        String string = b2 = buffer == null ? null : buffer.toString();
                        if (b2 != null && (!b2.isEmpty() || wasInsideString)) {
                            curArray.add(!wasInsideString && b2.equals("NULL") ? null : b2);
                        }
                        wasInsideString = false;
                        buffer = new StringBuilder();
                        if (chars[i2] != '}') continue;
                        dims.remove(dims.size() - 1);
                        if (!dims.isEmpty()) {
                            curArray = (KbArrayList)dims.get(dims.size() - 1);
                        }
                        buffer = null;
                        continue;
                    }
                }
                if (buffer == null) continue;
                buffer.append(chars[i2]);
            }
        }
    }

    private Object buildArray(KbArrayList input, int index, int count) throws SQLException {
        int[] dimsLength;
        if (count < 0) {
            count = input.size();
        }
        Object[] ret = null;
        int dims = input.dimensionsCount;
        int[] nArray = dimsLength = dims > 1 ? new int[dims] : null;
        if (dims > 1) {
            for (int i2 = 0; i2 < dims; ++i2) {
                dimsLength[i2] = i2 == 0 ? count : 0;
            }
        }
        int length = 0;
        int type = this.connection.getTypeInfo().getSQLType(this.connection.getTypeInfo().getPGArrayElement(this.oid));
        if (type == -7) {
            boolean[] pa = null;
            Boolean[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Boolean.class : Boolean.TYPE, dimsLength) : new Boolean[count];
                ret = oa;
            } else {
                ret = pa = new boolean[count];
            }
            while (count > 0) {
                Object o2 = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o2 == null ? null : (dims > 1 ? this.buildArray((KbArrayList)o2, 0, -1) : Boolean.valueOf(BooleanTypeUtil.castToBoolean((String)o2)));
                } else {
                    pa[length++] = o2 == null ? false : BooleanTypeUtil.castToBoolean((String)o2);
                }
                --count;
            }
        } else if (type == 5 || type == 4) {
            int[] pa = null;
            Integer[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Integer.class : Integer.TYPE, dimsLength) : new Integer[count];
                ret = oa;
            } else {
                pa = new int[count];
                ret = pa;
            }
            while (count > 0) {
                Object o3 = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o3 == null ? null : (dims > 1 ? this.buildArray((KbArrayList)o3, 0, -1) : Integer.valueOf(KbResultSet.toInt((String)o3)));
                } else {
                    pa[length++] = o3 == null ? 0 : KbResultSet.toInt((String)o3);
                }
                --count;
            }
        } else if (type == -5) {
            long[] pa = null;
            Long[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Long.class : Long.TYPE, dimsLength) : new Long[count];
                ret = oa;
            } else {
                pa = new long[count];
                ret = pa;
            }
            while (count > 0) {
                Object o4 = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o4 == null ? null : (dims > 1 ? this.buildArray((KbArrayList)o4, 0, -1) : Long.valueOf(KbResultSet.toLong((String)o4)));
                } else {
                    pa[length++] = o4 == null ? 0L : KbResultSet.toLong((String)o4);
                }
                --count;
            }
        } else if (type == 2) {
            BigDecimal[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsLength) : new BigDecimal[count];
            ret = oa;
            while (count > 0) {
                Object v2 = input.get(index++);
                oa[length++] = dims > 1 && v2 != null ? this.buildArray((KbArrayList)v2, 0, -1) : (v2 == null ? null : KbResultSet.toBigDecimal((String)v2));
                --count;
            }
        } else if (type == 7) {
            float[] pa = null;
            Float[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Float.class : Float.TYPE, dimsLength) : new Float[count];
                ret = oa;
            } else {
                pa = new float[count];
                ret = pa;
            }
            while (count > 0) {
                Object o5 = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o5 == null ? null : (dims > 1 ? this.buildArray((KbArrayList)o5, 0, -1) : Float.valueOf(KbResultSet.toFloat((String)o5)));
                } else {
                    pa[length++] = o5 == null ? 0.0f : KbResultSet.toFloat((String)o5);
                }
                --count;
            }
        } else if (type == 8) {
            double[] pa = null;
            Double[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Double.class : Double.TYPE, dimsLength) : new Double[count];
                ret = oa;
            } else {
                pa = new double[count];
                ret = pa;
            }
            while (count > 0) {
                Object o6 = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o6 == null ? null : (dims > 1 ? this.buildArray((KbArrayList)o6, 0, -1) : Double.valueOf(KbResultSet.toDouble((String)o6)));
                } else {
                    pa[length++] = o6 == null ? 0.0 : KbResultSet.toDouble((String)o6);
                }
                --count;
            }
        } else if (type == 1 || type == 12 || this.oid == 3807) {
            String[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(String.class, dimsLength) : new String[count];
            ret = oa;
            while (count > 0) {
                Object v3 = input.get(index++);
                oa[length++] = dims > 1 && v3 != null ? this.buildArray((KbArrayList)v3, 0, -1) : v3;
                --count;
            }
        } else if (type == 91) {
            Date[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Date.class, dimsLength) : new Date[count];
            ret = oa;
            while (count > 0) {
                Object v4 = input.get(index++);
                oa[length++] = dims > 1 && v4 != null ? this.buildArray((KbArrayList)v4, 0, -1) : (v4 == null ? null : this.connection.getTimestampUtils().toDate(null, (String)v4));
                --count;
            }
        } else if (type == 92) {
            Time[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Time.class, dimsLength) : new Time[count];
            ret = oa;
            while (count > 0) {
                Object v5 = input.get(index++);
                oa[length++] = dims > 1 && v5 != null ? this.buildArray((KbArrayList)v5, 0, -1) : (v5 == null ? null : this.connection.getTimestampUtils().toTime(null, (String)v5));
                --count;
            }
        } else if (type == 93) {
            Timestamp[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsLength) : new Timestamp[count];
            ret = oa;
            while (count > 0) {
                Object v6 = input.get(index++);
                oa[length++] = dims > 1 && v6 != null ? this.buildArray((KbArrayList)v6, 0, -1) : (v6 == null ? null : this.connection.getTimestampUtils().toTimestamp(null, (String)v6));
                --count;
            }
        } else if (ArrayAssistantRegistry.getAssistant(this.oid) != null) {
            ArrayAssistant arrAssistant = ArrayAssistantRegistry.getAssistant(this.oid);
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(arrAssistant.baseType(), dimsLength) : (Object[])Array.newInstance(arrAssistant.baseType(), count);
            ret = oa;
            while (count > 0) {
                Object v7 = input.get(index++);
                oa[length++] = dims > 1 && v7 != null ? this.buildArray((KbArrayList)v7, 0, -1) : (v7 == null ? null : arrAssistant.buildElement((String)v7));
                --count;
            }
        } else if (dims == 1) {
            Object[] oa = new Object[count];
            String typeName = this.getBaseTypeName();
            while (count > 0) {
                Object v8;
                if ((v8 = input.get(index++)) instanceof String) {
                    oa[length++] = this.connection.getObject(typeName, (String)v8, null);
                } else if (v8 instanceof byte[]) {
                    oa[length++] = this.connection.getObject(typeName, null, (byte[])v8);
                } else if (v8 == null) {
                    oa[length++] = null;
                } else {
                    throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
                }
                --count;
            }
            ret = oa;
        } else {
            LOGGER.log(Level.FINEST, "getArrayImpl(long,int,Map) with {0}", this.getBaseTypeName());
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        return ret;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getBaseTypeName());
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.buildArrayList();
        int elementOID = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        return this.connection.getTypeInfo().getKBType(elementOID);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(map);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(index, count, map);
    }

    public ResultSet getResultSetImpl(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new KSQLException(GT.tr("The array index is out of range: {0}", index), KSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryResultSet((int)index, count);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new KSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", index + (long)count, this.arrayList.size()), KSQLState.DATA_ERROR);
        }
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] fields = new Field[2];
        if (this.arrayList.dimensionsCount <= 1) {
            int baseOid = this.connection.getTypeInfo().getPGArrayElement(this.oid);
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", baseOid);
            for (int i2 = 0; i2 < count; ++i2) {
                int offset = (int)index + i2;
                byte[][] t2 = new byte[2][0];
                String v2 = (String)this.arrayList.get(offset);
                t2[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t2[1] = v2 == null ? null : this.connection.encodeString(v2);
                rows.add(t2);
            }
        } else {
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", this.oid);
            for (int i3 = 0; i3 < count; ++i3) {
                int offset = (int)index + i3;
                byte[][] t3 = new byte[2][0];
                Object v3 = this.arrayList.get(offset);
                t3[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t3[1] = v3 == null ? null : this.connection.encodeString(this.toString((KbArrayList)v3));
                rows.add(t3);
            }
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        if (this.fieldString == null && this.fieldBytes != null) {
            try {
                Object array = this.readBinaryArray(1, 0);
                java.sql.Array tmpArray = this.connection.createArrayOf(this.getBaseTypeName(), (Object[])array);
                this.fieldString = tmpArray.toString();
            }
            catch (SQLException e2) {
                this.fieldString = "NULL";
            }
        }
        return this.fieldString;
    }

    private String toString(KbArrayList list) throws SQLException {
        if (list == null) {
            return "NULL";
        }
        StringBuilder b2 = new StringBuilder().append('{');
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object v2 = list.get(i2);
            if (i2 > 0) {
                b2.append(delim);
            }
            if (v2 == null) {
                b2.append("NULL");
                continue;
            }
            if (v2 instanceof KbArrayList) {
                b2.append(this.toString((KbArrayList)v2));
                continue;
            }
            KbArray.escapeArrayElement(b2, (String)v2);
        }
        b2.append('}');
        return b2.toString();
    }

    public static void escapeArrayElement(StringBuilder b2, String s2) {
        b2.append('\"');
        for (int j2 = 0; j2 < s2.length(); ++j2) {
            char c2 = s2.charAt(j2);
            if (c2 == '\"' || c2 == '\\') {
                b2.append('\\');
            }
            b2.append(c2);
        }
        b2.append('\"');
    }

    public boolean isBinary() {
        return this.fieldBytes != null;
    }

    public byte[] toBytes() {
        return this.fieldBytes;
    }

    @Override
    public void free() throws SQLException {
        this.connection = null;
        this.fieldString = null;
        this.fieldBytes = null;
        this.arrayList = null;
    }

    static {
        ArrayAssistantRegistry.register(2950, new UUIDArrayAssistant());
        ArrayAssistantRegistry.register(2951, new UUIDArrayAssistant());
    }

    private static class KbArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private KbArrayList() {
        }
    }
}

