/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.xa;

import com.kingbase8.util.Base64;
import java.util.Arrays;
import javax.transaction.xa.Xid;

class RecoveredXid
implements Xid {
    int formatId;
    byte[] globalTransactionId;
    byte[] branchQualifier;

    RecoveredXid() {
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        result = 31 * result + this.formatId;
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        return result;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o2;
        if (other.getFormatId() != this.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public String toString() {
        return RecoveredXid.xidToString(this);
    }

    static String xidToString(Xid xid) {
        return xid.getFormatId() + "_" + Base64.encodeBytes(xid.getGlobalTransactionId(), 8) + "_" + Base64.encodeBytes(xid.getBranchQualifier(), 8);
    }

    static Xid stringToXid(String s2) {
        int b2;
        RecoveredXid xid = new RecoveredXid();
        int a2 = s2.indexOf("_");
        if (a2 == (b2 = s2.lastIndexOf("_"))) {
            return null;
        }
        try {
            xid.formatId = Integer.parseInt(s2.substring(0, a2));
            xid.globalTransactionId = Base64.decode(s2.substring(a2 + 1, b2));
            xid.branchQualifier = Base64.decode(s2.substring(b2 + 1));
            if (xid.globalTransactionId == null || xid.branchQualifier == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return xid;
    }
}

