/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class AdddateSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String column;
    private final String num;
    private final String type;

    public AdddateSqlNode(SqlNode sqlNode, Configuration configuration, String column, String num, String type) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.column = column == null ? "" : column;
        this.num = num == null ? "" : num;
        this.type = type == null ? "" : type;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("date_add(" + this.column + ",interval " + this.num + " " + this.type + ")");
                break;
            }
            case "oracle": {
                if ("second".equals(this.type)) {
                    context.appendSql(this.column + "+numtodsinterval(" + this.num + ",'second')");
                    break;
                }
                if ("minute".equals(this.type)) {
                    context.appendSql(this.column + "+numtodsinterval(" + this.num + ",'minute')");
                    break;
                }
                if ("hour".equals(this.type)) {
                    context.appendSql(this.column + "+numtodsinterval(" + this.num + ",'hour')");
                    break;
                }
                if ("day".equals(this.type)) {
                    context.appendSql(this.column + this.num);
                    break;
                }
                if ("month".equals(this.type)) {
                    context.appendSql("add_months(" + this.column + "," + this.num + ")");
                    break;
                }
                if (!"year".equals(this.type)) break;
                Integer i2 = Integer.parseInt(this.num);
                context.appendSql("add_months(" + this.column + "," + 12 * i2 + ")");
                break;
            }
            case "db2": {
                context.appendSql("TIMESTAMP(" + this.column + ")+" + this.num + " " + this.type);
                break;
            }
            case "postgresql": {
                context.appendSql(this.column + " + INTERVAL '" + this.num + " " + this.type + "'");
                break;
            }
            case "sqlserver2005": {
                context.appendSql("DATEADD(" + this.type + "," + this.num + "," + this.column + ")");
                break;
            }
            case "sqlserver": {
                context.appendSql("DATEADD(" + this.type + "," + this.num + "," + this.column + ")");
                break;
            }
            case "dm": {
                context.appendSql("DATEADD(" + this.type + "," + this.num + "," + this.column + ")");
                break;
            }
            case "kingbase8": {
                context.appendSql(this.column + " + INTERVAL '" + this.num + " " + this.type + "'");
                break;
            }
            default: {
                context.appendSql("date_add(" + this.column + ",interval " + this.num + " " + this.type + ")");
            }
        }
        return true;
    }
}

