/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class ConcatStrSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String column1;
    private final String column2;

    public ConcatStrSqlNode(SqlNode sqlNode, Configuration configuration, String column1, String column2) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.column1 = column1;
        this.column2 = column2;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("CONCAT(" + this.column1 + "," + this.column2 + ")");
                break;
            }
            case "oracle": {
                context.appendSql("CONCAT(" + this.column1 + "," + this.column2 + ")");
                break;
            }
            case "db2": {
                context.appendSql(this.column1 + "||" + this.column2);
                break;
            }
            case "postgresql": {
                context.appendSql(this.column1 + "||" + this.column2);
                break;
            }
            case "sqlserver2005": {
                context.appendSql(this.column1 + "+" + this.column2);
                break;
            }
            case "sqlserver": {
                context.appendSql(this.column1 + "+" + this.column2);
                break;
            }
            case "dm": {
                context.appendSql("CONCAT(" + this.column1 + "," + this.column2 + ")");
                break;
            }
            case "kingbase8": {
                context.appendSql("CONCAT(" + this.column1 + "," + this.column2 + ")");
                break;
            }
            default: {
                context.appendSql("CONCAT(" + this.column1 + "," + this.column2 + ")");
            }
        }
        return true;
    }
}

