/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class DateCompareSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String column;
    private final String str;
    private final String operation;

    public DateCompareSqlNode(SqlNode sqlNode, Configuration configuration, String column, String str, String operation) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.column = column;
        this.str = str;
        this.operation = operation;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql(this.column + this.operation + "STR_TO_DATE('" + this.str + "','%Y-%m-%d %H:%i:%S')");
                break;
            }
            case "oracle": {
                context.appendSql(this.column + this.operation + "to_date('" + this.str + "','yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "db2": {
                context.appendSql(this.column + this.operation + "to_date('" + this.str + "','yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "postgresql": {
                context.appendSql(this.column + this.operation + "to_date('" + this.str + "','yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "sqlserver2005": {
                context.appendSql(this.column + this.operation + "convert(datetime,'" + this.str + "')");
                break;
            }
            case "sqlserver": {
                context.appendSql(this.column + this.operation + "convert(datetime,'" + this.str + "')");
                break;
            }
            case "dm": {
                context.appendSql(this.column + this.operation + "to_date('" + this.str + "','yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "kingbase8": {
                context.appendSql(this.column + this.operation + "to_date('" + this.str + "','yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            default: {
                context.appendSql(this.column + this.operation + "STR_TO_DATE('" + this.str + "','%Y-%m-%d %H:%i:%S')");
            }
        }
        return true;
    }
}

