/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class ExtractSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String prefix;
    private final String suffix;

    public ExtractSqlNode(SqlNode sqlNode, Configuration configuration, String prefix, String suffix) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public boolean apply(DynamicContext context) {
        String format = "";
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
                break;
            }
            case "oracle": {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
                break;
            }
            case "db2": {
                break;
            }
            case "postgresql": {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
                break;
            }
            case "sqlserver2005": {
                if (this.prefix != null && this.prefix.length() != 0) {
                    format = this.prefix.trim().toLowerCase();
                    if ("year".equals(format)) {
                        format = "yy";
                    } else if ("month".equals(format)) {
                        format = "mm";
                    } else if ("day".equals(format)) {
                        format = "dd";
                    } else if ("hour".equals(format)) {
                        format = "hh";
                    }
                }
                context.appendSql("DATEPART(" + format + " FROM " + this.suffix + ")");
                break;
            }
            case "sqlserver": {
                if (this.prefix != null && this.prefix.length() != 0) {
                    format = this.prefix.trim().toLowerCase();
                    if ("year".equals(format)) {
                        format = "yy";
                    } else if ("month".equals(format)) {
                        format = "mm";
                    } else if ("day".equals(format)) {
                        format = "dd";
                    } else if ("hour".equals(format)) {
                        format = "hh";
                    }
                }
                context.appendSql("DATEPART(" + format + " FROM " + this.suffix + ")");
                break;
            }
            case "dm": {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
                break;
            }
            case "kingbase8": {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
                break;
            }
            default: {
                context.appendSql("EXTRACT(" + this.prefix + " FROM " + this.suffix + ")");
            }
        }
        return true;
    }
}

