/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class GroupConcatSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String column;
    private final String separator;

    public GroupConcatSqlNode(SqlNode sqlNode, Configuration configuration, String column, String separator) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.column = column == null ? "" : column;
        this.separator = separator == null ? "" : separator;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("group_concat(" + this.column + ")");
                break;
            }
            case "oracle": {
                context.appendSql(this.column);
                break;
            }
            case "db2": {
                context.appendSql(this.column);
                break;
            }
            case "postgresql": {
                context.appendSql("array_to_string(group_concat(" + this.column + "), '" + this.separator + "')");
                break;
            }
            case "sqlserver2005": {
                context.appendSql(this.column);
                break;
            }
            case "sqlserver": {
                context.appendSql(this.column);
                break;
            }
            case "dm": {
                context.appendSql(this.column);
                break;
            }
            case "kingbase8": {
                context.appendSql(this.column);
                break;
            }
            default: {
                context.appendSql(this.column);
            }
        }
        return true;
    }
}

