/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class SubstrSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String column;
    private final String index;
    private final String length;

    public SubstrSqlNode(SqlNode sqlNode, Configuration configuration, String column, String index, String length) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.column = column;
        this.index = index;
        this.length = length;
    }

    @Override
    public boolean apply(DynamicContext context) {
        String str = null;
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                str = "substring";
                break;
            }
            case "oracle": {
                str = "substr";
                break;
            }
            case "db2": {
                str = "substr";
                break;
            }
            case "postgresql": {
                str = "substring";
                break;
            }
            case "sqlserver2005": {
                str = "substring";
                break;
            }
            case "sqlserver": {
                str = "substring";
                break;
            }
            case "dm": {
                str = "substr";
                break;
            }
            case "kingbase8": {
                str = "substr";
                break;
            }
            default: {
                str = "substring";
            }
        }
        if (this.length != null && this.length.length() > 0) {
            context.appendSql(str + "(" + this.column + "," + this.index + "," + this.length + ")");
        } else {
            context.appendSql(str + "(" + this.column + "," + this.index + ")");
        }
        return true;
    }
}

