/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class ToNumberSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String prefix;
    private final String suffix;

    public ToNumberSqlNode(SqlNode sqlNode, Configuration configuration, String prefix, String suffix) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("CAST(" + this.prefix + " AS SIGNED)");
                break;
            }
            case "oracle": {
                context.appendSql("to_number(" + this.prefix + ")");
                break;
            }
            case "db2": {
                context.appendSql("cast(" + this.prefix + " as bigint)");
                break;
            }
            case "postgresql": {
                context.appendSql("cast(" + this.prefix + " as integer)");
                break;
            }
            case "sqlserver2005": {
                context.appendSql("convert(bigint," + this.prefix + ")");
                break;
            }
            case "sqlserver": {
                context.appendSql("convert(bigint," + this.prefix + ")");
                break;
            }
            case "dm": {
                context.appendSql("to_number(" + this.prefix + ")");
                break;
            }
            case "kingbase8": {
                context.appendSql("to_number(" + this.prefix + ")");
                break;
            }
            default: {
                context.appendSql("CAST(" + this.prefix + " AS SIGNED)");
            }
        }
        return true;
    }
}

