/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class TodateSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String prefix;
    private final String suffix;

    public TodateSqlNode(SqlNode sqlNode, Configuration configuration, String prefix, String suffix) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("STR_TO_DATE(" + this.prefix + ",'%Y-%m-%d %H:%i:%S')");
                break;
            }
            case "oracle": {
                context.appendSql("to_date(" + this.prefix + ",'yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "db2": {
                context.appendSql("to_date(" + this.prefix + ",'yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "postgresql": {
                context.appendSql("to_date(" + this.prefix + ",'yyyy-mm-dd hh24:mi:ss')");
                break;
            }
            case "sqlserver2005": {
                context.appendSql("convert(datetime," + this.prefix + ")");
                break;
            }
            case "sqlserver": {
                context.appendSql("convert(datetime," + this.prefix + ")");
                break;
            }
            case "dm": {
                context.appendSql("to_date(" + this.prefix + ",'YYYY-MM-DD HH24:MI:SS')");
                break;
            }
            case "kingbase8": {
                context.appendSql("to_date(" + this.prefix + ",'YYYY-MM-DD HH24:MI:SS')");
                break;
            }
            default: {
                context.appendSql("STR_TO_DATE(" + this.prefix + ",'%Y-%m-%d %H:%i:%S')");
            }
        }
        return true;
    }
}

