/*
 * Decompiled with CFR 0.152.
 */
package com.zenith.support.xmltags;

import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class TrimStrSqlNode
implements SqlNode {
    private final Configuration configuration;
    private final SqlNode sqlNode;
    private final String prefix;
    private final String suffix;

    public TrimStrSqlNode(SqlNode sqlNode, Configuration configuration, String prefix, String suffix) {
        this.sqlNode = sqlNode;
        this.configuration = configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public boolean apply(DynamicContext context) {
        switch (this.configuration.getDatabaseId()) {
            case "mysql": {
                context.appendSql("trim(" + this.prefix + ")");
                break;
            }
            case "oracle": {
                context.appendSql("trim(" + this.prefix + ")");
                break;
            }
            case "db2": {
                context.appendSql("rtrim(ltrim(" + this.prefix + "))");
                break;
            }
            case "postgresql": {
                context.appendSql("trim(" + this.prefix + ")");
                break;
            }
            case "sqlserver2005": {
                context.appendSql("rtrim(ltrim(" + this.prefix + "))");
                break;
            }
            case "sqlserver": {
                context.appendSql("rtrim(ltrim(" + this.prefix + "))");
                break;
            }
            case "dm": {
                context.appendSql("trim(" + this.prefix + ")");
                break;
            }
            case "kingbase8": {
                context.appendSql("trim(" + this.prefix + ")");
                break;
            }
            default: {
                context.appendSql("trim(" + this.prefix + ")");
            }
        }
        return true;
    }
}

