/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import java.sql.SQLException;
import java.util.Calendar;

public class DmShortBinder
extends DmBinder {
    public DmShortBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 6;
        this.recPrec = 2;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        byte[] ret = null;
        ret = this.isDiffParamObjectType() && !(obj instanceof Short) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.paramsDesc[icol].getTypeDescriptor()) : DmShortBinder.toDbBytes((Short)obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.defaultCalendar);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(short x2, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, Calendar defaultCalendar) throws SQLException {
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 6: {
                    ret = Convertion.shortToByteArray(x2);
                    break;
                }
                case 3: 
                case 13: {
                    ret = Convertion.booleanToByteArray(x2 != 0);
                    break;
                }
                case 5: {
                    if (x2 > 127 || x2 < -128) {
                        DBError.throwSQLException(6004);
                    }
                    ret = Convertion.byteToByteArray((byte)x2);
                    break;
                }
                case 7: {
                    ret = Convertion.intToByteArray(x2);
                    break;
                }
                case 8: {
                    ret = Convertion.longToByteArray(x2);
                    break;
                }
                case 10: {
                    ret = Convertion.floatToByteArray(x2);
                    break;
                }
                case 11: {
                    ret = Convertion.doubleToByteArray(x2);
                    break;
                }
                case 9: {
                    ret = Convertion.BigDecimalToByteArray(String.valueOf(x2), destPrec, destScale);
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(x2), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(x2), destPrec, destDType, serverEncoding);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    ret = DmdbTimestamp.encodeByDateNumber(x2, destDType, destScale, defaultCalendar, ltz, dbTz);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return DmShortBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

