/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.xa.DmdbXid;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.xa.XAException;

public class DmMsgRecv {
    static int maxBufferSize = 200;
    static ReentrantLock lock = new ReentrantLock();
    static LinkedList<byte[]> bufferList = new LinkedList();
    static int curBufferSize = 0;
    byte[] buffer = null;
    private int errlen = 0;
    private boolean m_fromStandby = false;

    public DmMsgRecv() {
        byte[] varBuffer = null;
        try {
            lock.lock();
            if (curBufferSize > 0) {
                varBuffer = bufferList.removeFirst();
                --curBufferSize;
            }
        }
        finally {
            lock.unlock();
        }
        if (varBuffer == null) {
            varBuffer = new byte[32640];
        }
        this.buffer = varBuffer;
    }

    public void close() {
        try {
            lock.lock();
            if (curBufferSize < maxBufferSize) {
                bufferList.addLast(this.buffer);
                ++curBufferSize;
            }
        }
        finally {
            lock.unlock();
        }
        this.buffer = null;
    }

    void setFromStandby(boolean fromStandby) {
        this.m_fromStandby = fromStandby;
    }

    public boolean getFromStandby() {
        return this.m_fromStandby;
    }

    public void setBuffer(int size) {
        if (size > this.buffer.length) {
            byte[] varBuffer = new byte[size];
            System.arraycopy(this.buffer, 0, varBuffer, 0, this.buffer.length);
            this.buffer = varBuffer;
        }
    }

    public int getBufLength() {
        return this.buffer.length;
    }

    private final long getInt(int size, int offset) {
        long n2 = 0L;
        int p2 = offset + size;
        int i2 = 0;
        while (i2 < size) {
            long b2 = 0xFF & this.buffer[--p2];
            n2 = b2 | n2 << 8;
            ++i2;
        }
        return n2;
    }

    public final byte getByte(int offset) {
        return this.buffer[offset];
    }

    public final int getShort(int offset) {
        return Convertion.getUShort(this.buffer, offset);
    }

    public final long getInt(int offset) {
        return Convertion.getUInt(this.buffer, offset);
    }

    public final long getLong(int offset) {
        long l2 = this.getInt(8, offset);
        return l2;
    }

    public final String getString(int offset, int byteLen, String charsetName) {
        return Convertion.getString(this.buffer, offset, byteLen, charsetName);
    }

    public final byte[] getBytes(int offset, int len) {
        return Convertion.getBytes(this.buffer, offset, len);
    }

    public final byte[] getBytes(int offset, int len, String charsetName, String destCharsetName) {
        return Convertion.getBytes(this.buffer, offset, len, charsetName, destCharsetName);
    }

    public final long getOffsetOfPrintMsg() {
        return this.getInt(39);
    }

    public final byte getCRC() {
        return this.getByte(19);
    }

    public final boolean checkCRC() {
        byte calc;
        byte recv = this.res_get_crc();
        return recv == (calc = this.calculateCRC());
    }

    public boolean getUnname(int offset) {
        return this.getInt(offset + 18) != 0L;
    }

    public short getParamType(int offset) {
        return (short)this.getShort(offset + 22);
    }

    public boolean getNullable(int offset) {
        return this.getInt(offset + 12) != 0L;
    }

    public byte getParamRecommandType(int offset) {
        short tmp = (short)this.getShort(offset + 16);
        if ((tmp & 8) != 0) {
            return 2;
        }
        return 1;
    }

    public short getItemFlag(int offset) {
        return (short)this.getShort(offset + 16);
    }

    public int getFixSize(int offset) {
        return (int)this.getInt(offset + 32);
    }

    public short getNameLen(int offset) {
        return (short)this.getShort(offset + 24);
    }

    public short getTypeNameLen(int offset) {
        return (short)this.getShort(offset + 26);
    }

    public short getTableLen(int offset) {
        return (short)this.getShort(offset + 28);
    }

    public short getSchemaLen(int offset) {
        return (short)this.getShort(offset + 30);
    }

    public int getdType(int offset) {
        return (int)this.getInt(offset + 0);
    }

    public int getPrec(int offset) {
        return (int)this.getInt(offset + 4);
    }

    public int getScale(int offset) {
        return (int)this.getInt(offset + 8);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getErrlen() {
        return this.errlen;
    }

    public void resetErrlen() {
        this.errlen = 0;
    }

    public String respErrorInfo(String charsetName) {
        int offset = 64;
        long len = this.getInt(offset);
        offset += 4;
        offset = (int)((long)offset + len);
        len = this.getInt(offset);
        offset += 4;
        offset = (int)((long)offset + len);
        len = this.getInt(offset);
        offset += 4;
        offset = (int)((long)offset + len);
        len = this.getInt(offset);
        this.errlen = (int)((long)(offset += 4) + len - 64L);
        if (charsetName == null || "" == charsetName) {
            return null;
        }
        if (len > Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        return Convertion.getString(this.buffer, offset, (int)len, charsetName);
    }

    public int res_get_compress() {
        return this.getByte(18);
    }

    public int res_get_stmtid() {
        return (int)this.getInt(0);
    }

    public short res_get_ret() {
        return (short)this.getShort(4);
    }

    public long res_get_len() {
        return this.getInt(6);
    }

    public void res_set_len(int len) {
        this.setInt(len, 6);
    }

    public void setInt(int val, int offset) {
        byte[] ret = Convertion.intToByteArray(val);
        this.setBytes(ret, 0, offset, ret.length);
    }

    public void setBytes(byte[] src, int src_offset, int offset, int len) {
        System.arraycopy(src, src_offset, this.buffer, offset, len);
    }

    public int res_get_sqlcode() {
        return (int)this.getInt(10);
    }

    public byte res_get_crc() {
        return this.getByte(19);
    }

    public final void setCRC(byte crc) {
        byte[] ret = new byte[]{crc};
        System.arraycopy(ret, 0, this.buffer, 19, ret.length);
    }

    public int res_startup_get_encrypt_type() {
        return (int)this.getInt(20);
    }

    public int res_startup_get_serial() {
        return (int)this.getInt(24);
    }

    public int res_startup_get_ucflag() {
        return (int)this.getInt(28);
    }

    public int res_startup_get_cmpflag() {
        return (int)this.getInt(32);
    }

    public byte res_startup_get_rs_bdta_flag() {
        return this.getByte(42);
    }

    public byte res_startup_get_comm_enc_flag() {
        return this.getByte(41);
    }

    public byte res_startup_get_gen_keypair_flag() {
        return this.getByte(40);
    }

    public long res_login_get_max_data_len() {
        return this.getInt(20);
    }

    public int res_login_get_max_session() {
        return (int)this.getInt(24);
    }

    public byte res_login_get_ddl_auto_commit() {
        return this.getByte(28);
    }

    public int res_login_get_iso_level() {
        return (int)this.getInt(29);
    }

    public byte res_login_get_str_case_sensitive() {
        return this.getByte(33);
    }

    public byte res_login_get_back_slash() {
        return this.getByte(34);
    }

    public int res_login_get_svr_stat() {
        return this.getShort(37);
    }

    public int res_login_get_svr_mode() {
        return this.getShort(35);
    }

    public byte res_login_get_const_para_opt() {
        return this.getByte(39);
    }

    public short res_login_get_db_tz() {
        return (short)this.getShort(40);
    }

    public byte res_login_get_new_lob_flag() {
        return this.getByte(43);
    }

    public int res_login_get_resp_standby() {
        return this.getByte(42);
    }

    public byte res_alloc_stmt_get_new_col_desc_flag() {
        return this.getByte(20);
    }

    public int res_prepare_get_trans_status() {
        return (int)this.getInt(34);
    }

    public short res_prepare_get_ret_type() {
        return (short)this.getShort(20);
    }

    public short res_prepare_get_param_num() {
        return (short)this.getShort(22);
    }

    public short res_prepare_get_col_num() {
        return (short)this.getShort(24);
    }

    public long res_prepare_get_rowid() {
        return this.getLong(26);
    }

    public short res_execute_get_ret_type() {
        return (short)this.getShort(20);
    }

    public short res_execute_get_col_num() {
        return (short)this.getShort(22);
    }

    public long res_execute_get_row_num() {
        return this.getLong(24);
    }

    public short res_execute_get_param_num() {
        return (short)this.getShort(32);
    }

    public byte res_execute_get_rs_updatable() {
        return this.getByte(34);
    }

    public int res_execute_get_fetched_rows() {
        return (int)this.getInt(35);
    }

    public long res_execute_get_rowid() {
        return this.getLong(43);
    }

    public byte res_execute_rs_bdta_flag() {
        return this.getByte(43);
    }

    public short res_execute_rs_rowid_colindex() {
        return (short)this.getShort(44);
    }

    public long res_execute_get_exid() {
        return this.getInt(51);
    }

    public int res_rsCache_offset() {
        return (int)this.getInt(55);
    }

    public boolean res_execute_rowcnt_flag() {
        byte bt = this.getByte(59);
        return (bt & 1) == 1;
    }

    public boolean res_execute_retid_flag() {
        byte retFlag = this.getByte(59);
        return (retFlag & 2) == 2;
    }

    public boolean res_execute_rowid_valid() {
        byte retFlag = this.getByte(59);
        return (retFlag & 4) == 4;
    }

    public int res_execute_trans_status() {
        return (int)this.getInt(60);
    }

    public long res_fetch_get_row_count() {
        return this.getLong(20);
    }

    public int res_fetch_get_ret_count() {
        return (int)this.getInt(28);
    }

    public final byte calculateCRC() {
        byte crc = this.buffer[0];
        int times = 19;
        byte single = this.buffer[1];
        int i2 = 1;
        while (i2 < times) {
            single = this.buffer[i2];
            crc = (byte)(crc ^ single);
            i2 = (byte)(i2 + 1);
        }
        return crc;
    }

    public int res_get_xa_sqlcode() {
        return (int)this.getInt(64);
    }

    public int res_get_xa_recovery_endflag() {
        return (int)this.getInt(68);
    }

    public int res_get_xa_recovery_xid_count() {
        return (int)this.getInt(72);
    }

    public DmdbXid res_get_xa_recovery_xid(int index) throws XAException {
        int startIndex = 76 + 140 * index;
        return new DmdbXid((int)this.getInt(startIndex), this.getBytes(startIndex + 12, (int)this.getInt(startIndex + 4)), this.getBytes(startIndex + 12 + 64, (int)this.getInt(startIndex + 8)));
    }
}

