/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DataOfFetch;
import dm.jdbc.dbaccess.DbAccessPure;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.DmdbRwAutoDistribute;
import dm.jdbc.dbaccess.DmdbRwUserDistribute;
import dm.jdbc.dbaccess.DmdbSingleDistribute;
import dm.jdbc.dbaccess.Request_Response;
import dm.jdbc.desc.PreExeced;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbLobLocator;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.parser.DmdbExecOpt;
import dm.jdbc.util.StringUtil;
import dm.jdbc.xa.DmdbXAResource;
import dm.jdbc.xa.DmdbXid;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class DmdbCSI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void connToPrimary(DmdbConnection_bs conn) throws SQLException, IOException {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmdbCSI.connToServerInner(conn, conn.m_msg, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean connToStandby(DmdbConnection_bs conn) {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            try {
                if (StringUtil.isNotEmpty(conn.getStandbyHost())) {
                    conn.getDbAccess().setAccessStandby(new DbAccessPure(conn, conn.getStandbyHost(), conn.getStandbyPort()));
                    DmdbCSI.connToServerInner(conn, conn.m_msg, 0);
                    return true;
                }
            }
            catch (Exception exception) {
                conn.getDbAccess().removeStandby();
            }
            {
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int allocStmtHandle(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_stmt_alloc(msg);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            return Request_Response.resp_stmt_alloc(recvMsg, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int allocStmtHandleOnStandby(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_stmt_alloc(msg);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, 0);
            return Request_Response.resp_stmt_alloc(recvMsg, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmMsgRecv sendCurPosInfo(DmdbStatement_bs stmt, long curPos) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgRecv recvMsg = null;
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_execute_sendCurInfo(false, msg, stmt, curPos);
            recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            Request_Response.resp_execute(recvMsg, stmt, 1);
            return recvMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_close_stmt(msg, stmt.getHandle());
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            if (recvMsg != null) {
                Request_Response.resp_close_stmt(recvMsg, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void freeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_stmt_free(msg, stmt.getHandle());
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            if (recvMsg != null) {
                Request_Response.resp_stmt_free(recvMsg, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbInfo prepareSQL(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag, int rwDestType) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgRecv recvMsg = null;
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_prepare(msg, stmt, sql, direct, checkFlag);
            recvMsg = rwDestType == -1 ? DmdbCSI.accessToServer(msg, conn, stmt) : DmdbCSI.accessToServer(msg, conn, stmt, rwDestType);
            return Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbInfo rePrepareOnPrimary(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag) throws SQLException, IOException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend sendMsg = new DmMsgSend();
            Request_Response.req_prepare(sendMsg, stmt, sql, direct, checkFlag);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(sendMsg, conn, stmt, 1);
            DmdbInfo dmdbInfo = Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
            if (recvMsg != null) {
                recvMsg.close();
            }
            return dmdbInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbInfo directExec_Opt(DmdbStatement_bs stmt, DmdbExecOpt execOpt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_exec_direct(msg, stmt, execOpt);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, conn, stmt);
            return Request_Response.resp_exec_direct(recv, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void commitWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_commit(msg);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null);
            int sqlcode = Request_Response.resp_commit(recvMsg, conn);
            if (sqlcode >= 0 && holdability == 2) {
                conn.close_all_resultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void rollbackWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_rollback(msg);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null);
            int sqlcode = Request_Response.resp_rollback(recvMsg, conn);
            if (sqlcode >= 0 && holdability == 2) {
                conn.close_all_resultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbInfo executePrepared(DmdbStatement_bs stmt, int irow) throws SQLException {
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            return DmdbCSI.executePrepared(new PreExeced(false), stmt, irow, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int[] executePreparedBatch(DmdbPreparedStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            int batchSize = stmt.getBatchSize();
            int[] retArr = new int[batchSize];
            int[] retTmp = null;
            PreExeced preExeced = new PreExeced(false);
            DmMsgRecv recv = null;
            int startRow = 0;
            int nextRow = 0;
            int i2 = 0;
            while (i2 < batchSize) {
                retArr[i2] = -2;
                ++i2;
            }
            DmMsgSend msg = conn.m_msg;
            while (startRow < batchSize) {
                nextRow = DmdbCSI.setBatchParasMsg(preExeced, startRow, msg, stmt);
                if (nextRow != startRow && (retTmp = DmdbCSI.getBatchRowCounts(recv = DmdbCSI.accessToServer(msg, conn, stmt), stmt, nextRow - startRow)) != null) {
                    System.arraycopy(retTmp, 0, retArr, startRow, nextRow - startRow);
                }
                if (nextRow == batchSize) break;
                DmdbInfo retdbInfo = DmdbCSI.executePrepared(preExeced, stmt, nextRow, msg);
                preExeced.setPreExeced(true);
                retArr[nextRow] = retdbInfo.getRowCount() > Integer.MAX_VALUE ? -2 : (int)retdbInfo.getRowCount();
                startRow = nextRow + 1;
            }
            return retArr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbInfo getMoreResult(DmdbStatement_bs stmt, short resId) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_more_result(msg, stmt.getHandle(), resId);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, conn, stmt);
            return DmdbCSI.getDescAndResultSet(stmt, recv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void putBlobData(DmdbPreparedStatement_bs stmt, int irow, int paramIndex, DmBinder binder) throws SQLException {
        DmdbConnection_bs conn = stmt.getConnection_bs();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = new DmMsgSend();
            while (true) {
                msg.resetCurNode();
                int retLen = binder.bindLobCyc(msg, irow, paramIndex);
                if (retLen == 0) break;
                DmdbCSI.putData(stmt, msg, paramIndex, retLen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBlobData(DmdbStatement_bs stmt, DmdbConnection_bs conn, DmdbLobLocator lobLocator, boolean fromStandby) throws SQLException {
        Vector<byte[]> vec = new Vector<byte[]>(10);
        boolean isOver = false;
        DmMsgRecv recvMsg = null;
        int cntHasGet = 0;
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            while (!isOver) {
                Request_Response.req_get_data(msg, stmt.getHandle(), cntHasGet, lobLocator);
                recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
                isOver = Request_Response.resp_get_data(recvMsg, conn, lobLocator, cntHasGet);
                vec.add(lobLocator.m_dataOnceGet);
                cntHasGet += lobLocator.m_dataOnceGet.length;
            }
        }
        byte[] retData = new byte[cntHasGet];
        int tmp = 0;
        byte[] aBlockData = null;
        int i2 = 0;
        while (i2 < vec.size()) {
            aBlockData = (byte[])vec.get(i2);
            System.arraycopy(aBlockData, 0, retData, tmp, aBlockData.length);
            tmp += aBlockData.length;
            ++i2;
        }
        return retData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int fetch(DmdbStatement_bs stmt, long curPos, boolean fetchAll, DmdbResultSet_bs resultSet, short resId, boolean fromStandby) throws SQLException {
        int sqlcode = 0;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DataOfFetch dataOfFetch = new DataOfFetch(Long.MAX_VALUE, curPos, resId);
        byte[] buf = null;
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            while (true) {
                Request_Response.req_fetch(msg, stmt.getHandle(), dataOfFetch);
                DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
                sqlcode = Request_Response.resp_fetch_checkErr(recvMsg, conn);
                if (sqlcode == -7036) {
                    if (resultSet == null) break;
                    resultSet.rowCount = recvMsg.res_fetch_get_row_count();
                    break;
                }
                buf = Request_Response.resp_fetch_without_checkErr(recvMsg, dataOfFetch, resultSet, true);
                if (resultSet != null && resultSet.rowCount > 0L && (!fetchAll ? (long)dataOfFetch.getResRetCnt() == resultSet.rowCount : (long)(resultSet.getRsCache().getRownum() + dataOfFetch.getResRetCnt()) == resultSet.rowCount)) break;
                if (sqlcode == 100) {
                    if (resultSet == null || resultSet.rowCount != Long.MAX_VALUE) break;
                    resultSet.rowCount = dataOfFetch.getCurPos();
                    break;
                }
                if (!fetchAll) break;
                if (buf == null) continue;
                resultSet.getRsCache().addBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            }
        }
        if (buf != null) {
            if (fetchAll) {
                resultSet.getRsCache().addBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            } else if (resultSet.multiRsCaches()) {
                DmdbResultSetCache tmp = stmt.getDmdbInfo().isBdtaRs() ? new DmdbResultSetCache_v(resultSet.getRsCache().getStatement(), resultSet.getRsCache().cols, -1) : new DmdbResultSetCache_h(resultSet.getRsCache().getStatement(), resultSet.getRsCache().cols);
                tmp.fillBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
                resultSet.addRsCache(tmp);
            } else {
                resultSet.getRsCache().fillBuffer(buf, (int)dataOfFetch.getMsgLen(), dataOfFetch.getResRetCnt());
            }
        }
        return sqlcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setCursorName(DmdbStatement_bs stmt, String cursorName) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_cursor_set_name(msg, conn.getServerEncoding(), stmt.getHandle(), cursorName);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            Request_Response.resp_cursor_set_name(recvMsg, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getExplainInfo(DmdbStatement_bs stmt, String sqlToExplain) throws SQLException {
        if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!sqlToExplain.equalsIgnoreCase("show_pln_stat")) {
            sqlToExplain = "EXPLAIN " + sqlToExplain;
        }
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_prepare(msg, stmt, sqlToExplain, true, 0);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            DmdbInfo des = Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, true);
            return des.getExplain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long blob_text_truncate(DmdbLob lob, byte flag, int length, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = lob.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_lob_truncate(msg, lob.getLobLocator(), length);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
            return Request_Response.resp_lob_truncate(recv, lob.getLobLocator(), lob.getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long lob_get_len(DmdbLob lob, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = lob.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = new DmMsgSend();
            Request_Response.req_get_lob_len(msg, lob.getLobLocator());
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
            return Request_Response.resp_get_lob_len(recv, lob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] lob_get_bytes(DmdbLob lob, byte flag, int start_pos, int length, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = lob.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = new DmMsgSend();
            Request_Response.req_get_lob_data(msg, lob.getLobLocator(), start_pos, length);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
            return Request_Response.resp_get_lob_data(recv, lob.getLobLocator(), lob.getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int lob_set_bytes(DmdbLob lob, byte flag, int start_pos, byte[] buf, int off, int len, byte firstOrLast, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = lob.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_set_lob_data(msg, lob.getLobLocator(), start_pos, buf, off, len, firstOrLast);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, lob.getConnection(), null);
            return Request_Response.resp_set_lob_data(recv, lob.getLobLocator(), lob.getConnection());
        }
    }

    public static final String text_get_subString(DmdbLob lob, byte flag, int pos, int len, boolean fromStandby) throws SQLException {
        String str = null;
        byte[] bs = DmdbCSI.lob_get_bytes(lob, flag, pos, len, fromStandby);
        try {
            String serverEncoding = lob.getConnection().getServerEncoding();
            if (bs != null) {
                str = new String(bs, serverEncoding);
            }
        }
        catch (Exception e2) {
            throw new SQLException(e2.getMessage());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getRowCount(DmdbStatement_bs stmt, boolean fromStandby) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DataOfFetch dataFetch = new DataOfFetch(1L, Long.MAX_VALUE, 0);
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_fetch(msg, stmt.getHandle(), dataFetch);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt, fromStandby ? 0 : 1);
            Request_Response.resp_fetch_checkErr(recvMsg, conn);
            Request_Response.resp_fetch_without_checkErr(recvMsg, dataFetch, null, false);
            return dataFetch.getResRowCnt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void preExec(DmdbStatement_bs stmt, int irow, DmBinder[] binders, boolean forBatch) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = new DmMsgSend();
            Request_Response.req_pre_exec(stmt.getHandle(), msg, irow, binders, forBatch);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, stmt);
            Request_Response.resp_pre_exec(recvMsg, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setSessionIsoLevel(int isoLevel, DmdbConnection_bs conn) throws SQLException {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_sess_iso(msg, isoLevel);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, conn, null);
            Request_Response.resp_sess_iso(recv, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long[] table_ts(DmdbConnection_bs conn, long[] tbIds) throws SQLException {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_table_ts(msg, tbIds);
            DmMsgRecv recv = DmdbCSI.accessToServer(msg, conn, null);
            return Request_Response.resp_table_ts(recv, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int xa_process(DmdbConnection_bs conn, int xa_type, Xid xid, int flag) throws Exception {
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_xa_common(msg, xa_type, xid, flag);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null);
            return Request_Response.resp_xa_common(recvMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DmdbXid[] xa_recover(DmdbXAResource xaResource, int flag) throws Exception {
        DmdbConnection_bs conn = (DmdbConnection_bs)xaResource.getConnection();
        DmMsgSend dmMsgSend = conn.m_msg;
        synchronized (dmMsgSend) {
            DmMsgSend msg = conn.m_msg;
            Request_Response.req_xa_common(msg, 5, null, flag);
            DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null);
            return Request_Response.resp_xa_recover(xaResource, recvMsg);
        }
    }

    private static DmdbInfo getDescAndResultSet(DmdbStatement_bs stmt, DmMsgRecv recv) throws SQLException {
        return Request_Response.resp_execute(recv, stmt, 1);
    }

    private static int[] getBatchRowCounts(DmMsgRecv recv, DmdbStatement_bs stmt, int size) throws SQLException {
        if (size == 1) {
            return DmdbCSI.getUnBatchRowCount(recv, stmt);
        }
        return Request_Response.resp_execute_for_batch(recv, stmt, size);
    }

    private static int[] getUnBatchRowCount(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        DmdbInfo dbinfo = Request_Response.resp_execute(recv, stmt, 1);
        return new int[]{(int)dbinfo.getRowCount()};
    }

    private static final DmdbInfo executePrepared(PreExeced preExeced, DmdbStatement_bs stmt, int irow, DmMsgSend msg) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recv = null;
        DmdbInfo dbInfo = null;
        DmdbCSI.setParasMsg(preExeced, msg, stmt, irow);
        recv = DmdbCSI.accessToServer(msg, conn, stmt);
        stmt.setPutLobData(1);
        dbInfo = DmdbCSI.getDescAndResultSet(stmt, recv);
        if (recv != null) {
            recv.close();
        }
        return dbInfo;
    }

    private static final void connToServerInner(DmdbConnection_bs conn, DmMsgSend msg, int rwDestType) throws IOException, SQLException {
        String user = conn.getUser();
        if (user.length() > 2 && user.startsWith("///")) {
            DmdbCSI.KerberosProtocal(conn, user.substring(3), rwDestType);
        }
        DmdbCSI.startupServer(msg, conn, rwDestType);
        DmdbCSI.login(msg, conn, rwDestType);
    }

    private static final void login(DmMsgSend msg, DmdbConnection_bs conn, int rwDestType) throws SQLException, IOException {
        Request_Response.req_login(msg, conn, rwDestType);
        DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null, rwDestType);
        if (rwDestType == 0) {
            Request_Response.resp_checkErr(recvMsg, conn);
        } else {
            Request_Response.resp_login(recvMsg, conn);
        }
        if (recvMsg != null) {
            recvMsg.close();
        }
    }

    private static void startupServer(DmMsgSend msg, DmdbConnection_bs conn, int rwDestType) throws IOException, SQLException {
        Request_Response.req_startup(msg, conn, rwDestType);
        DmMsgRecv recvMsg = DmdbCSI.accessToServer(msg, conn, null, rwDestType);
        Request_Response.resp_startup(recvMsg, conn, rwDestType);
        if (conn.getEncryptMsg() == 2) {
            conn.getDbAccess().tryEnableSSL(false, rwDestType);
        } else if (conn.getEncryptMsg() == 1) {
            conn.getDbAccess().tryEnableSSL(true, rwDestType);
        }
        if (recvMsg != null) {
            recvMsg.close();
        }
    }

    private static void KerberosProtocal(DmdbConnection_bs conn, String kerberosUser, int rwDestType) throws SQLException {
        AuthInfo clientAuthInfo = conn.getDbAccess().initAuthInfo(kerberosUser, conn.getKerberosLoginConfPath(), 2, rwDestType);
        if (clientAuthInfo == null) {
            DBError.throwSQLException(6001);
        }
        String user = "///" + clientAuthInfo.getUserName();
        conn.setUser(user);
    }

    private static final void putData(DmdbStatement_bs stmt, DmMsgSend blobMsg, int paramIndex, int len) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        Request_Response.req_put_data(stmt.getHandle(), blobMsg, paramIndex, len);
        DmMsgRecv recvMsg = DmdbCSI.accessToServer(blobMsg, conn, stmt);
        Request_Response.resp_put_data(recvMsg, conn);
        if (recvMsg != null) {
            recvMsg.close();
        }
    }

    private static void setParasMsg(PreExeced preExeced, DmMsgSend msg, DmdbStatement_bs stmt, int irow) throws SQLException {
        Request_Response.req_execute(preExeced, msg, stmt, stmt.cursorUpdateRow, irow);
    }

    private static int setBatchParasMsg(PreExeced preExeced, int startRow, DmMsgSend msg, DmdbPreparedStatement_bs stmt) throws SQLException {
        return Request_Response.req_execute_for_batch(preExeced, startRow, msg, stmt);
    }

    private static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        if (!conn.getRwSeparate()) {
            return DmdbSingleDistribute.accessToServer(msg, conn, stmt);
        }
        if (conn.isRwAutoDistribute()) {
            return DmdbRwAutoDistribute.accessToServer(msg, conn, stmt);
        }
        return DmdbRwUserDistribute.accessToServer(msg, conn, stmt);
    }

    private static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException {
        if (!conn.getRwSeparate()) {
            return DmdbSingleDistribute.accessToServer(msg, conn, stmt);
        }
        if (conn.isRwAutoDistribute()) {
            return DmdbRwAutoDistribute.accessToServer(msg, conn, stmt, rwDestType);
        }
        return DmdbRwUserDistribute.accessToServer(msg, conn, stmt, rwDestType);
    }
}

