/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import java.sql.SQLException;

public class DmdbBdta {
    public static final int BDTA3_PACKAGE_NROWS = 0;
    public static final int BDTA3_PACKAGE_NFLDS = 4;
    public static final int BDTA3_PACKAGE_LENGTH = 6;
    public static final int BDTA3_PACKAGE_ORG_LEN = 10;
    public static final int BDTA3_PACKAGE_COMPRESS = 14;
    public static final int BDTA3_PACKAGE_HEAD_LEN = 15;
    public static final int VAR_DATA_LEN_STR = -2;
    public static final int VAR_DATA_LEN_DEC = -3;
    public int len;
    public int rownum;
    private int nflds;
    public int[] col_sql_type;
    private int[] col_offset;
    public int[] row_offset;
    private boolean[] col_is_all_not_null;
    public int curpos;
    public byte[] rowbuf;
    private int start_offset = 0;

    public DmdbBdta(byte[] rowbuf, int offset) throws SQLException {
        this.rowbuf = rowbuf;
        this.start_offset = offset;
        this.bdta3_unpack();
    }

    public void bdta3_unpack() throws SQLException {
        int offset = this.start_offset;
        byte[] buffer = this.rowbuf;
        this.len = (int)Convertion.getUInt(buffer, offset + 6);
        this.rownum = (int)Convertion.getUInt(buffer, offset + 0);
        this.nflds = Convertion.getUShort(buffer, offset + 4);
        offset += 15;
        this.col_sql_type = new int[this.nflds];
        int i2 = 0;
        while (i2 < this.nflds) {
            this.col_sql_type[i2] = Convertion.getUShort(buffer, offset);
            offset += 2;
            ++i2;
        }
        this.col_offset = new int[this.nflds];
        this.row_offset = new int[this.nflds];
        this.col_is_all_not_null = new boolean[this.nflds];
        i2 = 0;
        while (i2 < this.nflds) {
            this.col_offset[i2] = this.start_offset + (int)Convertion.getUInt(buffer, offset);
            offset += 4;
            int tmp_off = this.col_offset[i2];
            this.col_is_all_not_null[i2] = Convertion.getUInt(buffer, tmp_off) == 1L;
            tmp_off += 4;
            if (!this.col_is_all_not_null[i2]) {
                tmp_off += this.rownum * 1;
            }
            this.row_offset[i2] = tmp_off;
            ++i2;
        }
    }

    public boolean next() throws SQLException {
        if (this.curpos >= this.rownum - 1) {
            return false;
        }
        int colIndex = 0;
        while (colIndex < this.nflds) {
            if (!this.isNull(this.curpos, colIndex)) {
                int dtype_data_len = DmdbBdta.get_dtype_data_len(this.col_sql_type[colIndex]);
                if (dtype_data_len == -2) {
                    int offset = this.row_offset[colIndex] + 4;
                    int data_len = (int)Convertion.getUInt(this.rowbuf, offset);
                    this.row_offset[colIndex] = (offset += 4) + data_len;
                } else if (dtype_data_len == -3) {
                    int data_len = (int)Convertion.getUInt(this.rowbuf, this.row_offset[colIndex]);
                    int n2 = colIndex;
                    this.row_offset[n2] = this.row_offset[n2] + (data_len + 4);
                } else {
                    int n3 = colIndex;
                    this.row_offset[n3] = this.row_offset[n3] + dtype_data_len;
                }
            }
            ++colIndex;
        }
        ++this.curpos;
        return true;
    }

    public boolean isNull(int rowIndex, int colIndex) {
        if (this.col_is_all_not_null[colIndex]) {
            return false;
        }
        int temp = this.col_offset[colIndex] + 4 + rowIndex * 1;
        return this.rowbuf[temp] != 1;
    }

    public static int get_dtype_data_len(int dtype) throws SQLException {
        int datalen = 0;
        switch (dtype) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 25: {
                datalen = 4;
                break;
            }
            case 8: {
                datalen = 8;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                datalen = -2;
                break;
            }
            case 9: {
                datalen = -3;
                break;
            }
            case 10: {
                datalen = 4;
                break;
            }
            case 11: {
                datalen = 8;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                datalen = 12;
                break;
            }
            case 20: {
                datalen = 12;
                break;
            }
            case 21: {
                datalen = 24;
                break;
            }
            default: {
                DBError.throwSQLException(6016);
            }
        }
        return datalen;
    }

    public boolean absolute(int position) throws SQLException {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.rownum) {
            position = this.rownum - 1;
        }
        if (position != 0 || this.curpos != 0) {
            this.absolute_row_offset(position);
        }
        this.curpos = position;
        return true;
    }

    private void absolute_row_offset(int position) throws SQLException {
        int colIndex = 0;
        while (colIndex < this.nflds) {
            int offset = this.col_offset[colIndex] + 4;
            byte[] null_arr = null;
            if (!this.col_is_all_not_null[colIndex]) {
                null_arr = new byte[this.rownum];
                System.arraycopy(this.rowbuf, offset, null_arr, 0, this.rownum);
                offset += this.rownum * 1;
            }
            this.row_offset[colIndex] = position <= 0 ? offset : this.bdta3_unpack_col_offset(this.rowbuf, offset, colIndex, null_arr, position);
            ++colIndex;
        }
    }

    private int bdta3_unpack_col_offset(byte[] buffer, int offset, int colIndex, byte[] null_arr, int rows) throws SQLException {
        int dtype_data_len = DmdbBdta.get_dtype_data_len(this.col_sql_type[colIndex]);
        if (dtype_data_len == -2) {
            offset = this.bdta3_unpack_col_offset_str(buffer, offset, this.col_is_all_not_null[colIndex], null_arr, rows);
        } else if (dtype_data_len == -3) {
            offset = this.bdta3_unpack_col_offset_dec(buffer, offset, this.col_is_all_not_null[colIndex], null_arr, rows);
        } else if (this.col_is_all_not_null[colIndex]) {
            offset += rows * dtype_data_len;
        } else {
            int nullcount = 0;
            int j2 = 0;
            while (j2 < rows) {
                if (null_arr[j2] == 0) {
                    ++nullcount;
                }
                ++j2;
            }
            offset += (rows - nullcount) * dtype_data_len;
        }
        return offset;
    }

    private int bdta3_unpack_col_offset_str(byte[] buffer, int offset, boolean is_all_not_null, byte[] null_arr, int rowcount) {
        int data_len = 0;
        if (is_all_not_null) {
            int i2 = 0;
            while (i2 < rowcount) {
                data_len = (int)Convertion.getUInt(buffer, offset += 4);
                offset += 4;
                offset += data_len;
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < rowcount) {
                if (null_arr[i3] == 1) {
                    data_len = (int)Convertion.getUInt(buffer, offset += 4);
                    offset += 4;
                    offset += data_len;
                }
                ++i3;
            }
        }
        return offset;
    }

    private int bdta3_unpack_col_offset_dec(byte[] buffer, int offset, boolean is_all_not_null, byte[] null_arr, int rowcount) {
        int data_len = 0;
        if (is_all_not_null) {
            int i2 = 0;
            while (i2 < rowcount) {
                data_len = (int)Convertion.getUInt(buffer, offset);
                offset += 4;
                offset += data_len;
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < rowcount) {
                if (null_arr[i3] == 1) {
                    data_len = (int)Convertion.getUInt(buffer, offset);
                    offset += 4;
                    offset += data_len;
                }
                ++i3;
            }
        }
        return offset;
    }

    public boolean previous() throws SQLException {
        if (this.curpos <= 0) {
            return false;
        }
        this.previous_row_offset();
        --this.curpos;
        return true;
    }

    private void previous_row_offset() throws SQLException {
        int colIndex = 0;
        while (colIndex < this.nflds) {
            if (!this.isNull(this.curpos - 1, colIndex)) {
                int dtype_data_len = DmdbBdta.get_dtype_data_len(this.col_sql_type[colIndex]);
                if (dtype_data_len == -2 || dtype_data_len == -3) {
                    int offset = this.col_offset[colIndex] + 4;
                    byte[] null_arr = null;
                    if (!this.col_is_all_not_null[colIndex]) {
                        null_arr = new byte[this.rownum];
                        System.arraycopy(this.rowbuf, offset, null_arr, 0, this.rownum);
                        offset += this.rownum * 1;
                    }
                    this.row_offset[colIndex] = dtype_data_len == -2 ? this.bdta3_unpack_col_offset_str(this.rowbuf, offset, this.col_is_all_not_null[colIndex], null_arr, this.curpos - 1) : this.bdta3_unpack_col_offset_dec(this.rowbuf, offset, this.col_is_all_not_null[colIndex], null_arr, this.curpos - 1);
                } else {
                    int n2 = colIndex;
                    this.row_offset[n2] = this.row_offset[n2] - dtype_data_len;
                }
            }
            ++colIndex;
        }
    }

    public byte[] getBytes(short columnNo) throws SQLException {
        if (this.isNull(this.curpos, columnNo)) {
            return null;
        }
        int data_len = DmdbBdta.get_dtype_data_len(this.col_sql_type[columnNo]);
        int blank_len = 0;
        int offset = this.row_offset[columnNo];
        if (data_len == -2) {
            blank_len = (int)Convertion.getUInt(this.rowbuf, offset);
            data_len = (int)Convertion.getUInt(this.rowbuf, offset += 4);
            offset += 4;
        } else if (data_len == -3) {
            data_len = (int)Convertion.getUInt(this.rowbuf, offset);
            offset += 4;
        }
        byte[] returnBuffer = new byte[data_len + blank_len];
        System.arraycopy(this.rowbuf, offset, returnBuffer, 0, data_len);
        int i2 = data_len;
        while (i2 < returnBuffer.length) {
            returnBuffer[i2] = 32;
            ++i2;
        }
        return returnBuffer;
    }

    public boolean getBytes(short columnNo, byte[] returnBuffer) throws SQLException {
        if (this.isNull(this.curpos, columnNo)) {
            return true;
        }
        int data_len = DmdbBdta.get_dtype_data_len(this.col_sql_type[columnNo]);
        int offset = this.row_offset[columnNo];
        if (data_len == -2) {
            data_len = (int)Convertion.getUInt(this.rowbuf, offset += 4);
            offset += 4;
        } else if (data_len == -3) {
            data_len = (int)Convertion.getUInt(this.rowbuf, offset);
            offset += 4;
        }
        System.arraycopy(this.rowbuf, offset, returnBuffer, 0, data_len);
        int i2 = data_len;
        while (i2 < returnBuffer.length) {
            returnBuffer[i2] = 32;
            ++i2;
        }
        return false;
    }

    public long rec_get_rowid(int rowidCol) {
        try {
            byte[] rowid_bytes = this.getBytes((short)rowidCol);
            long rowid = Convertion.bytesToLong(rowid_bytes);
            return rowid;
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            return -1L;
        }
    }
}

