/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbClobWriter;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class DmdbClob
extends DmdbLob
implements Clob {
    ILogger LOG = LogFactory.getLog(DmdbClob.class);
    String m_serverEncoding = null;

    public DmdbClob(byte[] value, LobDesc lobDesc, DmdbConnection_bs conn, boolean updAble) {
        super(value, (byte)1, lobDesc, conn, updAble);
        this.m_serverEncoding = conn.getServerEncoding();
    }

    public DmdbClob(byte[] bs, DmdbConnection_bs conn) throws SQLException {
        super(bs, conn);
        this.m_serverEncoding = conn.getServerEncoding();
    }

    public DmdbClob(Connection conn) {
        super(null, conn);
        this.m_serverEncoding = this.m_conn.getServerEncoding();
    }

    public static DmdbClob getEmptyClob() {
        return new DmdbClob(new DmdbConnection_bs());
    }

    public long length() throws SQLException {
        this.checkFreed();
        this.LOG.info((Object)this, "length", new Object[0]);
        long len = 0L;
        if (this.m_lobMode == 2) {
            String str = Convertion.getString(this.m_value, this.m_hdr_size, this.m_value.length - this.m_hdr_size, this.m_serverEncoding);
            return str.length();
        }
        if (this.isValueInRow() || this.isValueInRow()) {
            byte[] buf = this.getValueInRow();
            String str = Convertion.getString(buf, 0, buf.length, this.m_serverEncoding);
            return str.length();
        }
        if (this.offRowLen == -1L) {
            this.checkConnClosed();
            len = DmdbCSI.lob_get_len(this, this.m_fromStandby);
            if (len < 0L) {
                DBError.throwSQLException(6057);
            }
            this.offRowLen = len;
            return len;
        }
        return this.offRowLen;
    }

    public String getSubString(long pos, int length) throws SQLException {
        this.checkFreed();
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        this.LOG.info((Object)this, "getSubString", pos, length);
        String tmpBuf = null;
        String str = "";
        int maxTextLen = 32000;
        if (this.m_lobMode == 2) {
            str = Convertion.getString(this.m_value, this.m_hdr_size, this.m_value.length - this.m_hdr_size, this.m_serverEncoding);
            if (pos > (long)str.length()) {
                return "";
            }
            if ((long)str.length() < pos - 1L + (long)length) {
                return str.substring((int)pos - 1);
            }
            return str.substring((int)pos - 1, (int)(pos - 1L + (long)length));
        }
        if (this.isValueInRow()) {
            byte[] buf = this.getValueInRow();
            str = Convertion.getString(buf, 0, buf.length, this.m_serverEncoding);
            if (pos > (long)str.length()) {
                return "";
            }
            if ((long)str.length() < pos - 1L + (long)length) {
                return str.substring((int)pos - 1);
            }
            return str.substring((int)pos - 1, (int)(pos - 1L + (long)length));
        }
        if (this.fromRowSetFlag) {
            DBError.throwUnsupportedSQLException();
            return null;
        }
        int len = length > maxTextLen ? maxTextLen : length;
        int position = (int)pos - 1;
        int charsGet = 0;
        do {
            this.checkConnClosed();
            tmpBuf = DmdbCSI.text_get_subString(this, (byte)1, position, len, this.m_fromStandby);
            if (tmpBuf == null) break;
            str = String.valueOf(str) + tmpBuf;
            position += tmpBuf.length();
            len = length - (charsGet += tmpBuf.length());
            if (len <= 0) break;
            if (len <= maxTextLen) continue;
            len = maxTextLen;
        } while (!this.getLobLocator().isReadOver());
        return str;
    }

    public Reader getCharacterStream() throws SQLException {
        this.LOG.info((Object)this, "getCharacterStream", new Object[0]);
        this.checkFreed();
        return new DmdbReader(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        this.LOG.info((Object)this, "getAsciiStream", new Object[0]);
        this.checkFreed();
        return new DmdbInputStream(this, this.m_serverEncoding);
    }

    public long position(String searchstr, long start) throws SQLException {
        this.LOG.info((Object)this, "position", searchstr, start);
        this.checkFreed();
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        long length = this.length();
        if ((long)searchstr.length() > length - start + 1L) {
            return -1L;
        }
        String valStr = this.getSubString(start, (int)(length - start + 1L));
        if ((long)valStr.length() < length - start + 1L) {
            return -1L;
        }
        long indexOf = valStr.indexOf(searchstr);
        if (indexOf >= 0L) {
            ++indexOf;
        }
        return indexOf;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        this.checkFreed();
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        String toSearch = searchstr.getSubString(1L, (int)searchstr.length());
        return this.position(toSearch, start);
    }

    public int setString(long pos, String str) throws SQLException {
        this.checkFreed();
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.LOG.info((Object)this, "setString", pos, str, offset, len);
        this.checkFreed();
        if (pos <= 0L || offset < 0 || len < 0 || offset + len > str.length()) {
            DBError.throwSQLException(6057);
        }
        if (!this.fromRowSetFlag && !this.m_updatAble) {
            DBError.throwSQLException(6029);
        }
        if (this.m_lobMode == 2) {
            this.setClobInRow(pos, str, offset, len);
            this.isUpdated = true;
            return len;
        }
        if (this.fromRowSetFlag) {
            this.setClobInRow(pos, str, offset, len);
            return len;
        }
        int ret = 0;
        int maxTextLen = 8000;
        byte[] buf = Convertion.getBytes(str, offset, len, this.m_serverEncoding);
        int position = (int)pos - 1;
        int off = 0;
        int len1 = buf.length;
        int length = len1 > maxTextLen ? maxTextLen : len1;
        int count = len1 / maxTextLen + 1;
        ret = 0;
        byte firstOrLast = 0;
        int i2 = 0;
        while (i2 < count) {
            firstOrLast = i2 == 0 && i2 == count - 1 ? (byte)3 : (i2 == 0 ? (byte)1 : (i2 == count - 1 ? (byte)2 : 0));
            this.checkConnClosed();
            int tmp = DmdbCSI.lob_set_bytes(this, (byte)1, position, buf, off, length, firstOrLast, this.m_fromStandby);
            if (tmp <= 0) {
                return ret;
            }
            ret += tmp;
            position += tmp;
            length = i2 == count - 2 ? len1 - (off += length) : maxTextLen;
            ++i2;
        }
        short groupid = Convertion.getShort(this.getLobLocator().m_data_groupId, 0);
        if (groupid == -1) {
            this.setClobInRow(pos, str, offset, len);
        } else {
            this.m_value[0] = 2;
            this.offRowLen = -1L;
        }
        this.isUpdated = true;
        return ret;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.LOG.info((Object)this, "setAsciiStream", pos);
        this.checkFreed();
        if (this.m_conn != null && this.m_conn.isCompatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbOutputStream(this, pos);
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        return this.setAsciiStream(pos);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.LOG.info((Object)this, "setCharacterStream", pos);
        this.checkFreed();
        if (this.m_conn != null && this.m_conn.isCompatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbClobWriter(this, pos);
    }

    public void truncate(long len) throws SQLException {
        this.LOG.info((Object)this, "truncate", len);
        this.checkFreed();
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        if (this.m_lobMode == 2) {
            this.truncateClobInRow(len);
            this.isUpdated = true;
            return;
        }
        if (this.fromRowSetFlag || !this.m_updatAble) {
            DBError.throwSQLException(6029);
        }
        this.checkConnClosed();
        DmdbCSI.blob_text_truncate(this, (byte)1, (int)len, this.m_fromStandby);
        short groupid = Convertion.getShort(this.getLobLocator().m_data_groupId, 0);
        if (groupid == -1) {
            this.truncateClobInRow(len);
        } else {
            this.offRowLen = len;
        }
        this.isUpdated = true;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.LOG.info((Object)this, "getBytes", pos, length);
        this.checkFreed();
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] buf = new byte[length];
        if (this.m_lobMode == 2) {
            if (pos > (long)(this.m_value.length - this.m_hdr_size)) {
                return null;
            }
            if ((long)(this.m_value.length - this.m_hdr_size) - pos + 1L < (long)length) {
                buf = new byte[(int)((long)(this.m_value.length - this.m_hdr_size) - pos + 1L)];
            }
            System.arraycopy(this.m_value, (int)pos - 1 + this.m_hdr_size, buf, 0, buf.length);
            return buf;
        }
        if (this.isValueInRow() && (this.fromRowSetFlag || !this.m_updatAble || this.m_updatAble && !this.isUpdated)) {
            byte[] val = this.getValueInRow();
            if (pos > this.length()) {
                return null;
            }
            if ((long)val.length - pos + 1L <= (long)length) {
                buf = new byte[(int)((long)val.length - pos + 1L)];
            }
            System.arraycopy(val, (int)(pos - 1L), buf, 0, buf.length);
            return buf;
        }
        return this.getBytesOffRow(pos, length);
    }

    public byte[] getBytesOffRow(long pos, int length) throws SQLException {
        this.checkFreed();
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] tmpBuf = null;
        byte[] buf = new byte[length];
        int count = length / 32000 + 1;
        int len = length > 32000 ? 32000 : length;
        int position = (int)pos - 1;
        int offset = 0;
        int i2 = 0;
        while (i2 < count) {
            this.checkConnClosed();
            tmpBuf = DmdbCSI.lob_get_bytes(this, (byte)0, position, len, this.m_fromStandby);
            if (tmpBuf == null) break;
            System.arraycopy(tmpBuf, 0, buf, offset, tmpBuf.length);
            position += tmpBuf.length;
            len = length - (offset += tmpBuf.length);
            if (len <= 0) break;
            if (len > 32000) {
                len = 32000;
            }
            if (this.getLobLocator().isReadOver()) break;
            ++i2;
        }
        if (offset == length) {
            return buf;
        }
        byte[] tmpVal = new byte[offset];
        System.arraycopy(buf, 0, tmpVal, 0, offset);
        return tmpVal;
    }

    private void setClobInRow(long pos, String str, int offset, int len) throws SQLException {
        String s2;
        String s3;
        String s22;
        int length = this.getLobLen();
        if (pos > (long)(length + 1)) {
            throw new IndexOutOfBoundsException(new Long(pos).toString());
        }
        this.m_value[0] = 1;
        String s1 = Convertion.getString(this.m_value, this.m_hdr_size, length, this.m_serverEncoding);
        if (pos + (long)len <= (long)s1.length()) {
            s22 = s1.substring(0, (int)(pos - 1L));
            s3 = s1.substring((int)(pos - 1L + (long)len));
            String s4 = str.substring(offset, offset + len);
            s2 = s22.concat(s4).concat(s3);
        } else {
            s22 = s1.substring(0, (int)(pos - 1L));
            s3 = str.substring(offset, offset + len);
            s2 = s22.concat(s3);
        }
        byte[] tmp = Convertion.getBytes(s2, this.m_serverEncoding);
        byte[] newValue = new byte[tmp.length + this.m_hdr_size];
        System.arraycopy(this.m_value, 0, newValue, 0, this.m_hdr_size);
        System.arraycopy(tmp, 0, newValue, this.m_hdr_size, tmp.length);
        Convertion.setInt(newValue, 9, tmp.length);
        this.m_value = newValue;
    }

    private void truncateClobInRow(long len) throws SQLException {
        String s1 = Convertion.getString(this.m_value, this.m_hdr_size, this.getLobLen(), this.m_serverEncoding);
        if (len > (long)s1.length()) {
            DBError.throwSQLException(6057);
        }
        String s2 = s1.substring(0, (int)len);
        byte[] tmp = Convertion.getBytes(s2, this.m_serverEncoding);
        byte[] newValue = new byte[tmp.length + this.m_hdr_size];
        System.arraycopy(this.m_value, 0, newValue, 0, this.m_hdr_size);
        System.arraycopy(tmp, 0, newValue, this.m_hdr_size, tmp.length);
        Convertion.setInt(newValue, 9, tmp.length);
        this.m_value = newValue;
    }

    public void free() throws SQLException {
        this.LOG.info((Object)this, "free", new Object[0]);
        super.free();
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.LOG.info((Object)this, "getCharacterStream", pos, length);
        this.checkFreed();
        return new DmdbReader(this, pos, length);
    }
}

