/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccess;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.dbaccess.DmdbSwitch;
import dm.jdbc.desc.ConnClientAttr;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.ServerGroup;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbDatabaseMetaData_bs;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.parser.DmdbExecOpt;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.pool.DmdbPooledConnection_bs;
import dm.jdbc.processor.DBAliveCheckThread;
import dm.jdbc.processor.LoadBalanceThread;
import dm.jdbc.util.DmJdbcUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbConnection_bs
extends ConnClientAttr
implements Connection {
    private ConnServAttr m_connServAttr = new ConnServAttr();
    private Properties m_connProps = new Properties();
    private ServerGroup serverGroup;
    private int m_servPos = 0;
    private boolean m_isExecute2 = false;
    private boolean m_lobEmptyCompOrcl = false;
    Hashtable<Long, Statement> cursorStmt;
    protected boolean closed = true;
    DmdbDatabaseMetaData_bs m_dbMetaData;
    private boolean logicalHandle;
    DmdbPooledConnection_bs m_pc;
    private int connectionHoldability = 1;
    private SQLWarning m_warning;
    private boolean m_readOnly = false;
    private DbAccess m_dbaccess;
    public DmMsgSend m_msg = new DmMsgSend();
    private final ResourceBundle res = DmSvcConf.res;
    private String random;
    private boolean uKeyFlag = false;
    private Vector<DmdbStatement_bs> stmtPool = null;
    private Vector<Statement> stmtsVec = null;
    private static final String svptPrefix = "DMDB_SVPT_";
    public static int execSqlNum = 0;
    public static int rsCachedNum = 0;
    private Map<String, Class<?>> m_typeMap = new HashMap();
    public Map<String, Object> infoMap = new HashMap<String, Object>();
    private DriverPropertyInfo[] m_clientInfoArray = null;
    private Properties m_clientInfoMapConnStr = null;
    private String m_currentDBName = null;
    private int rwLatestDestType = 1;
    private String rwStandbyHost = null;
    private int rwStandbyPort = 0;
    private boolean transFinish = true;
    private boolean pwd_encrypt = false;
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    private Object resetMutex = new Object();
    private long checkLoadBalanceTs = 0L;

    public void setUKeyFlag(boolean uKeyFlag) {
        this.uKeyFlag = uKeyFlag;
    }

    public boolean getUKeyFlag() {
        return this.uKeyFlag;
    }

    public void setRandom(String random) {
        this.random = random;
    }

    public String getRandom() {
        return this.random;
    }

    public void setCurrentDBName(String dbName) {
        this.m_currentDBName = dbName;
    }

    public String getCurrentDBName() {
        return this.m_currentDBName;
    }

    public void setTransFinish(int status) throws SQLException {
        switch (status & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.transFinish = true;
                break;
            }
            default: {
                this.transFinish = false;
            }
        }
    }

    public boolean getTransFinish() {
        return this.transFinish;
    }

    public void setStandbyInfo(String host, int port) {
        this.rwStandbyHost = host;
        this.rwStandbyPort = port;
    }

    public String getStandbyHost() {
        return this.rwStandbyHost;
    }

    public int getStandbyPort() {
        return this.rwStandbyPort;
    }

    public boolean pwd_encrypt() {
        return this.pwd_encrypt;
    }

    public void setPwdEncrypt(boolean pwd_encrypt) {
        this.pwd_encrypt = pwd_encrypt;
    }

    public DmdbPooledConnection_bs getMpc() {
        return this.m_pc;
    }

    public DmdbConnection_bs(String url, Properties properties) throws SQLException {
        this.initialize(url.trim(), properties);
        this.logicalHandle = false;
    }

    public DmdbConnection_bs() {
        this.resetClientInfo();
        this.connectionHoldability = 1;
        this.m_dbMetaData = null;
        this.m_pc = null;
        this.m_warning = null;
        this.cursorStmt = new Hashtable(10);
        this.stmtPool = new Vector(this.getStmtPoolMaxSize());
        this.setStmtsVec(new Vector<Statement>());
        this.setClosed(true);
        this.logicalHandle = false;
    }

    public DmdbConnection_bs getLogicalConnection(DmdbPooledConnection_bs pooledConnection) {
        this.logicalHandle = true;
        this.m_pc = pooledConnection;
        this.connectionHoldability = 1;
        return this;
    }

    private void initialize(String url, Properties props) throws SQLException {
        String host = props.getProperty("host", "localhost");
        String port = props.getProperty("port", String.valueOf(5236));
        this.serverGroup = DmSvcConf.getServerGroup(host);
        DmServerInfo tempServ = null;
        DmSvcConf dmSvcConf = null;
        if (this.serverGroup != null) {
            tempServ = this.serverGroup.getSvrList().get(0);
            dmSvcConf = this.serverGroup.getDmSvcConf();
        } else {
            tempServ = new DmServerInfo(host, Integer.parseInt(port));
            dmSvcConf = DmSvcConf.globalDmSvcConf;
        }
        host = tempServ.getSvrName();
        if (tempServ.hasPort()) {
            port = String.valueOf(tempServ.getSvrPort());
        }
        super.init(url, host, port, props, dmSvcConf);
        this.resetClientInfo();
        this.connectionHoldability = 1;
        this.m_dbMetaData = null;
        this.m_pc = null;
        this.m_warning = null;
        this.cursorStmt = new Hashtable(10);
        this.stmtPool = new Vector(this.getStmtPoolMaxSize());
        this.setStmtsVec(new Vector<Statement>());
        this.m_connProps = (Properties)props.clone();
        this.m_connProps.remove("password");
        this.openConnection();
        if (!this.hasOneSvr() && this.isLoadBalance()) {
            LoadBalanceThread.addServerGroup(this);
        }
        if (DBAliveCheckThread.getInstance() != null) {
            DBAliveCheckThread.getInstance().addConnection(this);
        }
    }

    private void initDefaultClientInfo() {
        if (this.m_clientInfoArray == null) {
            DriverPropertyInfo continueBatchOnError = new DriverPropertyInfo("continueBatchOnError", "false");
            continueBatchOnError.description = this.res.getString("desciption.execute.continue");
            DriverPropertyInfo LobMode = new DriverPropertyInfo("LobMode", "1");
            LobMode.description = this.res.getString("desciption.lob.mode");
            DriverPropertyInfo ignoreCase = new DriverPropertyInfo("ignoreCase", "true");
            ignoreCase.description = this.res.getString("description.ignoreCase");
            DriverPropertyInfo batchType = new DriverPropertyInfo("batchType", "1");
            batchType.description = this.res.getString("description.batchType");
            DriverPropertyInfo appName = new DriverPropertyInfo("ApplicationName", "");
            appName.description = this.res.getString("description.appName");
            DriverPropertyInfo userProp = new DriverPropertyInfo("ClientUser", "");
            userProp.description = this.res.getString("description.clientUser");
            DriverPropertyInfo hostProp = new DriverPropertyInfo("ClientHostname", "localhost");
            hostProp.description = this.res.getString("description.clientHostname");
            this.m_clientInfoArray = new DriverPropertyInfo[]{continueBatchOnError, LobMode, ignoreCase, batchType, appName, userProp, hostProp};
        }
    }

    public ResultSet getDefaultClientInfo() throws SQLException {
        this.initDefaultClientInfo();
        StringBuffer stringBuffer = new StringBuffer("declare \ntype RowVal is record (NAME varchar(128), MAX_LEN int, DEFAULT_VALUE varchar(50), DESCRIPTION varchar(512)); \ntype RowVals is array RowVal[];\nr RowVal; \nrs RowVals;\n");
        stringBuffer.append("begin \n");
        int len = this.m_clientInfoArray.length;
        stringBuffer.append("rs = new RowVal[" + len + "]; \n");
        int i2 = 0;
        while (i2 < len) {
            stringBuffer.append("r.name = '" + this.m_clientInfoArray[i2].name + "';\n");
            stringBuffer.append("r.max_len = 128;\n");
            stringBuffer.append("r.default_value = '" + this.m_clientInfoArray[i2].value + "';\n");
            stringBuffer.append("r.description = '" + this.m_clientInfoArray[i2].description + "';\n");
            int index = i2 + 1;
            stringBuffer.append("rs[" + index + "] = r;\n");
            ++i2;
        }
        stringBuffer.append("select * from array rs;\n");
        stringBuffer.append("end;");
        return DmJdbcUtil.executeQuery(this, stringBuffer.toString());
    }

    private void resetClientInfo() {
        if (this.m_clientInfoMapConnStr == null) {
            this.m_clientInfoMapConnStr = new Properties();
        }
        this.m_clientInfoMapConnStr.clear();
        this.m_clientInfoMapConnStr.setProperty("ClientUser", String.valueOf(this.getUser()));
        this.m_clientInfoMapConnStr.setProperty("ClientHostname", String.valueOf(this.getHost()));
        this.m_clientInfoMapConnStr.setProperty("continueBatchOnError", String.valueOf(this.isContinueBatchOnError()));
        this.m_clientInfoMapConnStr.setProperty("LobMode", String.valueOf(this.getLobMode()));
        this.m_clientInfoMapConnStr.setProperty("ignoreCase", String.valueOf(this.isIgnoreCase()));
        this.m_clientInfoMapConnStr.setProperty("batchType", String.valueOf(this.getBatchType()));
        this.m_clientInfoMapConnStr.setProperty("ApplicationName", String.valueOf(this.getAppName()));
    }

    private synchronized void openConnection() throws SQLException {
        try {
            DmdbSwitch.connect(this);
            this.setClosed(false);
        }
        catch (IOException iOException) {
            this.m_msg = null;
            this.closeDbAccess();
            DBError.throwSQLException(6001);
        }
        catch (SQLException e2) {
            this.m_msg = null;
            this.closeDbAccess();
            throw e2;
        }
    }

    @Override
    public void setClientInfo(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.m_clientInfoMapConnStr.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties props) {
        if (props == null || props.size() == 0) {
            this.m_clientInfoMapConnStr.clear();
            return;
        }
        this.m_clientInfoMapConnStr = (Properties)props.clone();
    }

    @Override
    public String getClientInfo(String name) {
        if (name.equalsIgnoreCase("appName")) {
            name = "ApplicationName";
        }
        if (name.equalsIgnoreCase("user")) {
            name = "ClientUser";
        }
        if (name.equalsIgnoreCase("host")) {
            name = "ClientHostname";
        }
        return this.m_clientInfoMapConnStr.getProperty(name);
    }

    @Override
    public Properties getClientInfo() {
        return (Properties)this.m_clientInfoMapConnStr.clone();
    }

    public boolean isLogicalConnection() {
        return this.logicalHandle;
    }

    public void unLogicalConnection() {
        this.logicalHandle = false;
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(this.getResultSetType(), 1007, this.connectionHoldability);
    }

    @Override
    public synchronized DmdbPreparedStatement_bs prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, this.getResultSetType(), 1007, this.connectionHoldability);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, this.getResultSetType(), 1007, this.connectionHoldability);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (this.fullToHalfWidth) {
            sql = sql.replaceAll("\u3000", " ");
        }
        try {
            return SQLProcessor.escape(sql, this.getKeyWords());
        }
        catch (IOException iOException) {
            DBError.throwSQLException("Sql escape error!");
            return sql;
        }
    }

    DmdbExecOpt nativeSQL_ExecOpt(String sql) throws SQLException {
        try {
            return SQLProcessor.execOpt(sql, this.getServerEncoding());
        }
        catch (Exception exception) {
            DBError.throwSQLException("Sql execute Opt error!");
            return null;
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return super.getAutoCommit();
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            this.transFinish = true;
            if (this.isAlwayseAllowCommit()) {
                return;
            }
            DBError.throwSQLException(6042);
        }
        DmdbCSI.commitWork(this, this.connectionHoldability);
        this.transFinish = true;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            this.transFinish = true;
            if (this.isAlwayseAllowCommit()) {
                return;
            }
            DBError.throwSQLException(6043);
        }
        DmdbCSI.rollbackWork(this, this.connectionHoldability);
        this.transFinish = true;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.isCompatibleOracle()) {
            this.commit();
        }
        this.close_statements();
        if (this.logicalHandle) {
            this.invalidAllStmt();
            this.getStmtsVec().clear();
            this.logicalClose();
            return;
        }
        if (this.serverGroup != null) {
            this.serverGroup.removeSession(this.m_servPos);
        }
        if (DBAliveCheckThread.getInstance() != null) {
            DBAliveCheckThread.getInstance().removeConnection(this);
        }
        this.closeDbAccess();
        this.cleanup();
        this.setClosed(true);
    }

    public synchronized void closeDbAccess() {
        this.invalidAllStmt();
        if (this.m_dbaccess != null) {
            this.m_dbaccess.close();
            this.m_dbaccess = null;
        }
        this.setClosed(true);
    }

    public void forceClose(int rwDestType) {
        if (rwDestType == 0) {
            this.getDbAccess().setStandbyAlive(false);
            this.getDbAccess().getAccessStandby().close();
        } else {
            this.getDbAccess().close();
            this.setClosed(true);
        }
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public synchronized void closeForAgent() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeDbAccess();
        this.cleanup();
        this.setClosed(true);
    }

    public synchronized void logicalClose() {
        try {
            if (this.m_pc != null) {
                this.m_pc.logicalClose();
            }
            this.resetClientInfo();
        }
        catch (Exception exception) {}
    }

    private void cleanup() {
        if (this.m_msg != null) {
            this.m_msg.clear();
            this.m_msg = null;
        }
        this.rwStandbyHost = null;
        this.rwStandbyPort = 0;
        if (this.getStmtsVec() != null) {
            this.getStmtsVec().clear();
        }
        this.setStmtsVec(null);
        if (this.cursorStmt != null) {
            this.cursorStmt.clear();
        }
        this.cursorStmt = null;
        if (this.stmtPool != null) {
            this.stmtPool.clear();
        }
        this.stmtPool = null;
        this.serverGroup = null;
        this.m_pc = null;
        this.m_dbMetaData = null;
        this.m_clientInfoArray = null;
        this.m_dbaccess = null;
        this.m_warning = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new DmdbDatabaseMetaData_bs(this);
        }
        return this.m_dbMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.m_readOnly == readOnly) {
            return;
        }
        if (!this.getAutoCommit()) {
            this.commit();
        }
        if (readOnly) {
            DmJdbcUtil.executeForRw(this, "SP_SET_SESSION_READONLY (1)", 1);
        } else {
            DmJdbcUtil.executeForRw(this, "SP_SET_SESSION_READONLY (0)", 1);
        }
        if (!this.getAutoCommit()) {
            this.commit();
        }
        this.m_readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    public final String getCurrentUserName() throws SQLException {
        String string;
        block7: {
            ResultSet rs = null;
            try {
                rs = DmJdbcUtil.executeQuery(this, "select user()");
                rs.next();
                string = rs.getString(1);
                if (rs == null) break block7;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public void setComprMsg(int compr) {
        this.m_connServAttr.comprMsg = compr;
    }

    public int getComprMsg() {
        return this.m_connServAttr.comprMsg;
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 0: {
                break;
            }
            case 2: {
                DmdbCSI.setSessionIsoLevel(1, this);
                this.m_connServAttr.transLevel = 2;
                break;
            }
            case 8: {
                DmdbCSI.setSessionIsoLevel(3, this);
                this.m_connServAttr.transLevel = 8;
                break;
            }
            case 1: {
                DmdbCSI.setSessionIsoLevel(0, this);
                this.m_connServAttr.transLevel = 1;
                break;
            }
            case 4: {
                if (this.isCompatibleMysql()) {
                    DmdbCSI.setSessionIsoLevel(1, this);
                    this.m_connServAttr.transLevel = 2;
                    break;
                }
            }
            default: {
                DBError.throwSQLException(6038);
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.m_connServAttr.transLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.m_warning != null) {
            SQLWarning sQLWarning = this.m_warning;
            synchronized (sQLWarning) {
                return this.m_warning;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        if (this.m_warning != null) {
            SQLWarning sQLWarning = this.m_warning;
            synchronized (sQLWarning) {
                this.m_warning = null;
            }
        }
    }

    private void addWarningsExec(SQLWarning warn) {
        if (this.m_warning == null) {
            this.m_warning = warn;
        } else {
            this.m_warning.setNextWarning(warn);
        }
    }

    public void addWarnings(SQLWarning warn) {
        if (warn != null) {
            this.addWarningsExec(warn);
        }
    }

    void add_statement(long handle, Statement statement) {
        this.cursorStmt.put(new Long(handle), statement);
    }

    void remove_statement(long handle) {
        this.cursorStmt.remove(new Long(handle));
    }

    public void close_all_resultSet() throws SQLException {
        Enumeration<Statement> e2 = this.cursorStmt.elements();
        while (e2.hasMoreElements()) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)e2.nextElement();
            if (stmt.getCurrentRs() == null) continue;
            stmt.getCurrentRs().close();
        }
    }

    public long getCurpos(long handle) throws SQLException {
        long curPos = 0L;
        if (this.cursorStmt.containsKey(new Long(handle))) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)this.cursorStmt.get(new Long(handle));
            if (stmt == null) {
                return curPos;
            }
            DmdbResultSet_bs rs = (DmdbResultSet_bs)stmt.getResultSet();
            if (rs == null) {
                return curPos;
            }
            curPos = rs.getCurrentRowNum();
        }
        return curPos;
    }

    private void close_statements() {
        Enumeration<Statement> enumeration = this.cursorStmt.elements();
        while (enumeration.hasMoreElements()) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)enumeration.nextElement();
            if (stmt == null) continue;
            try {
                stmt.innerClose();
            }
            catch (Exception exception) {}
            this.remove_statement(stmt.handle);
            Object var2_2 = null;
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionHoldability);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldability);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldability);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.m_typeMap = map;
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        if (holdability == 1 || holdability == 2) {
            this.connectionHoldability = holdability;
        } else {
            DBError.throwSQLException(6055);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connectionHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            DBError.throwSQLException(6039);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint();
        String s2 = "SAVEPOINT DMDB_SVPT_" + savepoint.getSavepointId();
        DmJdbcUtil.executeUpdate(this, s2);
        return savepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            DBError.throwSQLException(6039);
        }
        if (name == null || name.trim().length() == 0) {
            DBError.throwSQLException(6051);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint(name);
        String s2 = "SAVEPOINT \"" + StringUtil.getEscObjName(name) + "\"";
        DmJdbcUtil.executeUpdate(this, s2);
        return savepoint;
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            if (this.isAlwayseAllowCommit()) {
                return;
            }
            DBError.throwSQLException(6043);
        }
        if (savepoint == null) {
            DBError.throwSQLException(6064);
        }
        if (((DmdbSavepoint)savepoint).getReleasedFlag()) {
            DBError.throwSQLException(6053);
        }
        String s2 = "ROLLBACK TO SAVEPOINT \"";
        try {
            s2 = String.valueOf(s2) + StringUtil.getEscObjName(savepoint.getSavepointName());
            s2 = String.valueOf(s2) + "\"";
        }
        catch (SQLException sQLException) {
            s2 = String.valueOf(s2) + svptPrefix + savepoint.getSavepointId();
            s2 = String.valueOf(s2) + "\"";
        }
        DmJdbcUtil.executeUpdate(this, s2);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            DBError.throwSQLException(6041);
        }
        if (savepoint == null) {
            DBError.throwSQLException(6064);
        }
        ((DmdbSavepoint)savepoint).setReleasedFlagTrue();
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement_bs dmStatement = null;
        this.clearWarnings();
        this.checkClosed();
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warning.notSupportedResultType")));
            resultSetType = 1004;
        }
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else {
            dmStatement = new DmdbStatement_bs(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(dmStatement);
        return dmStatement;
    }

    @Override
    public synchronized DmdbPreparedStatement_bs prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement_bs pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        this.checkClosed();
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warning.notSupportedResultType")));
            resultSetType = 1004;
        }
        if ((pstmt = this.getFromPreparedStmtPool(sql)) != null) {
            pstmt.initializeReusePreparedStmt(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else {
            pstmt = new DmdbPreparedStatement_bs(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(pstmt);
        return pstmt;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement_bs cstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warning.notSupportedResultType")));
            resultSetType = 1004;
        }
        if ((cstmt = this.getFromCallableStmtPool(sql)) != null) {
            cstmt.initializeReuseCallableStmt(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else {
            cstmt = new DmdbCallableStatement_bs(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(cstmt);
        return cstmt;
    }

    @Override
    public synchronized DmdbPreparedStatement_bs prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement_bs pstmt = this.prepareStatement(sql);
        if (pstmt != null) {
            pstmt.setAutoGetKeysInner(autoGeneratedKeys);
        }
        return pstmt;
    }

    @Override
    public synchronized DmdbPreparedStatement_bs prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement_bs pstmt = this.prepareStatement(sql);
        if (pstmt != null) {
            if (columnIndexes != null && columnIndexes.length > 0) {
                pstmt.setAutoGetKeys(true);
            } else {
                pstmt.setAutoGetKeys(false);
            }
        }
        return pstmt;
    }

    @Override
    public synchronized DmdbPreparedStatement_bs prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            String newSql;
            sql = (sql = sql.trim()).charAt(sql.length() - 1) == ';' ? sql.substring(0, sql.length() - 1) : sql;
            String string = newSql = sql.length() > 20 ? sql.substring(0, 20).toLowerCase() : sql.toLowerCase();
            if (newSql.startsWith("insert into ") || newSql.startsWith("update ") || newSql.startsWith("delete ")) {
                newSql = String.valueOf(sql) + " return " + StringUtil.append(columnNames) + " into " + StringUtil.append("?", columnNames.length);
            }
            sql = newSql;
        }
        DmdbPreparedStatement_bs pstmt = this.prepareStatement(sql);
        pstmt.generateKeyColumnNames = columnNames;
        return pstmt;
    }

    public String getExplainInfo(String sqlToExplain) throws SQLException {
        if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!sqlToExplain.equalsIgnoreCase("show_pln_stat")) {
            sqlToExplain = "EXPLAIN " + sqlToExplain;
        }
        return DmJdbcUtil.executeAndGetExplain(this, sqlToExplain);
    }

    public String getSessionTrace(String sql) throws SQLException {
        return DmJdbcUtil.executeAndGetExplain(this, sql);
    }

    public final boolean getDDL_Autocommit() throws SQLException {
        return this.m_connServAttr.ddlAutoCommit;
    }

    public final void setDDL_Autocommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            DmJdbcUtil.executeQuery(this, "SELECT DM_SET_SESSION_AUTOCMT(1)");
            this.m_connServAttr.ddlAutoCommit = true;
        } else {
            DmJdbcUtil.executeQuery(this, "SELECT DM_SET_SESSION_AUTOCMT(0)");
            this.m_connServAttr.ddlAutoCommit = false;
        }
    }

    public DbAccess getDbAccess() {
        return this.m_dbaccess;
    }

    public void setDbAccess(DbAccess dbaccess) {
        this.m_dbaccess = dbaccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        Object object = this.resetMutex;
        synchronized (object) {
            if (this.m_dbaccess != null) {
                this.m_dbaccess.reset();
                DmMsgSend dmMsgSend = this.m_msg;
                synchronized (dmMsgSend) {
                    block9: {
                        try {
                            DmdbSwitch.doSwitchForConnError(this);
                        }
                        catch (SQLException e2) {
                            if (e2.getErrorCode() == 20000) break block9;
                            throw e2;
                        }
                    }
                }
            }
        }
    }

    private void addStmt(Statement stmt) {
        this.getStmtsVec().add(stmt);
    }

    public void delStmt(Statement stmt) {
        if (this.getStmtsVec() == null || this.getStmtsVec().isEmpty()) {
            return;
        }
        this.getStmtsVec().remove(stmt);
    }

    void invalidAllStmt() {
        DmdbStatement_bs stmt = null;
        if (this.getStmtsVec() == null || this.getStmtsVec().isEmpty()) {
            return;
        }
        try {
            int i2 = 0;
            while (i2 < this.getStmtsVec().size()) {
                stmt = (DmdbStatement_bs)this.getStmtsVec().get(i2);
                if (stmt != null && !stmt.closed) {
                    stmt.closeSimple();
                }
                ++i2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public final List<DmServerInfo> getHosts() {
        if (this.serverGroup != null) {
            return this.serverGroup.getSvrList();
        }
        return Arrays.asList(new DmServerInfo(this.getHost(), this.getPort()));
    }

    public void setServPos(int pos) {
        this.m_servPos = pos;
    }

    public int getServPos() {
        return this.m_servPos;
    }

    public boolean hasOneSvr() {
        if (this.serverGroup != null) {
            return this.serverGroup.getSvrList().size() == 1;
        }
        return true;
    }

    public int getStmtPoolSize() {
        return this.stmtPool.size();
    }

    public void addToStmtPool(DmdbStatement_bs stmt) {
        this.stmtPool.add(stmt);
    }

    public DmdbStatement_bs getFromStmtPool() {
        DmdbStatement_bs stmt = this.stmtPool.firstElement();
        this.stmtPool.remove(0);
        return stmt;
    }

    public void addToPreparedStmtPool(DmdbPreparedStatement_bs pstmt) {
    }

    public DmdbPreparedStatement_bs getFromPreparedStmtPool(String sql) {
        return null;
    }

    public void addToCallableStmtPool(DmdbCallableStatement_bs cstmt) {
    }

    public DmdbCallableStatement_bs getFromCallableStmtPool(String sql) {
        return null;
    }

    private boolean checkResultSetType(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        boolean checked = true;
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                checked = false;
            }
        }
        return checked;
    }

    public boolean getIsExecute2() {
        return this.m_isExecute2;
    }

    public void setDmServerVersion(String version) {
        this.m_connServAttr.dmServerVersion = version;
        this.m_isExecute2 = !DmdbConnection_bs.isLower(version, "7.1.2.128");
        this.setLobEmptyCompOrcl(!DmdbConnection_bs.isLower(version, "7.1.5.144"));
    }

    private static boolean isLower(String currentVersion, String baseVersion) {
        String[] serStrs = currentVersion.split("\\.");
        String[] globalStrs = baseVersion.split("\\.");
        int i2 = 0;
        while (i2 < serStrs.length) {
            Integer ser = Integer.valueOf(serStrs[i2]);
            Integer global = Integer.valueOf(globalStrs[i2]);
            if (ser < global) {
                return true;
            }
            if (ser.intValue() != global.intValue()) {
                return false;
            }
            ++i2;
        }
        return false;
    }

    public String getHostMchName() {
        String hostName = "";
        try {
            InetAddress ia = null;
            ia = InetAddress.getLocalHost();
            if (ia != null) {
                hostName = ia.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    public void resetStatments() {
        Vector<DmdbStatement_bs> removeVec = new Vector<DmdbStatement_bs>();
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (this.stmtsVec != null) {
            list.addAll(this.stmtsVec);
        }
        if (this.stmtPool != null) {
            list.addAll(this.stmtPool);
        }
        if (list.size() == 0) {
            return;
        }
        for (Statement stmt : list) {
            try {
                if (stmt instanceof DmdbCallableStatement_bs) {
                    ((DmdbCallableStatement_bs)stmt).allocHandle();
                    ((DmdbCallableStatement_bs)stmt).initialize(((DmdbCallableStatement_bs)stmt).getOriginalSql());
                    ((DmdbCallableStatement_bs)stmt).type = 2;
                } else if (stmt instanceof DmdbPreparedStatement_bs) {
                    ((DmdbPreparedStatement_bs)stmt).allocHandle();
                    ((DmdbPreparedStatement_bs)stmt).initialize(((DmdbPreparedStatement_bs)stmt).getOriginalSql());
                } else if (stmt instanceof DmdbStatement_bs) {
                    ((DmdbStatement_bs)stmt).allocHandle();
                }
                ((DmdbStatement_bs)stmt).closed = false;
            }
            catch (SQLException sQLException) {
                ((DmdbStatement_bs)stmt).closed = true;
                removeVec.add((DmdbStatement_bs)stmt);
            }
        }
        if (removeVec.size() > 0) {
            this.stmtsVec.removeAll(removeVec);
            this.stmtPool.removeAll(removeVec);
        }
    }

    public void resetStandbyStatments() throws SQLException {
        if (this.getRwSeparate()) {
            ArrayList<Statement> list = new ArrayList<Statement>();
            if (this.stmtsVec != null) {
                list.addAll(this.stmtsVec);
            }
            if (this.stmtPool != null) {
                list.addAll(this.stmtPool);
            }
            if (list.size() == 0) {
                return;
            }
            for (Statement stmt : list) {
                ((DmdbStatement_bs)stmt).setHandleForStandby(DmdbCSI.allocStmtHandleOnStandby((DmdbStatement_bs)stmt));
            }
        }
    }

    public Properties getProperties() {
        return this.m_connProps;
    }

    public void setNewLobFlag(byte flag) {
        this.m_connServAttr.newLobFlag = flag != 0;
    }

    public boolean getNewLobFlag() {
        return this.m_connServAttr.newLobFlag;
    }

    public String getGUID() {
        return this.m_connServAttr.guid;
    }

    public void setGUID(String guid) {
        this.m_connServAttr.guid = guid;
    }

    public final String getDmServerVersion() {
        return this.m_connServAttr.dmServerVersion;
    }

    public void setGlobalServerSeries(int series) {
        this.m_connServAttr.globalServerSeries = series;
    }

    public int getGlobalServerSeries() {
        return this.m_connServAttr.globalServerSeries;
    }

    public void setServerEncoding(String serverEncoding) {
        this.m_connServAttr.serverEncoding = serverEncoding;
    }

    public String getServerEncoding() {
        if (StringUtil.isNotEmpty(this.dmSvcConf.getCharCode())) {
            return this.dmSvcConf.getCharCode();
        }
        return this.m_connServAttr.serverEncoding;
    }

    public void setNetworkPacketSize(int packetSize) {
        this.m_connServAttr.networkPacketSize = packetSize;
    }

    public int getNetworkPacketSize() {
        return this.m_connServAttr.networkPacketSize;
    }

    public void setMaxRowSize(short maxRowSize) {
        this.m_connServAttr.maxRowSize = maxRowSize;
    }

    public short getMaxRowSize() {
        return this.m_connServAttr.maxRowSize;
    }

    public void setMaxSession(int maxSession) {
        this.m_connServAttr.maxSession = maxSession;
    }

    public int getMaxSession() {
        return this.m_connServAttr.maxSession;
    }

    public void setDDL_Auto_commit(boolean auto_commit) {
        this.m_connServAttr.ddlAutoCommit = auto_commit;
    }

    public boolean getDDL_Auto_Commit() {
        return this.m_connServAttr.ddlAutoCommit;
    }

    public void setTransLevel(int level) {
        this.m_connServAttr.transLevel = level;
    }

    public int getTransLevel() {
        return this.m_connServAttr.transLevel;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.m_connServAttr.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.m_connServAttr.caseSensitive;
    }

    public void setBackslashEscape(boolean escape) {
        this.m_connServAttr.backslashEscape = escape;
    }

    public boolean getBackslashEscape() {
        return this.m_connServAttr.backslashEscape;
    }

    public void setSvrMode(int svrMode) {
        this.m_connServAttr.svrMode = svrMode;
    }

    public int getSvrMode() {
        return this.m_connServAttr.svrMode;
    }

    public void setSvrStat(int svrStat) {
        this.m_connServAttr.svrStat = svrStat;
    }

    public int getSvrStat() {
        return this.m_connServAttr.svrStat;
    }

    public void setConstParaOpt(byte opt) {
        this.m_connServAttr.constParaOpt = 1 == opt;
    }

    public boolean getConstParaOpt() {
        return this.m_connServAttr.constParaOpt;
    }

    public void setInstanceName(String instName) {
        this.m_connServAttr.instanceName = instName;
    }

    public String getInstanceName() {
        return this.m_connServAttr.instanceName;
    }

    @Override
    public void setSchema(String schema) {
        this.m_connServAttr.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.m_connServAttr.schema;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this.m_connServAttr.lastLoginIP = lastLoginIP;
    }

    public String getLastLoginIP() {
        return this.m_connServAttr.lastLoginIP;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.m_connServAttr.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginTime() {
        return this.m_connServAttr.lastLoginTime;
    }

    public void setFailedAttempt(int failedAttempt) {
        this.m_connServAttr.failedAttempts = failedAttempt;
    }

    public int getFailedAttempt() {
        return this.m_connServAttr.failedAttempts;
    }

    public void setLoginWarningID(int loginWarningID) {
        this.m_connServAttr.loginWarningID = loginWarningID;
    }

    public int getLoginWarningID() {
        return this.m_connServAttr.loginWarningID;
    }

    public void setGraceTimeRemainder(int gracetimeRemainder) {
        this.m_connServAttr.gracetimeRemainder = gracetimeRemainder;
    }

    public int getGraceTimeRemainder() {
        return this.m_connServAttr.gracetimeRemainder;
    }

    public void setLifeTimeRemainder(int lifeTimeRemainder) {
        this.m_connServAttr.lifeTimeRemainder = lifeTimeRemainder;
    }

    public int getLifeTimeRemainder() {
        return this.m_connServAttr.lifeTimeRemainder;
    }

    public void setEncryptMsg(int encryptMsg) {
        this.m_connServAttr.encryptMsg = encryptMsg;
    }

    public int getEncryptMsg() {
        return this.m_connServAttr.encryptMsg;
    }

    public final void setTransAccessMode(int accessMode) {
        this.m_connServAttr.tranAccessMode = accessMode;
    }

    public final int getTransAccessMode() {
        return this.m_connServAttr.tranAccessMode;
    }

    public void setDbTz(short tz) {
        this.m_connServAttr.dbTz = tz;
    }

    public short getDbTz() {
        return this.m_connServAttr.dbTz;
    }

    @Override
    public boolean getRwSeparate() {
        return super.getRwSeparate() && super.getLoginMode() != 2;
    }

    @Override
    public int getLobMode() {
        String value = this.m_clientInfoMapConnStr.getProperty("LobMode");
        if (value == null) {
            return super.getLobMode();
        }
        return Integer.parseInt(value);
    }

    @Override
    public boolean isContinueBatchOnError() {
        String value = this.m_clientInfoMapConnStr.getProperty("continueBatchOnError");
        if (value == null) {
            return super.isContinueBatchOnError();
        }
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isIgnoreCase() {
        String value = this.m_clientInfoMapConnStr.getProperty("ignoreCase");
        if (value == null) {
            return super.isIgnoreCase();
        }
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isCompatibleOracle() {
        String value = this.m_clientInfoMapConnStr.getProperty("comOra");
        if (value == null) {
            return super.isCompatibleOracle();
        }
        return Boolean.valueOf(value);
    }

    @Override
    public int getBatchType() {
        String value = this.m_clientInfoMapConnStr.getProperty("batchType");
        if (value == null) {
            return super.getBatchType();
        }
        return Integer.parseInt(value);
    }

    public boolean needSwitchForConnError() {
        return super.isDoSwitch() && !this.hasOneSvr();
    }

    public ServerGroup getServerGroup() {
        return this.serverGroup;
    }

    public void setCheckLoadBalanceTs(long checkLoadBalanceTs) {
        this.checkLoadBalanceTs = checkLoadBalanceTs;
    }

    public long getCheckLoadBalanceTs() {
        return this.checkLoadBalanceTs;
    }

    public void setStmtsVec(Vector<Statement> stmtsVec) {
        this.stmtsVec = stmtsVec;
    }

    public Vector<Statement> getStmtsVec() {
        return this.stmtsVec;
    }

    public ConnServAttr getConnServAttr() {
        return this.m_connServAttr;
    }

    public void setConnServAttr(ConnServAttr connServAttr) {
        this.m_connServAttr = connServAttr;
    }

    public int getActiveStmtCount() {
        if (this.stmtsVec != null) {
            int count = 0;
            for (Statement stmt : this.stmtsVec) {
                if (((DmdbStatement_bs)stmt).closed) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public void setLobEmptyCompOrcl(boolean m_lobEmptyCompOrcl) {
        this.m_lobEmptyCompOrcl = m_lobEmptyCompOrcl;
    }

    public boolean isLobEmptyCompOrcl() {
        return this.m_lobEmptyCompOrcl;
    }

    public void setRwLatestDestType(int rwLatestDestType) {
        this.rwLatestDestType = rwLatestDestType;
    }

    public int getRwLatestDestType() {
        return this.rwLatestDestType;
    }

    public Object nonStandardInterface(String name) {
        if (name == null) {
            return null;
        }
        return this.infoMap.get(name.toLowerCase());
    }

    public void setInfo(String name, Object value) {
        this.infoMap.put(name.toLowerCase(), value);
    }

    public static class ConnServAttr {
        int tranAccessMode = 0;
        short maxRowSize;
        int maxSession;
        boolean ddlAutoCommit;
        int transLevel = -1;
        boolean caseSensitive = true;
        boolean backslashEscape;
        int svrMode;
        int svrStat;
        boolean constParaOpt = false;
        short dbTz = 0;
        String instanceName;
        String schema;
        String lastLoginIP;
        String lastLoginTime;
        int failedAttempts;
        int loginWarningID;
        int gracetimeRemainder;
        int lifeTimeRemainder;
        String guid;
        boolean newLobFlag;
        int encryptMsg = 0;
        public int comprMsg;
        String dmServerVersion = null;
        int globalServerSeries = 0;
        String serverEncoding = null;
        int networkPacketSize;

        public ConnServAttr clone() {
            ConnServAttr connServAttr = new ConnServAttr();
            connServAttr.tranAccessMode = this.tranAccessMode;
            connServAttr.maxRowSize = this.maxRowSize;
            connServAttr.maxSession = this.maxSession;
            connServAttr.ddlAutoCommit = this.ddlAutoCommit;
            connServAttr.transLevel = this.transLevel;
            connServAttr.caseSensitive = this.caseSensitive;
            connServAttr.backslashEscape = this.backslashEscape;
            connServAttr.svrMode = this.svrMode;
            connServAttr.svrStat = this.svrStat;
            connServAttr.constParaOpt = this.constParaOpt;
            connServAttr.dbTz = this.dbTz;
            connServAttr.instanceName = this.instanceName;
            connServAttr.schema = this.schema;
            connServAttr.lastLoginIP = this.lastLoginIP;
            connServAttr.lastLoginTime = this.lastLoginTime;
            connServAttr.failedAttempts = this.failedAttempts;
            connServAttr.loginWarningID = this.loginWarningID;
            connServAttr.gracetimeRemainder = this.gracetimeRemainder;
            connServAttr.guid = this.guid;
            connServAttr.newLobFlag = this.newLobFlag;
            connServAttr.encryptMsg = this.encryptMsg;
            connServAttr.comprMsg = this.comprMsg;
            connServAttr.dmServerVersion = this.dmServerVersion;
            connServAttr.globalServerSeries = this.globalServerSeries;
            connServAttr.serverEncoding = this.serverEncoding;
            connServAttr.networkPacketSize = this.networkPacketSize;
            return connServAttr;
        }
    }
}

