/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    private DmdbBlob blob;
    private DmdbClob clob;
    private int typeFlag;
    private long position = 0L;

    public DmdbOutputStream(Object o2, long p2) throws SQLException {
        if (o2 instanceof DmdbBlob) {
            this.blob = (DmdbBlob)o2;
            this.typeFlag = 0;
        } else if (o2 instanceof DmdbClob) {
            this.clob = (DmdbClob)o2;
            this.typeFlag = 1;
        } else {
            throw new SQLException("Only permit DmdbBlob and DmdbClob object");
        }
        this.position = p2;
    }

    public void write(int a2) throws IOException {
        byte[] tempByte = new byte[]{(byte)a2};
        this.write(tempByte, 0, 1);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        block9: {
            if (off < 0) {
                throw new IndexOutOfBoundsException(new Integer(off).toString());
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException(new Integer(len).toString());
            }
            if (off + len > b2.length) {
                throw new IndexOutOfBoundsException(new Integer(off + len).toString());
            }
            try {
                if (this.typeFlag == 0) {
                    this.blob.setBytes(this.position, b2, off, len);
                    this.position += (long)len;
                    break block9;
                }
                if (this.typeFlag == 1) {
                    byte[] tempByte;
                    if (len == b2.length && off == 0) {
                        tempByte = b2;
                    } else {
                        tempByte = new byte[len];
                        System.arraycopy(b2, off, tempByte, 0, len);
                    }
                    String tempStr = new String(tempByte);
                    this.clob.setString(this.position, tempStr, 0, tempStr.length());
                    this.position += (long)tempStr.length();
                    break block9;
                }
                throw new SQLException("Fatal error occured in DmdbOutputStream ");
            }
            catch (SQLException e2) {
                DBError.SQLToIOException(e2);
            }
        }
    }
}

