/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.BFileInner;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmARRAYBinder;
import dm.jdbc.dataConvertion.binder.DmBigDecBinder;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dataConvertion.binder.DmBlobBinder;
import dm.jdbc.dataConvertion.binder.DmBooleanBinder;
import dm.jdbc.dataConvertion.binder.DmByteArrBinder;
import dm.jdbc.dataConvertion.binder.DmByteBinder;
import dm.jdbc.dataConvertion.binder.DmClobBinder;
import dm.jdbc.dataConvertion.binder.DmDateBinder;
import dm.jdbc.dataConvertion.binder.DmDmdbTimestampBinder;
import dm.jdbc.dataConvertion.binder.DmDoubleBinder;
import dm.jdbc.dataConvertion.binder.DmFloatBinder;
import dm.jdbc.dataConvertion.binder.DmInputStreamBinder;
import dm.jdbc.dataConvertion.binder.DmIntBinder;
import dm.jdbc.dataConvertion.binder.DmIntvDTBinder;
import dm.jdbc.dataConvertion.binder.DmIntvYMBinder;
import dm.jdbc.dataConvertion.binder.DmLongBinder;
import dm.jdbc.dataConvertion.binder.DmNullBinder;
import dm.jdbc.dataConvertion.binder.DmOutParamBinder;
import dm.jdbc.dataConvertion.binder.DmReaderBinder;
import dm.jdbc.dataConvertion.binder.DmSTRUCTBinder;
import dm.jdbc.dataConvertion.binder.DmShortBinder;
import dm.jdbc.dataConvertion.binder.DmStringBinder;
import dm.jdbc.dataConvertion.binder.DmTimeBinder;
import dm.jdbc.dataConvertion.binder.DmTimestampBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.dbaccess.DmdbSwitch;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.DmdbParamVal;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmInputStreamParam;
import dm.jdbc.driver.DmReaderParam;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbParameterMetaData_bs;
import dm.jdbc.driver.DmdbResultSetCache_g;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.rsCache.DmdbCachedResultSetPool;
import dm.jdbc.rsCache.DmdbResultSetKey;
import dm.sql.ARRAY;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbSQLOutput;
import dm.sql.DmdbTimestamp;
import dm.sql.STRUCT;
import dm.sql.StructDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;

public class DmdbPreparedStatement_bs
extends DmdbStatement_bs
implements PreparedStatement {
    ParameterDesc[] m_paramsDesc = null;
    private int m_outParamCount = 0;
    boolean realClose = false;
    private final ResourceBundle res = DmSvcConf.res;
    Object[] m_curRowObjects = null;
    Object[][] m_paramObjects = null;
    byte[][] m_nullIndicator = null;
    byte[] m_curRowNullIndicator = null;
    private int m_rowIndex = -1;
    protected DmBinder[] m_curRow = null;
    private int m_rowsAllocated;
    protected byte[] m_bindIndicator = null;
    protected boolean m_isBatchOpt = false;
    public int paramCount;
    public String[] generateKeyColumnNames = null;
    public byte[][][] generateKeys = null;

    public DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
    }

    void initialize(String sql) throws SQLException {
        try {
            this.checkNullOrEmpty(sql);
            if (this.process_escapes) {
                sql = this.connection.nativeSQL(sql);
            }
            this.originalSql = sql;
            this.dbInfo = null;
            if (this.dbInfo == null) {
                this.dbInfo = this.directExec(this, this.originalSql, false, 0);
            }
            this.setParamsDesc(this.dbInfo.getParamsInfo());
            this.initializeParam();
            this.type = 1;
            this.m_insertTableName = this.getTableNameBySql(this.originalSql);
        }
        catch (SQLException e2) {
            try {
                this.innerClose();
            }
            catch (SQLException sQLException) {}
            throw e2;
        }
    }

    void initializeParam() throws SQLException {
        this.m_isBatchOpt = false;
        if (this.m_paramsDesc == null) {
            this.m_outParamCount = 0;
            if (this.m_curRow == null) {
                this.m_curRow = new DmBinder[0];
            }
            this.m_bindIndicator = null;
            this.m_rowIndex = -1;
            this.m_paramObjects = null;
            this.m_curRowObjects = null;
            return;
        }
        this.m_rowIndex = -1;
        this.m_rowsAllocated = 2;
        if (this.m_curRow != null) {
            int i2 = 0;
            while (i2 < this.paramCount) {
                if (this.m_curRow[i2] != null) {
                    if (this.m_curRow[i2] instanceof DmOutParamBinder) {
                        this.m_curRow[i2].setInoutParamBinder(null);
                        if (this.m_paramsDesc[i2].getIOType() == 2) {
                            this.m_curRow[i2].setInoutParamBinder(new DmNullBinder(this));
                        }
                    } else {
                        this.m_curRow[i2] = new DmNullBinder(this);
                    }
                }
                ++i2;
            }
        } else {
            this.m_curRow = new DmBinder[this.paramCount];
            this.m_outParamCount = 0;
            int i3 = 0;
            while (i3 < this.paramCount) {
                if (this.m_paramsDesc[i3].getIOType() == 0) {
                    this.m_curRow[i3] = new DmNullBinder(this);
                } else {
                    this.m_curRow[i3] = new DmOutParamBinder(this);
                    ++this.m_outParamCount;
                    if (this.m_paramsDesc[i3].getIOType() == 2) {
                        this.m_curRow[i3].setInoutParamBinder(new DmNullBinder(this));
                    }
                }
                ++i3;
            }
        }
        this.m_curRowObjects = new Object[this.paramCount];
        this.m_curRowNullIndicator = new byte[this.paramCount];
        this.m_bindIndicator = new byte[this.paramCount];
    }

    void initializeReusePreparedStmt(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super.initializeReuseStmt(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
        this.type = 1;
    }

    protected void checkIndexInner(int index) throws SQLException {
        if (index < 1 || index > this.paramCount) {
            DBError.throwSQLException(6010);
        }
    }

    protected synchronized void paramBindPrepare(int paramIndex) throws SQLException {
        this.checkIndexInner(paramIndex);
        int i2 = paramIndex - 1;
        if (!this.m_isBatchOpt && (this.m_bindIndicator[i2] & 1) == 1) {
            if (this.m_curRow[i2] != null) {
                if (this.m_curRow[i2] instanceof DmOutParamBinder) {
                    this.m_curRow[i2].setInoutParamBinder(null);
                    if (this.m_paramsDesc[i2].getIOType() == 2) {
                        this.m_curRow[i2].setInoutParamBinder(new DmNullBinder(this));
                    }
                } else {
                    this.m_curRow[i2] = new DmNullBinder(this);
                }
            }
            this.m_curRowObjects[i2] = null;
        }
        this.m_curRowNullIndicator[i2] = 0;
        int n2 = i2;
        this.m_bindIndicator[n2] = (byte)(this.m_bindIndicator[n2] | 1);
    }

    private void growBinds(int totalRows) {
        if (this.m_paramObjects == null) {
            this.m_paramObjects = new Object[this.m_rowsAllocated][this.paramCount];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new byte[this.m_rowsAllocated][this.paramCount];
        }
        if (totalRows < this.m_rowsAllocated) {
            return;
        }
        int destRows = 0;
        destRows = this.m_rowsAllocated > 20000 ? this.m_rowsAllocated + 20000 : this.m_rowsAllocated * 2;
        Object lparam = this.m_paramObjects;
        this.m_paramObjects = new Object[destRows][this.paramCount];
        System.arraycopy(lparam, 0, this.m_paramObjects, 0, totalRows);
        lparam = this.m_nullIndicator;
        this.m_nullIndicator = new byte[destRows][this.paramCount];
        System.arraycopy(lparam, 0, this.m_nullIndicator, 0, totalRows);
        this.m_rowsAllocated = destRows;
    }

    private void checkParamBoundInner() throws SQLException {
        int index = 0;
        while (index < this.paramCount) {
            if (this.m_paramsDesc[index].getIOType() == 0 && (this.m_bindIndicator == null || (this.m_bindIndicator[index] & 1) == 0)) {
                DBError.throwSQLException(6054);
                break;
            }
            ++index;
        }
    }

    private void addBatchInner() throws SQLException {
        this.checkParamBoundInner();
        if (this.m_rowIndex < 0) {
            this.m_rowIndex = 0;
        }
        this.growBinds(this.m_rowIndex);
        if (this.m_curRowObjects != null && this.m_curRowObjects.length > 0) {
            System.arraycopy(this.m_curRowObjects, 0, this.m_paramObjects[this.m_rowIndex], 0, this.m_curRowObjects.length);
            System.arraycopy(this.m_curRowNullIndicator, 0, this.m_nullIndicator[this.m_rowIndex], 0, this.m_curRowNullIndicator.length);
        }
        ++this.m_rowIndex;
        this.m_isBatchOpt = true;
    }

    private void setObjectInner(int paramIndex, Object value) throws SQLException {
        if (value == null) {
            this.setNull(paramIndex, 0);
            return;
        }
        if (value instanceof Boolean) {
            this.setBooleanInner(paramIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(paramIndex, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(paramIndex, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntInner(paramIndex, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongInner(paramIndex, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatInner(paramIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleInner(paramIndex, (Double)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimalInner(paramIndex, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.setBigDecimalInner(paramIndex, new BigDecimal((BigInteger)value));
        } else if (value instanceof Date) {
            this.setDateInner(paramIndex, (Date)value);
        } else if (value instanceof Timestamp) {
            this.setTimestampInner(paramIndex, (Timestamp)value);
        } else if (value instanceof Time) {
            this.setTimeInner(paramIndex, (Time)value);
        } else if (value instanceof DmdbTimestamp) {
            this.setTIMESTAMPInner(paramIndex, (DmdbTimestamp)value);
        } else if (value instanceof DmdbIntervalDT) {
            this.setINTERVALDTInner(paramIndex, (DmdbIntervalDT)value);
        } else if (value instanceof DmdbIntervalYM) {
            this.setINTERVALYMInner(paramIndex, (DmdbIntervalYM)value);
        } else if (value instanceof java.util.Date) {
            java.util.Date udt = (java.util.Date)value;
            Date date = new Date(udt.getTime());
            this.setDateInner(paramIndex, date);
        } else if (value instanceof String) {
            this.setStringInner(paramIndex, (String)value);
        } else if (value instanceof byte[]) {
            this.setBytesInner(paramIndex, (byte[])value);
        } else if (value instanceof Blob) {
            this.setBlobInner(paramIndex, (Blob)value);
        } else if (value instanceof Clob) {
            this.setClobInner(paramIndex, (Clob)value);
        } else if (value instanceof Reader) {
            this.setReaderInner(paramIndex, (Reader)value, 0L, false);
        } else if (value instanceof InputStream) {
            this.setInputstreamInner(paramIndex, (InputStream)value, 0L, false);
        } else if (value instanceof ARRAY) {
            this.setArrayInner(paramIndex, (Array)value);
        } else if (value instanceof STRUCT) {
            this.setStructInner(paramIndex, (Struct)value);
        } else if (value instanceof Character) {
            char[] chars = new char[]{((Character)value).charValue()};
            this.setStringInner(paramIndex, new String(chars));
        } else if (value instanceof SQLData) {
            String typeName = ((SQLData)value).getSQLTypeName();
            if (this.connection.getTypeMap().containsKey(typeName) && value.getClass() == this.connection.getTypeMap().get(typeName)) {
                StructDescriptor desc = StructDescriptor.createDescriptor(typeName, this.connection);
                DmdbSQLOutput stream = new DmdbSQLOutput();
                ((SQLData)value).writeSQL(stream);
                STRUCT struct = new STRUCT(desc, this.connection, stream.getAttribs());
                this.setStructInner(paramIndex, struct);
            } else {
                DBError.throwSQLException(6007);
            }
        } else if (value instanceof DmdbBFile) {
            this.setStringInner(paramIndex, Convertion.bfileToString((BFileInner)value));
        } else {
            DBError.throwUnsupportedSQLException();
        }
    }

    public final int getBatchSize() {
        return this.m_rowIndex;
    }

    public final DmBinder[] getParamBoundDesc() throws SQLException {
        return this.m_curRow;
    }

    public int getOutParamCount() {
        return this.m_outParamCount;
    }

    public void copyParamValueBound(DmdbResultSetKey rsKey) {
        if (this.paramCount <= 0 || this.paramCount - this.getOutParamCount() <= 0) {
            return;
        }
        if (this.m_isBatchOpt) {
            rsKey.m_paramObjects = new Object[this.m_paramObjects.length];
            System.arraycopy(this.m_paramObjects, 0, rsKey.m_paramObjects, 0, this.m_paramObjects.length);
        } else {
            rsKey.m_paramObjects = new Object[this.m_curRowObjects.length];
            System.arraycopy(this.m_curRowObjects, 0, rsKey.m_paramObjects, 0, this.m_curRowObjects.length);
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        this.executeInner(0, 2);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        return this.getCurrentRs();
    }

    public synchronized ResultSet executeQuery2() throws SQLException {
        this.fromRowSetFlag = true;
        this.executeInner(0, 4);
        return this.getCurrentRs();
    }

    public int executeUpdate() throws SQLException {
        return (int)this.executeUpdate_ex(0);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setNullInner(parameterIndex, DmdbType.sqlTypeToDType(sqlType));
    }

    private void setNullInner(int parameterIndex, int dType) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1].setRecDType(dType);
        }
        this.m_curRowNullIndicator[parameterIndex - 1] = 1;
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setBooleanInner(parameterIndex, x2);
    }

    private void setBooleanInner(int parameterIndex, boolean x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmBooleanBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmBooleanBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmBooleanBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Boolean(x2);
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setByteInner(parameterIndex, x2);
    }

    private void setByteInner(int parameterIndex, byte x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmByteBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmByteBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmByteBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Byte(x2);
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setShortInner(parameterIndex, x2);
    }

    private void setShortInner(int parameterIndex, short x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmShortBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmShortBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmShortBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Short(x2);
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setIntInner(parameterIndex, x2);
    }

    private void setIntInner(int parameterIndex, int x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmIntBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmIntBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmIntBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Integer(x2);
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setLongInner(parameterIndex, x2);
    }

    private void setLongInner(int parameterIndex, long x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmLongBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmLongBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmLongBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Long(x2);
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setFloatInner(parameterIndex, x2);
    }

    private void setFloatInner(int parameterIndex, float x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmFloatBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmFloatBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmFloatBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Float(x2);
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setDoubleInner(parameterIndex, x2);
    }

    private void setDoubleInner(int parameterIndex, double x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmDoubleBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmDoubleBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmDoubleBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = new Double(x2);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setBigDecimalInner(parameterIndex, x2);
    }

    private void setBigDecimalInner(int parameterIndex, BigDecimal x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 9);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmBigDecBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmBigDecBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmBigDecBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setStringInner(parameterIndex, x2);
    }

    private void setStringInner(int parameterIndex, String x2) throws SQLException {
        if (x2 == null || x2.length() == 0 && DmdbType.emptyStringToNull(this.m_paramsDesc[parameterIndex - 1].getDType())) {
            this.setNullInner(parameterIndex, 2);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmStringBinder(this, x2 == null ? 0 : x2.length()));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmStringBinder(this, x2 == null ? 0 : x2.length());
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmStringBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmStringBinder(this, x2 == null ? 0 : x2.length());
            }
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setBytesInner(parameterIndex, x2);
    }

    private void setBytesInner(int parameterIndex, byte[] x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 17);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmByteArrBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmByteArrBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmByteArrBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmByteArrBinder(this);
            }
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setDateInner(parameterIndex, x2);
    }

    private void setDateInner(int parameterIndex, Date x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 14);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmDateBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmDateBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmDateBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setTimeInner(parameterIndex, x2);
    }

    private void setTimeInner(int parameterIndex, Time x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 15);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmTimeBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmTimeBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmTimeBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setTimestampInner(parameterIndex, x2);
    }

    private void setTimestampInner(int parameterIndex, Timestamp x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 16);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmTimestampBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmTimestampBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmTimestampBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, length, true);
    }

    private void setInputstreamInner(int parameterIndex, InputStream x2, long length, boolean hasLength) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 12);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmInputStreamBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmInputStreamBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmInputStreamBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmInputStreamBinder(this);
                this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
            } else {
                throw new SQLException("Different object bound with the first row in the same column");
            }
        }
        this.m_curRowObjects[parameterIndex - 1] = hasLength ? new DmInputStreamParam(x2, length) : new DmInputStreamParam(x2);
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, length, true);
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, 0L, false);
    }

    public synchronized void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x2, 0L, false);
    }

    public synchronized void clearParameters() throws SQLException {
        this.initializeParam();
    }

    void resetState() throws SQLException {
        super.resetState(false);
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.getCurrentRs() != null) {
            this.getCurrentRs().close();
            this.setCurrentRs(null);
        }
        this.innerClose();
    }

    public synchronized void innerClose() throws SQLException {
        try {
            super.innerClose();
        }
        finally {
            this.m_paramsDesc = null;
            this.m_outParamCount = 0;
            this.m_curRow = null;
            this.m_bindIndicator = null;
            this.m_rowIndex = -1;
            this.m_paramObjects = null;
            this.m_curRowObjects = null;
            this.realClose = false;
        }
    }

    private boolean isValidDecimalObject(Object x2) {
        if (x2 == null) {
            return false;
        }
        return x2 instanceof BigDecimal || x2 instanceof Boolean || x2 instanceof Byte || x2 instanceof Double || x2 instanceof Float || x2 instanceof Integer || x2 instanceof Long || x2 instanceof Short || x2 instanceof String;
    }

    public synchronized void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        if ((targetSqlType == 3 || targetSqlType == 2) && this.isValidDecimalObject(x2)) {
            String strValue = "";
            strValue = x2 instanceof Boolean ? ((Boolean)x2 != false ? "1" : "0") : String.valueOf(x2);
            BigDecimal bgd = new BigDecimal(strValue);
            x2 = bgd.setScale(scale, 4);
        }
        this.setObjectInner(parameterIndex, x2);
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x2, targetSqlType, this.m_paramsDesc[parameterIndex - 1].getScale());
    }

    public synchronized void setObject(int parameterIndex, Object x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setObjectInner(parameterIndex, x2);
    }

    public synchronized boolean execute() throws SQLException {
        this.executeInner(0, 1);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        return this.dbInfo.getHasResultSet();
    }

    public void addBatch() throws SQLException {
        this.addBatchInner();
    }

    private boolean checkBatch() {
        return this.m_rowIndex >= 0;
    }

    private int[] executeBatchNot() throws SQLException {
        try {
            int nbrCommands = this.m_rowIndex;
            int[] updateCounts = new int[nbrCommands];
            int i2 = 0;
            while (i2 < nbrCommands) {
                updateCounts[i2] = -3;
                ++i2;
            }
            Throwable sqlEx = null;
            int commandIndex = 0;
            while (commandIndex < nbrCommands) {
                try {
                    updateCounts[commandIndex] = (int)this.executeUpdate_ex(commandIndex);
                    this.setPutLobData(2);
                }
                catch (SQLException ex) {
                    updateCounts[commandIndex] = -3;
                    if (this.connection.isContinueBatchOnError()) {
                        sqlEx = ex;
                    }
                    int[] newUpdateCounts = new int[commandIndex];
                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                }
                ++commandIndex;
            }
            if (sqlEx != null) {
                throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
            }
            int[] nArray = updateCounts != null ? updateCounts : new int[]{};
            return nArray;
        }
        finally {
            this.setPutLobData(1);
            this.clearBatch();
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.clearGeneratedKeys();
        DmdbSwitch.doSwitchForLoadBalance(this.connection);
        if (this.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        if (this.dbInfo.getRetStmtType() == 160 || this.dbInfo.getRetStmtType() == 198) {
            throw new BatchUpdateException(this.res.getString("error.invalidSqlType"), null);
        }
        if (this.m_batchItems != null) {
            return super.executeBatch();
        }
        int batchSize = this.m_rowIndex > 0 ? this.m_rowIndex : 0;
        int[] updateCounts = new int[batchSize];
        if (this.checkBatch()) {
            if (this.connection.isCallBatchNot() && this.dbInfo.getRetStmtType() == 162 || !this.getIsPutLobData_In() || batchSize == 0 || batchSize == 1 || this.connection.getBatchType() == 2) {
                updateCounts = this.executeBatchNot();
            } else {
                try {
                    updateCounts = DmdbCSI.executePreparedBatch(this);
                }
                catch (SQLException ex) {
                    this.clearBatch();
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), updateCounts);
                }
            }
            this.clearBatch();
        }
        if (this.connection.isCompatibleOracle()) {
            int i2 = 0;
            while (i2 < updateCounts.length) {
                updateCounts[i2] = -2;
                ++i2;
            }
        }
        return updateCounts;
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, length, true);
    }

    private void setReaderInner(int parameterIndex, Reader reader, long length, boolean hasLenght) throws SQLException {
        if (reader == null) {
            this.setNullInner(parameterIndex, 19);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmReaderBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmReaderBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmReaderBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmReaderBinder(this);
                this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
            } else {
                throw new SQLException("Different object bound with the first row in the same column");
            }
        }
        this.m_curRowObjects[parameterIndex - 1] = hasLenght ? new DmReaderParam(reader, length) : new DmReaderParam(reader);
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, length, true);
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, 0L, false);
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        this.paramBindPrepare(i2);
        if (x2 != null) {
            throw new SQLException(DmSvcConf.res.getString("error.unsupportedInterfase"));
        }
        this.setNull(i2, 2006);
    }

    public void setBlob(int i2, Blob x2) throws SQLException {
        this.paramBindPrepare(i2);
        this.setBlobInner(i2, x2);
    }

    private void setBlobInner(int parameterIndex, Blob x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 12);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmBlobBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmBlobBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmBlobBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmBlobBinder(this);
                this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
            } else {
                throw new SQLException("Different object bound with the first row in the same column");
            }
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        this.paramBindPrepare(i2);
        this.setClobInner(i2, x2);
    }

    private void setClobInner(int parameterIndex, Clob x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 19);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmClobBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmClobBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmClobBinder)) {
            if (!DmdbPreparedStatement_bs.isLobBinder(this.m_curRow[parameterIndex - 1])) {
                this.m_curRow[parameterIndex - 1] = new DmClobBinder(this);
                this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
            } else {
                throw new SQLException("Different object bound with the first row in the same column");
            }
        }
        this.m_curRowObjects[parameterIndex - 1] = x2;
    }

    public void setArray(int i2, Array x2) throws SQLException {
        this.paramBindPrepare(i2);
        this.setArrayInner(i2, x2);
    }

    private void setArrayInner(int parameterIndex, Array x2) throws SQLException {
        if (x2 == null) {
            this.setNullInner(parameterIndex, 117);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmARRAYBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmARRAYBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmARRAYBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = (ARRAY)x2;
    }

    private void setStructInner(int parameterIndex, Struct x2) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmSTRUCTBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmSTRUCTBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmSTRUCTBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = (STRUCT)x2;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.dbInfo != null && this.dbInfo.getHasResultSet()) {
            return new DmdbResultSetMetaData_bs(this, this.dbInfo.getColumnsInfo(), this.resultSetConcurrency, this.connection.isCompatibleOracle(), this.connection.isClobAsString());
        }
        return null;
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x2.getTime());
        this.setDate(parameterIndex, new Date(cal.getTimeInMillis()));
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x2.getTime());
        this.setTime(parameterIndex, new Time(cal.getTimeInMillis()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(x2);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = x2.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        this.setTimestamp(parameterIndex, xn);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.paramBindPrepare(parameterIndex);
        if (x2 != null) {
            throw new SQLException(DmSvcConf.res.getString("error.unsupportedInterfase"));
        }
        this.setNull(parameterIndex, 2000);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new DmdbParameterMetaData_bs(this, this.connection.isCompatibleOracle());
    }

    public void setINTERVALYM(int i2, DmdbIntervalYM ym) throws SQLException {
        this.paramBindPrepare(i2);
        this.setINTERVALYMInner(i2, ym);
    }

    private void setINTERVALYMInner(int parameterIndex, DmdbIntervalYM ym) throws SQLException {
        if (ym == null) {
            this.setNullInner(parameterIndex, 20);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmIntvYMBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmIntvYMBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmIntvYMBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = ym;
    }

    public void setINTERVALDT(int i2, DmdbIntervalDT dt) throws SQLException {
        this.paramBindPrepare(i2);
        this.setINTERVALDTInner(i2, dt);
    }

    private void setINTERVALDTInner(int parameterIndex, DmdbIntervalDT dt) throws SQLException {
        if (dt == null) {
            this.setNullInner(parameterIndex, 21);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmIntvDTBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmIntvDTBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmIntvDTBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = dt;
    }

    public void setTIMESTAMP(int i2, DmdbTimestamp t2) throws SQLException {
        this.paramBindPrepare(i2);
        this.setTIMESTAMPInner(i2, t2);
    }

    private void setTIMESTAMPInner(int parameterIndex, DmdbTimestamp t2) throws SQLException {
        if (t2 == null) {
            this.setNullInner(parameterIndex, 15);
            return;
        }
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmDmdbTimestampBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmDmdbTimestampBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmDmdbTimestampBinder)) {
            this.m_curRow[parameterIndex - 1].setDiffParamObjectType(true);
        }
        this.m_curRowObjects[parameterIndex - 1] = t2;
    }

    protected DmdbInfo preparedExceute(int irow) throws SQLException {
        return DmdbCSI.executePrepared(this, irow);
    }

    protected synchronized long executeUpdate_ex(int irow) throws SQLException {
        this.executeInner(irow, 3);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        if (this.dbInfo.getRowCount() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.dbInfo.getRowCount();
    }

    private void executeInner(int irow, int typeExec) throws SQLException {
        try {
            this.checkClosed();
            this.clearGeneratedKeys();
            DmdbSwitch.doSwitchForLoadBalance(this.connection);
            if (!this.m_isBatchOpt) {
                this.checkParamBoundInner();
            }
            this.resId = 0;
            boolean getCachedRs = false;
            boolean innerQuery = false;
            switch (typeExec) {
                case 2: {
                    if (!this.connection.isCompatibleOracle() && !this.dbInfo.isRetStmtTypeQuery()) {
                        DBError.throwSQLException(6009);
                    }
                    getCachedRs = true;
                    break;
                }
                case 3: {
                    if (!this.connection.isCompatibleOracle() && this.connection.isReadOnly()) {
                        DBError.throwSQLException(6008);
                    }
                    if (this.connection.isCompatibleOracle() || !this.dbInfo.isRetStmtTypeUpd()) break;
                    DBError.throwSQLException(6009);
                    break;
                }
                case 1: {
                    getCachedRs = true;
                    break;
                }
                case 4: {
                    innerQuery = true;
                    break;
                }
                default: {
                    DBError.throwSQLException(20005);
                }
            }
            if (getCachedRs) {
                ++DmdbConnection_bs.execSqlNum;
                if (this.enableRsCache()) {
                    this.setCurrentRs(DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this));
                } else {
                    this.setCurrentRs(null);
                }
                if (this.getCurrentRs() != null) {
                    ++DmdbConnection_bs.rsCachedNum;
                    this.dbInfo = this.getCurrentRs().dbInfo;
                    return;
                }
            }
            this.dbInfo = this.preparedExceute(irow);
            if (this.dbInfo.getHasResultSet()) {
                this.resId = (short)(this.resId + 1);
            }
            if (innerQuery) {
                this.setCurrentRs(this.getResultSet(true));
            } else {
                this.setCurrentRs(this.getResultSetPrivate(1));
            }
        }
        catch (SQLException sqlEx) {
            this.realClose = true;
            throw sqlEx;
        }
    }

    protected void setParamsDesc(ParameterDesc[] paramsInfo) throws SQLException {
        this.m_paramsDesc = this.dbInfo.getParamsInfo();
        this.paramCount = this.m_paramsDesc == null ? 0 : this.m_paramsDesc.length;
    }

    public int getSqlType() throws SQLException {
        int sqlType;
        int retType = this.dbInfo.getRetStmtType();
        switch (retType) {
            case 162: 
            case 178: {
                sqlType = 3;
                break;
            }
            case 160: {
                sqlType = 1;
                break;
            }
            case 152: {
                sqlType = 4;
                break;
            }
            default: {
                sqlType = 2;
            }
        }
        return sqlType;
    }

    public void setParamValue(int colIndex, DmdbParamVal paraVal) throws SQLException {
        this.checkIndexInner(colIndex);
        int jtype = paraVal.getObjType();
        Object obj = paraVal.getObjVal();
        if (obj == null) {
            this.setNull(colIndex, 0);
            return;
        }
        switch (jtype) {
            case 25: {
                if (paraVal.hasTargetScale() && obj instanceof BigDecimal) {
                    this.setObject(colIndex, paraVal.getObjVal(), 3, paraVal.getTargetScale());
                    break;
                }
                this.setObject(colIndex, obj);
                break;
            }
            case 18: {
                if (paraVal.hasLength()) {
                    this.setCharacterStream(colIndex, (Reader)obj, paraVal.getLength());
                    break;
                }
                this.setCharacterStream(colIndex, (Reader)obj);
                break;
            }
            case 19: {
                if (paraVal.hasLength()) {
                    this.setAsciiStream(colIndex, (InputStream)obj, paraVal.getLength());
                    break;
                }
                this.setAsciiStream(colIndex, (InputStream)obj);
                break;
            }
            default: {
                this.setObject(colIndex, obj);
            }
        }
    }

    public ParameterDesc[] getParamsDesc() {
        return this.m_paramsDesc;
    }

    public int[] getParamIndex_forPL(String ParamName) throws SQLException {
        int[] list = new int[this.m_paramsDesc.length];
        int pCount = -1;
        int x2 = 0;
        int i2 = 0;
        while (i2 < this.m_paramsDesc.length) {
            if (this.m_paramsDesc[i2].getName().equalsIgnoreCase(ParamName)) {
                list[x2] = i2 + 1;
                pCount = i2;
                ++x2;
            }
            ++i2;
        }
        if (pCount == -1) {
            DBError.throwSQLException(6050);
        }
        int[] paramIndexs = new int[x2];
        System.arraycopy(list, 0, paramIndexs, 0, x2);
        return paramIndexs;
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.clearParameters();
    }

    public Object getParamObject(int irow, int icol) {
        if (this.m_isBatchOpt) {
            return this.m_paramObjects[irow][icol];
        }
        return this.m_curRowObjects[icol];
    }

    public Object[] getParamObjects() {
        if (this.m_isBatchOpt) {
            return this.m_paramObjects;
        }
        return this.m_curRowObjects;
    }

    public final byte getNullIndicator(int irow, int icol) throws SQLException {
        if (this.m_isBatchOpt) {
            return this.m_nullIndicator[irow][icol];
        }
        return this.m_curRowNullIndicator[icol];
    }

    public void setRealClose(boolean rClose) {
        this.realClose = rClose;
    }

    public static boolean isLobBinder(DmBinder binder) {
        return binder instanceof DmBlobBinder || binder instanceof DmClobBinder || binder instanceof DmReaderBinder || binder instanceof DmInputStreamBinder;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.generateKeys != null && this.generateKeyColumnNames != null) {
            DmdbInfo newDbInfo = new DmdbInfo();
            newDbInfo.setColCount(this.generateKeyColumnNames.length);
            newDbInfo.setRowCount(this.generateKeys.length);
            DmdbColumn[] colInfos = new DmdbColumn[this.generateKeyColumnNames.length];
            newDbInfo.setColumnsInfo(colInfos);
            int i2 = 0;
            while (i2 < this.generateKeyColumnNames.length) {
                ParameterDesc paramDesc = this.m_paramsDesc[this.m_paramsDesc.length - 1 - i2];
                colInfos[i2] = new DmdbColumn(this.connection);
                colInfos[i2].getDesc().setDType(paramDesc.getDType());
                colInfos[i2].getDesc().setPrec(paramDesc.getPrec());
                colInfos[i2].getDesc().setScale(paramDesc.getScale());
                colInfos[i2].getDesc().setName(this.generateKeyColumnNames[i2]);
                colInfos[i2].getDesc().setNullable(paramDesc.getNullable());
                colInfos[i2].getDesc().setSchName(this.getTbSchNameSolo());
                colInfos[i2].getDesc().setTabName(this.getTbNameSolo());
                colInfos[i2].getDesc().setTypeName(paramDesc.getTypeName());
                ++i2;
            }
            DmdbResultSetCache_g rsCache = new DmdbResultSetCache_g(this, colInfos, this.generateKeys);
            rsCache.startColumnIndex = this.generateKeys[0].length - this.generateKeyColumnNames.length;
            return new DmdbResultSet_bs(rsCache, newDbInfo, this.m_execfromStandby);
        }
        return super.getGeneratedKeys();
    }

    public void clearGeneratedKeys() {
        this.generateKeys = null;
    }

    public void appendGeneratedKeys(byte[][][] datas) {
        if (datas == null || datas.length == 0) {
            return;
        }
        if (this.generateKeys == null) {
            this.generateKeys = datas;
        } else {
            int rowCount = this.generateKeys.length + datas.length;
            int colCount = this.generateKeys[0].length;
            byte[][][] totalDatas = new byte[rowCount][colCount][];
            System.arraycopy(this.generateKeys, 0, totalDatas, 0, this.generateKeys.length);
            System.arraycopy(datas, 0, totalDatas, this.generateKeys.length, datas.length);
            this.generateKeys = totalDatas;
        }
    }
}

