/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    private DmdbBlob blob = null;
    private DmdbClob clob = null;
    private int typeFlag;
    private String stringBuffer = null;
    byte[] byteBuffer = null;
    char[] charBuffer = null;
    int currentPos = 0;
    static final int blobLen = 32000;
    static final int clobLen = 8000;
    int curPos = 0;
    int byteLen;
    int charLen;
    private boolean closed = false;
    long lob_length = -1L;

    public DmdbReader(Object o2) throws NumberFormatException {
        if (o2 instanceof DmdbBlob) {
            this.blob = (DmdbBlob)o2;
            this.typeFlag = 0;
        } else if (o2 instanceof DmdbClob) {
            this.clob = (DmdbClob)o2;
            this.typeFlag = 1;
        } else if (o2 instanceof String) {
            this.typeFlag = 2;
            this.stringBuffer = (String)o2;
        } else if (o2 instanceof byte[]) {
            this.typeFlag = 3;
            this.byteBuffer = (byte[])o2;
        } else {
            throw new NumberFormatException("cast error.");
        }
    }

    protected DmdbReader(DmdbClob clob, long pos, long length) {
        this.typeFlag = 1;
        this.clob = clob;
        this.currentPos = (int)(pos - 1L);
        this.lob_length = length;
    }

    public int read(char[] dest, int destOff, int readLen) throws IOException {
        if (this.closed) {
            throw new IOException(DmSvcConf.res.getString("error.ClosedStream"));
        }
        if (dest == null) {
            throw new NullPointerException();
        }
        if (destOff < 0 || readLen < 0 || destOff + readLen > dest.length) {
            throw new IndexOutOfBoundsException(DmSvcConf.res.getString("error.IndexOutOfBound"));
        }
        switch (this.typeFlag) {
            case 0: {
                return this.readFromBlob(dest, destOff, readLen);
            }
            case 1: {
                return this.readFromClob(dest, destOff, readLen);
            }
            case 2: {
                return this.readFromString(dest, destOff, readLen);
            }
            case 3: {
                return this.readFromByteArray(dest, destOff, readLen);
            }
        }
        throw new IOException("io read error.");
    }

    public void close() throws IOException {
        this.closed = true;
    }

    private int readFromBlob(char[] dest, int destOff, int readLen) throws IOException {
        int retLen;
        block10: {
            block9: {
                retLen = 0;
                if (this.blob != null) break block9;
                return -1;
            }
            if (this.lob_length < 0L) {
                this.lob_length = this.blob.length();
            }
            if (this.byteBuffer != null && (this.byteLen = this.byteBuffer.length) > this.curPos || this.lob_length > (long)this.currentPos) break block10;
            return -1;
        }
        try {
            long invalidLen = 0L;
            invalidLen = this.byteBuffer == null ? this.lob_length - (long)this.currentPos : this.lob_length - (long)this.currentPos + (long)this.byteLen - (long)this.curPos;
            int destLen = (int)(invalidLen > (long)readLen ? (long)readLen : invalidLen);
            while (retLen < destLen) {
                if (this.byteBuffer == null || (this.byteLen = this.byteBuffer.length) <= this.curPos) {
                    int bufLen = (int)(this.lob_length - (long)this.currentPos > 32000L ? 32000L : this.lob_length - (long)this.currentPos);
                    this.byteBuffer = this.blob.getBytes(this.currentPos + 1, bufLen);
                    if (this.byteBuffer == null || this.byteBuffer.length <= 0) {
                        this.byteBuffer = new byte[0];
                        this.curPos = 0;
                        this.byteLen = bufLen;
                        break;
                    }
                    this.curPos = 0;
                    this.byteLen = bufLen;
                    this.currentPos += bufLen;
                }
                int realLen = destLen - retLen < this.byteLen - this.curPos ? destLen - retLen : this.byteLen - this.curPos;
                int i2 = 0;
                while (i2 < realLen) {
                    dest[destOff + i2] = (char)this.byteBuffer[this.curPos + i2];
                    ++i2;
                }
                destOff += realLen;
                this.curPos += realLen;
                retLen += realLen;
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        return retLen;
    }

    private int readFromClob(char[] dest, int destOff, int readLen) throws IOException {
        int retLen;
        block9: {
            block8: {
                retLen = 0;
                if (this.clob != null) break block8;
                return -1;
            }
            if (this.lob_length < 0L) {
                this.lob_length = this.clob.length();
            }
            if (this.charBuffer != null && (this.charLen = this.charBuffer.length) > this.curPos || this.lob_length > (long)this.currentPos) break block9;
            return -1;
        }
        try {
            long invalidLen = 0L;
            invalidLen = this.charBuffer == null ? this.lob_length - (long)this.currentPos : this.lob_length - (long)this.currentPos + (long)this.charLen - (long)this.curPos;
            int destLen = (int)(invalidLen > (long)readLen ? (long)readLen : invalidLen);
            while (retLen < destLen) {
                if (this.charBuffer == null || (this.charLen = this.charBuffer.length) <= this.curPos) {
                    int bufLen = (int)(this.lob_length - (long)this.currentPos > 8000L ? 8000L : this.lob_length - (long)this.currentPos);
                    String subString = this.clob.getSubString(this.currentPos + 1, bufLen);
                    if (subString == null || subString.length() <= 0) {
                        this.charBuffer = new char[0];
                        this.curPos = 0;
                        this.charLen = 0;
                        break;
                    }
                    this.charBuffer = new char[bufLen];
                    subString.getChars(0, bufLen, this.charBuffer, 0);
                    this.curPos = 0;
                    this.currentPos += bufLen;
                    this.charLen = bufLen;
                }
                int realLen = destLen - retLen < this.charLen - this.curPos ? destLen - retLen : this.charLen - this.curPos;
                System.arraycopy(this.charBuffer, this.curPos, dest, destOff, realLen);
                destOff += realLen;
                this.curPos += realLen;
                retLen += realLen;
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        return retLen;
    }

    private int readFromString(char[] dest, int destOff, int readLen) throws IOException {
        int invalidLen;
        if (this.stringBuffer == null || (this.charLen = this.stringBuffer.length()) <= this.curPos) {
            return -1;
        }
        int n2 = invalidLen = readLen > this.charLen - this.curPos ? this.charLen - this.curPos : readLen;
        if (destOff + invalidLen > dest.length) {
            throw new IndexOutOfBoundsException(DmSvcConf.res.getString("error.IndexOutOfBound"));
        }
        this.stringBuffer.getChars(this.curPos, this.curPos + invalidLen, dest, destOff);
        this.curPos += invalidLen;
        return invalidLen;
    }

    private int readFromByteArray(char[] dest, int destOff, int readLen) throws IOException {
        int invalidLen;
        if (this.byteBuffer == null || (this.byteLen = this.byteBuffer.length) <= this.curPos) {
            return -1;
        }
        int n2 = invalidLen = readLen > this.byteLen - this.curPos ? this.byteLen - this.curPos : readLen;
        if (destOff + invalidLen > dest.length) {
            throw new IndexOutOfBoundsException(DmSvcConf.res.getString("error.IndexOutOfBound"));
        }
        int i2 = 0;
        while (i2 < invalidLen) {
            dest[destOff + i2] = (char)this.byteBuffer[i2 + this.curPos];
            ++i2;
        }
        this.curPos += invalidLen;
        return invalidLen;
    }
}

