/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmdbBdta;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.SQLException;
import java.util.ArrayList;

public class DmdbResultSetCache_v
extends DmdbResultSetCache {
    byte[] rowbuf = null;
    private int rowidCol;
    ArrayList<DmdbBdta> bdtaList;
    private int bdtaIndex = 0;
    public DmdbBdta curBdta;
    private int startOff = 0;
    private int offset;

    public DmdbResultSetCache_v(DmdbStatement_bs stmt, DmdbColumn[] colsInfo, int rowidCol) {
        super(stmt, colsInfo);
        this.rowidCol = rowidCol;
    }

    public void fillBuffer(byte[] buffer, int len, int rows) throws SQLException {
        this.env_stmt_init_curbuf();
        this.rowbuf = buffer;
        this.setRownum(rows);
        this.realLen = len;
        this.startOff = 0;
        if (rows > 0) {
            while (this.offset < this.startOff + this.realLen) {
                DmdbBdta tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdtaList.add(tmp);
                this.offset += tmp.len;
            }
            this.bdtaIndex = 0;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
        }
    }

    public void fillBuffer2(byte[] buffer, int off, int len, int fetched_rows) throws SQLException {
        this.env_stmt_init_curbuf();
        if (this.rowbuf == null) {
            this.rowbuf = new byte[len];
        } else if (this.rowbuf.length < len) {
            this.rowbuf = new byte[len];
        }
        System.arraycopy(buffer, off, this.rowbuf, 0, len);
        this.setRownum(fetched_rows);
        this.realLen = len;
        this.offset = this.startOff = 0;
        if (fetched_rows > 0) {
            while (this.offset < this.startOff + this.realLen) {
                DmdbBdta tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdtaList.add(tmp);
                this.offset += tmp.len;
            }
            this.bdtaIndex = 0;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
        }
    }

    private void env_stmt_init_curbuf() {
        this.setRownum(0);
        this.curpos = 0;
        this.offset = 0;
        this.curBdta = null;
        this.bdtaIndex = 0;
        this.bdtaList = new ArrayList();
    }

    public void addBuffer(byte[] buffer, int len, int rows) throws SQLException {
        byte[] tmp = new byte[this.realLen + this.startOff + len];
        System.arraycopy(this.rowbuf, 0, tmp, 0, this.realLen + this.startOff);
        System.arraycopy(buffer, 0, tmp, this.realLen + this.startOff, len);
        this.rowbuf = tmp;
        this.setRownum(this.getRownum() + rows);
        this.realLen += len;
        if (rows > 0) {
            while (this.offset < this.startOff + this.realLen) {
                DmdbBdta bdta_tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdtaList.add(bdta_tmp);
                this.offset += bdta_tmp.len;
            }
        }
    }

    public boolean next() throws SQLException {
        if (this.curpos >= this.getRownum() - 1) {
            return false;
        }
        if (!this.curBdta.next()) {
            ++this.bdtaIndex;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
            this.curBdta.absolute(0);
        }
        ++this.curpos;
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.curpos <= 0) {
            return false;
        }
        if (!this.curBdta.previous()) {
            --this.bdtaIndex;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
            this.curBdta.absolute(this.curBdta.rownum - 1);
        }
        --this.curpos;
        return true;
    }

    public boolean absolute(int position) throws SQLException {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.getRownum()) {
            position = this.getRownum() - 1;
        }
        if (position == 0) {
            this.bdtaIndex = 0;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
            this.curBdta.absolute(0);
        } else if (position == this.getRownum() - 1) {
            this.bdtaIndex = this.bdtaList.size() - 1;
            this.curBdta = this.bdtaList.get(this.bdtaIndex);
            this.curBdta.absolute(this.curBdta.rownum - 1);
        } else {
            int rows = 0;
            int i2 = 0;
            while (i2 < this.bdtaList.size()) {
                this.bdtaIndex = i2++;
                DmdbBdta tmp = this.bdtaList.get(this.bdtaIndex);
                if (rows + tmp.rownum > position) {
                    this.curBdta = tmp;
                    this.curBdta.absolute(position - rows);
                    break;
                }
                rows += tmp.rownum;
            }
        }
        this.curpos = position;
        return true;
    }

    public byte[] getBytes(short columnNo) throws SQLException {
        return this.curBdta.getBytes(columnNo);
    }

    public boolean getBytesFillBuffer(short columnNo, byte[] returnBuffer) throws SQLException {
        return this.curBdta.getBytes(columnNo, returnBuffer);
    }

    public final Object clone() {
        DmdbResultSetCache_v rsCache = null;
        rsCache = (DmdbResultSetCache_v)super.clone();
        rsCache.setStatement(null);
        rsCache.curpos = 0;
        rsCache.bdtaIndex = 0;
        if (this.bdtaList != null && this.bdtaList.size() > 0) {
            rsCache.bdtaList = (ArrayList)this.bdtaList.clone();
            this.curBdta = rsCache.bdtaList.get(0);
        }
        if (this.rowbuf != null) {
            rsCache.rowbuf = (byte[])this.rowbuf.clone();
        }
        return rsCache;
    }

    long rec_get_rowid() {
        if (this.rowbuf == null) {
            try {
                DBError.throwSQLException(6021);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                return 0L;
            }
        }
        if (this.rowidCol != -1) {
            return this.curBdta.rec_get_rowid(this.rowidCol);
        }
        return -1L;
    }
}

