/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbDataTypeMetaData;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DmdbResultSetMetaData_bs
extends DmdbDataTypeMetaData
implements ResultSetMetaData {
    DmdbStatement_bs stmt = null;
    DmdbColumn[] columnsInfo = null;
    int concurrency;
    private boolean comOra = false;
    private boolean clobAsString = false;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;

    public DmdbResultSetMetaData_bs(DmdbStatement_bs stmt, DmdbColumn[] columnsInfo, int concurrency, boolean comOra, boolean clobAsString) {
        this.stmt = stmt;
        this.columnsInfo = columnsInfo;
        this.concurrency = concurrency;
        this.comOra = comOra;
        this.clobAsString = clobAsString;
    }

    public int getColumnCount() throws SQLException {
        if (this.columnsInfo == null) {
            return 0;
        }
        return this.columnsInfo.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getDesc().getIdentity();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        boolean isCaseSensitive;
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        switch (t2) {
            case -7: 
            case -6: 
            case -4: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: 
            case 2005: {
                isCaseSensitive = false;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                isCaseSensitive = true;
                break;
            }
            default: {
                isCaseSensitive = false;
            }
        }
        return isCaseSensitive;
    }

    public boolean isSearchable(int column) throws SQLException {
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        switch (t2) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 2004: 
            case 2005: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        if (this.getColumnType(column) == 3) {
            return this.getPrecision(column) == 19 && this.getScale(column) == 4;
        }
        return false;
    }

    public int isNullable(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getDesc().getNullable() ? this.columnNullable : this.columnNoNulls;
    }

    public boolean isSigned(int column) throws SQLException {
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        return this.signed(t2);
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getDisplaySize();
    }

    public String getColumnLabel(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getDesc().getName();
    }

    public String getColumnName(int column) throws SQLException {
        String colName = this.getColumnLabel(column);
        if (colName != null && this.stmt != null && this.stmt.getConnection_bs() != null && !this.stmt.getConnection_bs().getCaseSensitive() && this.stmt.getConnection_bs().isColumnNameUpperCase()) {
            return colName.toUpperCase();
        }
        return colName;
    }

    public String getSchemaName(int column) throws SQLException {
        this.checkIndex(column);
        String s2 = this.columnsInfo[column - 1].getDesc().getSchName();
        if (s2 != null && s2.length() > 0) {
            return s2;
        }
        if (this.stmt != null && this.stmt.getConnection_bs() != null) {
            return this.stmt.getConnection_bs().getCurrentUserName();
        }
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getSqlPrec();
    }

    public int getScale(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getSqlScale();
    }

    public String getTableName(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getDesc().getTabName();
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.checkIndex(column);
        int type = this.columnsInfo[column - 1].getSqlType();
        if (this.comOra && DmdbType.isNUMERICtype(type)) {
            return 2;
        }
        if (type == 2005 && this.clobAsString) {
            return 12;
        }
        return type;
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getTypeName();
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.checkIndex(column);
        if (this.comOra) {
            return false;
        }
        return this.concurrency == 1007 && this.columnsInfo[column - 1].getDesc().isReadOnly();
    }

    public boolean isWritable(int column) throws SQLException {
        this.checkIndex(column);
        return this.concurrency == 1008;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkIndex(column);
        return this.concurrency == 1008;
    }

    public String getColumnClassName(int column) throws SQLException {
        this.checkIndex(column);
        int jsqlType = this.getColumnType(column);
        return this.getClassName(jsqlType, this.columnsInfo[column - 1].getDesc().getDType());
    }

    void checkIndex(int i2) throws SQLException {
        if (i2 < 1 || i2 > this.getColumnCount()) {
            DBError.throwSQLException(6032);
        }
    }
}

