/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.dbaccess.DmdbSwitch;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.parser.DmdbExecOpt;
import dm.jdbc.rsCache.DmdbCachedResultSetPool;
import dm.jdbc.util.StringUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbStatement_bs
implements Statement {
    public static final int STATEMENT = 0;
    public static final int PREPARED_STATEMENT = 1;
    public static final int CALLABLE_STATEMENT = 2;
    public static final int STATICPREPARED_STATEMENT = 3;
    protected int handle;
    protected DmdbConnection_bs connection;
    protected DmdbInfo dbInfo;
    DmdbResultSetCache rsCache = null;
    private DmdbResultSet_bs currentRs = null;
    private ArrayList<DmdbResultSet_bs> resultsList = null;
    short resId = 0;
    protected String m_insertTableName = "";
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected int resultSetHoldability;
    boolean process_escapes;
    protected int m_queryTimeout;
    int max_field_size;
    long maxRows;
    int row_prefetch;
    public boolean closed = true;
    int fetch_direction;
    SQLWarning m_warnings;
    ArrayList<String> m_batchItems = null;
    String cursorName;
    public long cursorUpdateRow;
    boolean fromRowSetFlag = false;
    int type = 0;
    int m_putLobData = 1;
    protected String originalSql = null;
    protected long[] m_TbIds = null;
    protected long[] m_TbTss = null;
    private long executeId = -1L;
    private boolean m_ExecOpt = false;
    protected boolean m_autoGenKeys = false;
    private boolean readBaseColName;
    String printMsg = null;
    protected int handleForStandby;
    private boolean m_prepareFromStandby = false;
    protected boolean m_execfromStandby = false;
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    public DmdbStatement_bs(DmdbConnection_bs conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = conn;
        this.initializeState();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    void initializeState() throws SQLException {
        this.m_ExecOpt = this.connection.getConstParaOpt();
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.isEscapeProcess();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getRowPrefetch();
        this.fetch_direction = 1000;
        this.m_warnings = null;
        this.m_batchItems = null;
        this.setResultsList(new ArrayList<DmdbResultSet_bs>(3));
        this.allocHandle();
        this.type = 0;
        this.closed = false;
    }

    public void allocHandle() throws SQLException {
        this.handle = DmdbCSI.allocStmtHandle(this);
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM7CUR" + ttt;
    }

    public void initializeReuseStmt(DmdbConnection_bs conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.closed = false;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public void setExecFromStandby(boolean standby) {
        this.m_execfromStandby = standby;
    }

    public boolean getExecFromStandby() {
        return this.m_execfromStandby;
    }

    public void setExecuteId(long id) {
        this.executeId = id;
    }

    public long getExecuteId() {
        return this.executeId;
    }

    public long getRowId() {
        if (this.dbInfo != null) {
            return this.dbInfo.getRowId();
        }
        return -1L;
    }

    public void setTbsId_Ts(long[] ids, long[] tss) {
        this.m_TbIds = (long[])ids.clone();
        this.m_TbTss = (long[])tss.clone();
    }

    public DmdbInfo getDmdbInfo() {
        if (this.dbInfo == null) {
            this.dbInfo = new DmdbInfo();
        }
        return this.dbInfo;
    }

    public DmdbInfo getDmdbInfoNRS() {
        if (this.dbInfo != null) {
            this.dbInfo.setHasResultSet(false);
            this.dbInfo.setSavepointFlag(false);
            this.dbInfo.setRetIds(null);
            this.dbInfo.setRowCounts(null);
        }
        return this.getDmdbInfo();
    }

    public boolean fromRowSetFlag() {
        return this.fromRowSetFlag;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.executeInner(sql, 2);
        return this.getCurrentRs();
    }

    public synchronized ResultSet executeQuery(String sql, int rwDestType) throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        this.originalSql = sql;
        ++DmdbConnection_bs.execSqlNum;
        if (this.enableRsCache()) {
            this.setCurrentRs(DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this));
        } else {
            this.setCurrentRs(null);
        }
        if (this.getCurrentRs() != null) {
            ++DmdbConnection_bs.rsCachedNum;
            this.dbInfo = this.getCurrentRs().dbInfo;
            return this.getCurrentRs();
        }
        this.dbInfo = this.directExec(this, this.originalSql, true, 1, rwDestType);
        DmdbResultSet_bs rs = this.getResultSet(true);
        return rs;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.executeInner(sql, 3);
        if (!this.connection.isCompatibleOracle() && this.dbInfo.getHasResultSet()) {
            DBError.throwSQLException(6009);
        }
        if (this.dbInfo.getHasResultSet() && this.dbInfo.getRowCount() == Long.MAX_VALUE) {
            return (int)DmdbCSI.getRowCount(this, this.getCurrentRs().m_fromStandby);
        }
        if (this.dbInfo.getRowCount() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.dbInfo.getRowCount();
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.throwSQLException(6035);
            return;
        }
        if (this.connection == null || this.connection.isClosed()) {
            DBError.throwSQLException(6035);
        }
    }

    void resetState(boolean clear_dbInfo) throws SQLException {
        if (clear_dbInfo) {
            this.dbInfo = null;
        }
        this.printMsg = null;
        this.rsCache = null;
        this.m_insertTableName = "";
        this.cursorUpdateRow = 0L;
        this.fromRowSetFlag = false;
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.isEscapeProcess();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getRowPrefetch();
        this.fetch_direction = 1000;
        this.m_warnings = null;
        if (this.dbInfo != null) {
            this.dbInfo.setExplain(null);
        }
        if (this.m_batchItems != null) {
            this.m_batchItems.clear();
            this.m_batchItems = null;
        }
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM7CUR" + ttt;
        this.type = 0;
    }

    private void close_free() throws SQLException {
        if (this.type == 0) {
            if (this.getCurrentRs() != null && !this.getCurrentRs().metaRsFlag) {
                this.getCurrentRs().close();
                this.setCurrentRs(null);
            }
            this.originalSql = null;
            if (this.connection != null && !this.connection.isClosed() && this.connection.getStmtPoolSize() < this.connection.getStmtPoolMaxSize()) {
                this.resetState(true);
                this.closed = true;
                this.connection.remove_statement(this.handle);
                this.connection.addToStmtPool(this);
                this.connection.delStmt(this);
                return;
            }
        }
        this.innerClose();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.close_free();
    }

    public void closeSimple() {
        this.closed = true;
    }

    public synchronized void innerClose() throws SQLException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                DmdbCSI.freeHandle(this);
                this.connection.remove_statement(this.handle);
                this.connection.delStmt(this);
            }
        }
        finally {
            this.connection = null;
            this.m_warnings = null;
            this.dbInfo = null;
            if (this.getCurrentRs() != null) {
                this.getCurrentRs().close();
                this.setCurrentRs(null);
            }
            this.rsCache = null;
            if (this.m_batchItems != null) {
                this.m_batchItems.clear();
                this.m_batchItems = null;
            }
            if (this.getResultsList() != null) {
                this.getResultsList().clear();
                this.setResultsList(null);
            }
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.max_field_size = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.maxRows;
    }

    public long getMaxRowsInner() throws SQLException {
        if (this.connection.isEnRsCache()) {
            return 0L;
        }
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.process_escapes = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            DBError.throwSQLException(6036);
        }
        this.m_queryTimeout = seconds;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
        if (this.dbInfo != null) {
            this.dbInfo.setExplain(null);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        DmdbCSI.setCursorName(this, name);
        this.cursorName = name;
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        this.executeInner(sql, 1);
        boolean hasRs = this.dbInfo.getHasResultSet();
        return hasRs;
    }

    public synchronized boolean executeForRw(String sql, int rwDestType) throws SQLException {
        this.executeInnerForRw(sql, 1, rwDestType);
        boolean hasRs = this.dbInfo.getHasResultSet();
        return hasRs;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (!this.dbInfo.getHasResultSet()) {
            return null;
        }
        return this.getCurrentRs();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.dbInfo.getHasResultSet() ? -1 : (int)this.dbInfo.getRowCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(this.CLOSE_CURRENT_RESULT);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (direction == 1000 || direction == 1001) {
            this.fetch_direction = direction;
        } else if (direction == 1002) {
            this.fetch_direction = 1000;
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 37);
        } else {
            DBError.throwSQLException(6036);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetch_direction;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0L && this.maxRows != -1L && (long)rows > this.maxRows) {
            DBError.throwSQLException(6036);
        }
        this.row_prefetch = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.row_prefetch;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.m_batchItems == null) {
            this.m_batchItems = new ArrayList(10);
        }
        this.checkNullOrEmpty(sql);
        this.m_batchItems.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.m_batchItems != null) {
            this.m_batchItems.clear();
            this.m_batchItems = null;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.resId = 0;
        this.clearWarnings();
        if (this.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        try {
            int[] updateCounts = new int[]{};
            if (this.m_batchItems != null) {
                int nbrCommands = this.m_batchItems.size();
                updateCounts = new int[nbrCommands];
                int i2 = 0;
                while (i2 < nbrCommands) {
                    updateCounts[i2] = this.SUCCESS_NO_INFO;
                    ++i2;
                }
                ArrayList<String> sqlExList = new ArrayList<String>();
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    try {
                        updateCounts[commandIndex] = this.executeUpdate(this.m_batchItems.get(commandIndex));
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = this.EXECUTE_FAILED;
                        if (this.connection.isContinueBatchOnError()) {
                            sqlExList.add("sql[" + commandIndex + "]:" + ex.getErrorCode() + ", " + ex.getMessage());
                            SQLWarning warning = new SQLWarning("sql[" + commandIndex + "]:" + ex.getErrorCode() + ", " + ex.getMessage());
                            this.connection.addWarnings(warning);
                        }
                        int[] newUpdateCounts = new int[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                    }
                    ++commandIndex;
                }
                if (sqlExList.size() > 0) {
                    StringBuilder errMsg = new StringBuilder();
                    for (String temp : sqlExList) {
                        errMsg.append(StringUtil.LINE_SEPARATOR).append(temp);
                    }
                    throw new BatchUpdateException(String.valueOf(DmSvcConf.res.getString("warning.bp_with_err")) + errMsg.toString(), updateCounts);
                }
            }
            if (this.connection.isCompatibleOracle()) {
                int i3 = 0;
                while (i3 < updateCounts.length) {
                    updateCounts[i3] = -2;
                    ++i3;
                }
            }
            nArray = updateCounts;
        }
        catch (Throwable throwable) {
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    public DmdbConnection_bs getConnection_bs() {
        return this.connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        this.dbInfo.setRowCount(-1L);
        if (this.dbInfo.getHasResultSet()) {
            this.checkCloseRsCons(current);
            this.getMoreRsInner();
            this.handleOldRsByCloseRs(current);
        }
        return this.dbInfo.getHasResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        DmdbInfo newDbInfo = new DmdbInfo();
        newDbInfo.setColCount(1);
        DmdbColumn[] colInfos = new DmdbColumn[]{new DmdbColumn(this.connection)};
        colInfos[0].getDesc().setDType(8);
        colInfos[0].getDesc().setPrec(8);
        colInfos[0].getDesc().setScale(0);
        colInfos[0].getDesc().setName("AUTO_GEN_KEY");
        colInfos[0].getDesc().setNullable(false);
        colInfos[0].getDesc().setSchName(this.getTbSchNameSolo());
        colInfos[0].getDesc().setTabName(this.getTbNameSolo());
        colInfos[0].getDesc().setTypeName("BIGINT");
        newDbInfo.setColumnsInfo(colInfos);
        DmdbResultSetCache_h rsCache = null;
        rsCache = new DmdbResultSetCache_h(this, colInfos);
        int rowCnt = 0;
        long[] m_retIds = this.dbInfo.getRetIds();
        if (m_retIds != null && m_retIds.length > 0) {
            rowCnt = m_retIds.length;
        }
        newDbInfo.setRowCount(rowCnt);
        byte[] rowbuf = new byte[22 * rowCnt];
        int offset = 0;
        int i2 = 0;
        while (i2 < rowCnt) {
            Convertion.setShort(rowbuf, offset, (short)22);
            Convertion.setLong(rowbuf, offset += 2, m_retIds[i2]);
            Convertion.setShort(rowbuf, offset += 8, (short)12);
            Convertion.setShort(rowbuf, offset += 2, (short)8);
            Convertion.setLong(rowbuf, offset += 2, m_retIds[i2]);
            offset += 8;
            ++i2;
        }
        ((DmdbResultSetCache)rsCache).fillBuffer(rowbuf, rowbuf.length, rowCnt);
        DmdbResultSet_bs rs = null;
        rs = new DmdbResultSet_bs(rsCache, newDbInfo, this.m_execfromStandby);
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setAutoGetKeysInner(autoGeneratedKeys);
        int updateCount = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.setAutoGetKeys(true);
        } else {
            this.setAutoGetKeys(false);
        }
        int ret = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return ret;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            this.setAutoGetKeys(true);
        } else {
            this.setAutoGetKeys(false);
        }
        int ret = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return ret;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setAutoGetKeysInner(autoGeneratedKeys);
        boolean hasRs = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return hasRs;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.setAutoGetKeys(true);
        } else {
            this.setAutoGetKeys(false);
        }
        boolean b2 = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return b2;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            this.setAutoGetKeys(true);
        } else {
            this.setAutoGetKeys(false);
        }
        boolean b2 = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return b2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    void checkNullOrEmpty(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
    }

    public int getHandle() {
        return this.handle;
    }

    protected DmdbInfo directExec(DmdbStatement_bs stmt, String s2, boolean direct, int checkFlag) throws SQLException {
        DmdbInfo info = DmdbCSI.prepareSQL(stmt, s2, direct, checkFlag, -1);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbInfo directExec(DmdbStatement_bs stmt, String s2, boolean direct, int checkFlag, int rwDestType) throws SQLException {
        DmdbInfo info = DmdbCSI.prepareSQL(stmt, s2, direct, checkFlag, rwDestType);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbInfo directExec_Opt(DmdbExecOpt execOpt) throws SQLException {
        DmdbInfo info = DmdbCSI.directExec_Opt(this, execOpt);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbResultSet_bs getResultSet(boolean fetchAll) throws SQLException {
        if (this.rsCache == null) {
            this.rsCache = this.dbInfo.isBdtaRs() ? new DmdbResultSetCache_v(this, this.dbInfo.getColumnsInfo(), -1) : new DmdbResultSetCache_h(this, this.dbInfo.getColumnsInfo());
        }
        DmdbResultSet_bs rs = new DmdbResultSet_bs(this.rsCache, this.dbInfo, fetchAll, this.m_execfromStandby);
        if (this.enableRsCache_dbInfo()) {
            DmdbCachedResultSetPool.addResultSet(rs, this.connection, this.originalSql, this.m_TbIds, this.m_TbTss, this.dbInfo);
        }
        return rs;
    }

    protected DmdbResultSet_bs getResultSetPrivate(int closeRs) throws SQLException {
        this.closeCurrentResultSet(closeRs);
        return this.createNewResultSetByDbInfo();
    }

    private void handleOldRsByCloseRs(int closeRs) throws SQLException {
        if (closeRs == 2) {
            if (this.getCurrentRs() != null) {
                this.getResultsList().add(this.getCurrentRs());
            }
            this.createNewResultSetByDbInfo();
        } else if (closeRs == 1) {
            this.getResultSetPrivate(1);
        } else {
            this.getResultSetPrivate(1);
            int i2 = 0;
            while (i2 < this.getResultsList().size()) {
                this.getResultsList().get(i2).close();
                ++i2;
            }
            this.getResultsList().clear();
        }
    }

    private void checkCloseRsCons(int closeRs) throws SQLException {
        switch (closeRs) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                DBError.throwSQLException(DmSvcConf.res.getString("error.unsupportedParam"));
            }
        }
    }

    private void closeCurrentResultSet(int closeRs) throws SQLException {
        if (closeRs == 1 && this.getCurrentRs() != null) {
            if (this instanceof DmdbCallableStatement_bs) {
                if (((DmdbCallableStatement_bs)this).resultsCount == 0) {
                    this.getCurrentRs().close();
                }
            } else {
                this.getCurrentRs().close();
            }
        }
    }

    private void getMoreRsInner() throws SQLException {
        this.dbInfo = DmdbCSI.getMoreResult(this, (short)0);
        if (this.dbInfo.getHasResultSet()) {
            this.resId = (short)(this.resId + 1);
        }
    }

    private DmdbResultSet_bs createNewResultSetByDbInfo() throws SQLException {
        if (!this.dbInfo.getHasResultSet()) {
            this.setCurrentRs(null);
        } else {
            if (this.rsCache == null) {
                this.rsCache = this.dbInfo.isBdtaRs() ? new DmdbResultSetCache_v(this, this.dbInfo.getColumnsInfo(), -1) : new DmdbResultSetCache_h(this, this.dbInfo.getColumnsInfo());
            }
            DmdbResultSet_bs rs = new DmdbResultSet_bs(this.rsCache, this.dbInfo, this.m_execfromStandby);
            this.setCurrentRs(rs);
            this.getCurrentRs().setRsId(this.resId);
            this.getCurrentRs().startRow = 0L;
            if (this.enableRsCache_dbInfo()) {
                this.getCurrentRs().fromRsCachePool = true;
                this.getCurrentRs().maxRows = this.maxRows;
                DmdbCachedResultSetPool.addResultSet(this.getCurrentRs(), this.connection, this.originalSql, this.m_TbIds, this.m_TbTss, this.dbInfo);
            }
        }
        return this.getCurrentRs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getTableNameBySql(String sql) {
        if (!this.m_autoGenKeys) {
            return "";
        }
        int headlen = 0;
        String[] wordList = sql.split(" ");
        int index = 0;
        int i2 = 0;
        while (i2 < wordList.length) {
            String word = wordList[i2];
            if (!StringUtil.isEmpty(word)) {
                if (index == 0) {
                    if (!word.equalsIgnoreCase("insert")) return null;
                    ++index;
                } else if (index == 1) {
                    if (!word.equalsIgnoreCase("into")) return null;
                    ++index;
                } else if (index > 1) break;
            }
            ++i2;
        }
        headlen = sql.toLowerCase().indexOf("into") + "into".length();
        int valuesIndex = sql.toLowerCase().indexOf("values");
        if (-1 == valuesIndex) {
            return null;
        }
        String sqltb = sql.substring(headlen, valuesIndex).trim();
        int leftB = sqltb.indexOf("(");
        if (-1 != leftB) return sqltb.substring(0, leftB).trim();
        return sqltb;
    }

    String getTbSchNameSolo() {
        if (this.m_insertTableName == null || this.m_insertTableName.length() == 0) {
            return null;
        }
        int colonIndex = this.m_insertTableName.indexOf(".");
        if (colonIndex == -1) {
            return this.connection.getSchema();
        }
        String schName = this.m_insertTableName.substring(0, colonIndex);
        if (schName.startsWith("\"") && schName.endsWith("\"")) {
            schName = schName.substring(1, schName.length() - 1);
        }
        if (!this.connection.getCaseSensitive()) {
            schName = schName.toUpperCase();
        }
        return schName;
    }

    String getTbNameSolo() {
        if (this.m_insertTableName == null || this.m_insertTableName.length() == 0) {
            return null;
        }
        String tabName = null;
        int colonIndex = this.m_insertTableName.indexOf(".");
        tabName = colonIndex == -1 ? this.m_insertTableName : this.m_insertTableName.substring(colonIndex + 1);
        if (tabName.startsWith("\"") && tabName.endsWith("\"")) {
            tabName = tabName.substring(1, tabName.length() - 1);
        }
        if (!this.connection.getCaseSensitive()) {
            tabName = tabName.toUpperCase();
        }
        return tabName;
    }

    public final boolean getIsPutLobData_In() {
        return this.m_putLobData == 1;
    }

    public final void setPutLobData(int flag) {
        this.m_putLobData = flag;
    }

    public boolean autoGeneratedKeys() {
        return this.m_autoGenKeys;
    }

    protected void setAutoGenInfoAftExec() {
        this.m_autoGenKeys = false;
    }

    protected void setAutoGetKeysInner(int autoGeneratedKeys) {
        this.m_autoGenKeys = autoGeneratedKeys == 1;
    }

    protected void setAutoGetKeys(boolean auto) {
        this.m_autoGenKeys = auto;
    }

    protected void executeInner(String sql, int execType) throws SQLException {
        this.resId = 0;
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        DmdbSwitch.doSwitchForLoadBalance(this.connection);
        String orgSql = sql;
        DmdbExecOpt execOpt = null;
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        try {
            if (this.m_ExecOpt && (execOpt = this.connection.nativeSQL_ExecOpt(sql)) != null) {
                sql = execOpt.getSqlStr();
            }
        }
        catch (Exception exception) {}
        this.originalSql = sql;
        ++DmdbConnection_bs.execSqlNum;
        if (this.enableRsCache()) {
            this.setCurrentRs(DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this));
        } else {
            this.setCurrentRs(null);
        }
        if (this.getCurrentRs() != null) {
            ++DmdbConnection_bs.rsCachedNum;
            this.dbInfo = this.getCurrentRs().dbInfo;
            return;
        }
        int checkFlag = 0;
        switch (execType) {
            case 2: {
                checkFlag = 1;
                break;
            }
            case 3: {
                checkFlag = 2;
            }
        }
        if (this.m_ExecOpt && execOpt != null) {
            try {
                this.dbInfo = this.directExec_Opt(execOpt);
            }
            catch (SQLException ex) {
                if (6001 != ex.getErrorCode()) {
                    this.dbInfo = this.directExec(this, orgSql, true, checkFlag);
                }
                throw ex;
            }
        } else {
            this.dbInfo = this.directExec(this, this.originalSql, true, checkFlag);
        }
        if (this.dbInfo.getHasResultSet()) {
            this.resId = (short)(this.resId + 1);
        }
        this.getResultSetPrivate(1);
        this.m_insertTableName = this.getTableNameBySql(this.originalSql);
    }

    protected void executeInnerForRw(String sql, int execType, int rwDestType) throws SQLException {
        this.resId = 0;
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        this.originalSql = sql;
        ++DmdbConnection_bs.execSqlNum;
        this.currentRs = this.enableRsCache() ? DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this) : null;
        if (this.currentRs != null) {
            ++DmdbConnection_bs.rsCachedNum;
            this.dbInfo = this.currentRs.dbInfo;
            return;
        }
        int checkFlag = 0;
        switch (execType) {
            case 2: {
                checkFlag = 1;
                break;
            }
            case 3: {
                checkFlag = 2;
            }
        }
        this.dbInfo = this.directExec(this, this.originalSql, true, checkFlag, rwDestType);
        if (this.dbInfo.getHasResultSet()) {
            this.resId = (short)(this.resId + 1);
        }
        this.getResultSetPrivate(1);
        this.m_insertTableName = this.getTableNameBySql(sql);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.connection.getStmtPoolMaxSize() > 0;
    }

    public synchronized void preCompile(String sql) throws SQLException {
        this.checkNullOrEmpty(sql);
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        this.originalSql = sql;
        this.dbInfo = this.directExec(this, sql, false, 0);
    }

    public synchronized void executeDirect() throws SQLException {
        this.dbInfo = DmdbCSI.executePrepared(this, 0);
    }

    protected boolean enableRsCache_dbInfo() {
        return this.connection.isEnRsCache() && this.dbInfo.getRsCacheOffset() != 0;
    }

    protected boolean enableRsCache() {
        return this.connection.isEnRsCache();
    }

    public String getExplain() {
        return this.dbInfo.getExplain();
    }

    public void setReadBaseColName(boolean readBaseColName) {
        this.readBaseColName = readBaseColName;
    }

    public boolean isReadBaseColName() {
        return this.readBaseColName;
    }

    public DmdbResultSetCache getRsCache() {
        return this.rsCache;
    }

    public void setRsCache(DmdbResultSetCache cache) {
        this.rsCache = cache;
    }

    public int getHandleForStandby() {
        return this.handleForStandby;
    }

    public void setHandleForStandby(int handleForStandby) {
        this.handleForStandby = handleForStandby;
    }

    public void setPrepareFromStandby(boolean m_prepareOnStandby) {
        this.m_prepareFromStandby = m_prepareOnStandby;
    }

    public boolean getPrepareFromStandby() {
        return this.m_prepareFromStandby;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public List<String> getBatchSqlList() {
        if (this.m_batchItems != null && this.m_batchItems.size() != 0) {
            return this.m_batchItems;
        }
        return Arrays.asList(this.originalSql);
    }

    public void setResultsList(ArrayList<DmdbResultSet_bs> resultsList) {
        this.resultsList = resultsList;
    }

    public ArrayList<DmdbResultSet_bs> getResultsList() {
        return this.resultsList;
    }

    public void setCurrentRs(DmdbResultSet_bs currentRs) {
        this.currentRs = currentRs;
    }

    public DmdbResultSet_bs getCurrentRs() {
        return this.currentRs;
    }

    public String getPrintMsg() throws SQLException {
        return this.printMsg;
    }

    public void setPrintMsg(String msg) {
        this.printMsg = this.printMsg == null ? msg : String.valueOf(this.printMsg) + "\t" + msg;
    }
}

