/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.LogRecord;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class LogFilter
extends BaseFilter {
    private static final ILogger LOG = LogFactory.getLog(LogFilter.class);

    private LogFilter() {
    }

    public static LogFilter getInstance() {
        return LogFilterThreadHolder.instance;
    }

    @Override
    public void CallableStatement_close(FilterChain chain, DmdbCallableStatement callableStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "close", new Object[0]);
        try {
            try {
                chain.CallableStatement_close(callableStatement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getArray", parameterName);
        try {
            Array ret = chain.CallableStatement_getArray(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getArray", parameterIndex);
        try {
            Array ret = chain.CallableStatement_getArray(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterName);
        try {
            BigDecimal ret = chain.CallableStatement_getBigDecimal(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterIndex);
        try {
            BigDecimal ret = chain.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterIndex, scale);
        try {
            BigDecimal ret = chain.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBlob", parameterName);
        try {
            Blob ret = chain.CallableStatement_getBlob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBlob", parameterIndex);
        try {
            Blob ret = chain.CallableStatement_getBlob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBoolean", parameterName);
        try {
            boolean ret = chain.CallableStatement_getBoolean(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBoolean", parameterIndex);
        try {
            boolean ret = chain.CallableStatement_getBoolean(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getByte", parameterName);
        try {
            byte ret = chain.CallableStatement_getByte(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getByte", parameterIndex);
        try {
            byte ret = chain.CallableStatement_getByte(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBytes", parameterName);
        try {
            byte[] ret = chain.CallableStatement_getBytes(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBytes", parameterIndex);
        try {
            byte[] ret = chain.CallableStatement_getBytes(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCharacterStream", parameterName);
        try {
            Reader ret = chain.CallableStatement_getCharacterStream(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCharacterStream", parameterIndex);
        try {
            Reader ret = chain.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getClob", parameterName);
        try {
            Clob ret = chain.CallableStatement_getClob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getClob", parameterIndex);
        try {
            Clob ret = chain.CallableStatement_getClob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterName);
        try {
            Date ret = chain.CallableStatement_getDate(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterName, cal);
        try {
            Date ret = chain.CallableStatement_getDate(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterIndex);
        try {
            Date ret = chain.CallableStatement_getDate(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterIndex, cal);
        try {
            Date ret = chain.CallableStatement_getDate(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDouble", parameterName);
        try {
            double ret = chain.CallableStatement_getDouble(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDouble", parameterIndex);
        try {
            double ret = chain.CallableStatement_getDouble(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getFloat", parameterName);
        try {
            float ret = chain.CallableStatement_getFloat(callableStatement, parameterName);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getFloat", parameterIndex);
        try {
            float ret = chain.CallableStatement_getFloat(callableStatement, parameterIndex);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getInt", parameterName);
        try {
            int ret = chain.CallableStatement_getInt(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getInt", parameterIndex);
        try {
            int ret = chain.CallableStatement_getInt(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getLong", parameterName);
        try {
            long ret = chain.CallableStatement_getLong(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getLong", parameterIndex);
        try {
            long ret = chain.CallableStatement_getLong(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNCharacterStream", parameterName);
        try {
            Reader ret = chain.CallableStatement_getNCharacterStream(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNCharacterStream", parameterIndex);
        try {
            Reader ret = chain.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNClob", parameterName);
        try {
            NClob ret = chain.CallableStatement_getNClob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNClob", parameterIndex);
        try {
            NClob ret = chain.CallableStatement_getNClob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNString", parameterName);
        try {
            String ret = chain.CallableStatement_getNString(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNString", parameterIndex);
        try {
            String ret = chain.CallableStatement_getNString(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName);
        try {
            Object ret = chain.CallableStatement_getObject(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName, type);
        try {
            T ret = chain.CallableStatement_getObject(callableStatement, parameterName, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName, map);
        try {
            Object ret = chain.CallableStatement_getObject(callableStatement, parameterName, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex);
        try {
            Object ret = chain.CallableStatement_getObject(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex, type);
        try {
            T ret = chain.CallableStatement_getObject(callableStatement, parameterIndex, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex, map);
        try {
            Object ret = chain.CallableStatement_getObject(callableStatement, parameterIndex, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRef", parameterName);
        try {
            Ref ret = chain.CallableStatement_getRef(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRef", parameterIndex);
        try {
            Ref ret = chain.CallableStatement_getRef(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRowId", parameterName);
        try {
            RowId ret = chain.CallableStatement_getRowId(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRowId", parameterIndex);
        try {
            RowId ret = chain.CallableStatement_getRowId(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getSQLXML", parameterName);
        try {
            SQLXML ret = chain.CallableStatement_getSQLXML(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getSQLXML", parameterIndex);
        try {
            SQLXML ret = chain.CallableStatement_getSQLXML(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getShort", parameterName);
        try {
            short ret = chain.CallableStatement_getShort(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getShort", parameterIndex);
        try {
            short ret = chain.CallableStatement_getShort(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getString", parameterName);
        try {
            String ret = chain.CallableStatement_getString(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getString", parameterIndex);
        try {
            String ret = chain.CallableStatement_getString(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterName);
        try {
            Time ret = chain.CallableStatement_getTime(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterName, cal);
        try {
            Time ret = chain.CallableStatement_getTime(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterIndex);
        try {
            Time ret = chain.CallableStatement_getTime(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterIndex, cal);
        try {
            Time ret = chain.CallableStatement_getTime(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterName);
        try {
            Timestamp ret = chain.CallableStatement_getTimestamp(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterName, cal);
        try {
            Timestamp ret = chain.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterIndex);
        try {
            Timestamp ret = chain.CallableStatement_getTimestamp(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterIndex, cal);
        try {
            Timestamp ret = chain.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getURL", parameterName);
        try {
            URL ret = chain.CallableStatement_getURL(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getURL", parameterIndex);
        try {
            URL ret = chain.CallableStatement_getURL(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, typeName);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, scale);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, typeName);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, scale);
        try {
            try {
                chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2, length);
        try {
            try {
                chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2, length);
        try {
            try {
                chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBigDecimal", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2, length);
        try {
            try {
                chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2, length);
        try {
            try {
                chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setBlob(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, inputStream);
        try {
            try {
                chain.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, inputStream, length);
        try {
            try {
                chain.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBoolean", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setBoolean(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setByte(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setByte", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setByte(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBytes(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBytes", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setBytes(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader);
        try {
            try {
                chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader, length);
        try {
            try {
                chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader, length);
        try {
            try {
                chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setClob(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, reader);
        try {
            try {
                chain.CallableStatement_setClob(callableStatement, parameterName, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, reader, length);
        try {
            try {
                chain.CallableStatement_setClob(callableStatement, parameterName, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDate", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setDate(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDate", parameterName, x2, cal);
        try {
            try {
                chain.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDouble(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDouble", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setDouble(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setFloat(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setFloat", parameterName, Float.valueOf(x2));
        try {
            try {
                chain.CallableStatement_setFloat(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setInt(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setInt", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setInt(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setLong(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setLong", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setLong(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNCharacterStream", parameterName, value);
        try {
            try {
                chain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNCharacterStream", parameterName, value, length);
        try {
            try {
                chain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, value);
        try {
            try {
                chain.CallableStatement_setNClob(callableStatement, parameterName, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, reader);
        try {
            try {
                chain.CallableStatement_setNClob(callableStatement, parameterName, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, reader, length);
        try {
            try {
                chain.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNString", parameterName, value);
        try {
            try {
                chain.CallableStatement_setNString(callableStatement, parameterName, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNull", parameterName, sqlType);
        try {
            try {
                chain.CallableStatement_setNull(callableStatement, parameterName, sqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNull", parameterName, sqlType, typeName);
        try {
            try {
                chain.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setObject(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType);
        try {
            try {
                chain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType, scale);
        try {
            try {
                chain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setRowId(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setRowId", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setRowId(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setSQLXML", parameterName, xmlObject);
        try {
            try {
                chain.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setShort(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setShort", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setShort(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setString", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setString(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTime", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setTime(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTime", parameterName, x2, cal);
        try {
            try {
                chain.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTimestamp", parameterName, x2);
        try {
            try {
                chain.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTimestamp", parameterName, x2, cal);
        try {
            try {
                chain.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setURL(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setURL", parameterName, val);
        try {
            try {
                chain.CallableStatement_setURL(callableStatement, parameterName, val);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain chain, DmdbCallableStatement callableStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "wasNull", new Object[0]);
        try {
            boolean ret = chain.CallableStatement_wasNull(callableStatement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_abort(FilterChain chain, DmdbConnection connection, Executor executor) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "abort", executor);
        try {
            try {
                chain.Connection_abort(connection, executor);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_clearWarnings(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "clearWarnings", new Object[0]);
        try {
            try {
                chain.Connection_clearWarnings(connection);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_close(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "close", new Object[0]);
        try {
            try {
                chain.Connection_close(connection);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection Connection_connect(FilterChain chain, DmDriver dmDriver, String url, Properties info) throws SQLException {
        LogRecord logRecord = new LogRecord(dmDriver, "connect", url, info);
        try {
            Connection conn = chain.Connection_connect(dmDriver, url, info);
            logRecord.setReturnValue(conn);
            Connection connection = conn;
            return connection;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_commit(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "commit", new Object[0]);
        try {
            try {
                chain.Connection_commit(connection);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array Connection_createArrayOf(FilterChain chain, DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createArrayOf", typeName, elements);
        try {
            Array ret = chain.Connection_createArrayOf(connection, typeName, elements);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob Connection_createBlob(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createBlob", new Object[0]);
        try {
            Blob ret = chain.Connection_createBlob(connection);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob Connection_createClob(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createClob", new Object[0]);
        try {
            Clob ret = chain.Connection_createClob(connection);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob Connection_createNClob(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createNClob", new Object[0]);
        try {
            NClob ret = chain.Connection_createNClob(connection);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createSQLXML", new Object[0]);
        try {
            SQLXML ret = chain.Connection_createSQLXML(connection);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", new Object[0]);
        try {
            Statement ret = chain.Connection_createStatement(connection);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", resultSetType, resultSetConcurrency);
        try {
            Statement ret = chain.Connection_createStatement(connection, resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
        try {
            Statement ret = chain.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Struct Connection_createStruct(FilterChain chain, DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStruct", typeName, attributes);
        try {
            Struct ret = chain.Connection_createStruct(connection, typeName, attributes);
            logRecord.setReturnValue(ret);
            Struct struct = ret;
            return struct;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getAutoCommit", new Object[0]);
        try {
            boolean ret = chain.Connection_getAutoCommit(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getCatalog(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getCatalog", new Object[0]);
        try {
            String ret = chain.Connection_getCatalog(connection);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getClientInfo", new Object[0]);
        try {
            Properties ret = chain.Connection_getClientInfo(connection);
            logRecord.setReturnValue(ret);
            Properties properties = ret;
            return properties;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getClientInfo(FilterChain chain, DmdbConnection connection, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getClientInfo", name);
        try {
            String ret = chain.Connection_getClientInfo(connection, name);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getHoldability(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getHoldability", new Object[0]);
        try {
            int ret = chain.Connection_getHoldability(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getMetaData", new Object[0]);
        try {
            DatabaseMetaData ret = chain.Connection_getMetaData(connection);
            logRecord.setReturnValue(ret);
            DatabaseMetaData databaseMetaData = ret;
            return databaseMetaData;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getNetworkTimeout", new Object[0]);
        try {
            int ret = chain.Connection_getNetworkTimeout(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getSchema(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getSchema", new Object[0]);
        try {
            String ret = chain.Connection_getSchema(connection);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getTransactionIsolation", new Object[0]);
        try {
            int ret = chain.Connection_getTransactionIsolation(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getTypeMap", new Object[0]);
        try {
            Map<String, Class<?>> ret = chain.Connection_getTypeMap(connection);
            logRecord.setReturnValue(ret);
            Map<String, Class<?>> map = ret;
            return map;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = chain.Connection_getWarnings(connection);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isClosed(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isClosed", new Object[0]);
        try {
            boolean ret = chain.Connection_isClosed(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isReadOnly", new Object[0]);
        try {
            boolean ret = chain.Connection_isReadOnly(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isValid(FilterChain chain, DmdbConnection connection, int timeout) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isValid", timeout);
        try {
            boolean ret = chain.Connection_isValid(connection, timeout);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_nativeSQL(FilterChain chain, DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "nativeSQL", sql);
        try {
            String ret = chain.Connection_nativeSQL(connection, sql);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain chain, DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql);
        try {
            CallableStatement ret = chain.Connection_prepareCall(connection, sql);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql, resultSetType, resultSetConcurrency);
        try {
            CallableStatement ret = chain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        try {
            CallableStatement ret = chain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, columnNames);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql, columnNames);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, autoGeneratedKeys);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, columnIndexes);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, resultSetType, resultSetConcurrency);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        try {
            PreparedStatement ret = chain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain chain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "releaseSavepoint", savepoint);
        try {
            try {
                chain.Connection_releaseSavepoint(connection, savepoint);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_rollback(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "rollback", new Object[0]);
        try {
            try {
                chain.Connection_rollback(connection);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_rollback(FilterChain chain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "rollback", savepoint);
        try {
            try {
                chain.Connection_rollback(connection, savepoint);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setAutoCommit(FilterChain chain, DmdbConnection connection, boolean autoCommit) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setAutoCommit", autoCommit);
        try {
            try {
                chain.Connection_setAutoCommit(connection, autoCommit);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setCatalog(FilterChain chain, DmdbConnection connection, String catalog) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setCatalog", catalog);
        try {
            try {
                chain.Connection_setCatalog(connection, catalog);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        LogRecord logRecord = new LogRecord(connection, "setClientInfo", properties);
        try {
            try {
                chain.Connection_setClientInfo(connection, properties);
            }
            catch (SQLClientInfoException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        LogRecord logRecord = new LogRecord(connection, "setClientInfo", name, value);
        try {
            try {
                chain.Connection_setClientInfo(connection, name, value);
            }
            catch (SQLClientInfoException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setHoldability(FilterChain chain, DmdbConnection connection, int holdability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setHoldability", holdability);
        try {
            try {
                chain.Connection_setHoldability(connection, holdability);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain chain, DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setNetworkTimeout", executor, milliseconds);
        try {
            try {
                chain.Connection_setNetworkTimeout(connection, executor, milliseconds);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setReadOnly(FilterChain chain, DmdbConnection connection, boolean readOnly) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setReadOnly", readOnly);
        try {
            try {
                chain.Connection_setReadOnly(connection, readOnly);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSavepoint", new Object[0]);
        try {
            Savepoint ret = chain.Connection_setSavepoint(connection);
            logRecord.setReturnValue(ret);
            Savepoint savepoint = ret;
            return savepoint;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSavepoint", name);
        try {
            Savepoint ret = chain.Connection_setSavepoint(connection, name);
            logRecord.setReturnValue(ret);
            Savepoint savepoint = ret;
            return savepoint;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setSchema(FilterChain chain, DmdbConnection connection, String schema) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSchema", schema);
        try {
            try {
                chain.Connection_setSchema(connection, schema);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain chain, DmdbConnection connection, int level) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setTransactionIsolation", level);
        try {
            try {
                chain.Connection_setTransactionIsolation(connection, level);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setTypeMap(FilterChain chain, DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setTypeMap", map);
        try {
            try {
                chain.Connection_setTypeMap(connection, map);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "allProceduresAreCallable", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "allTablesAreSelectable", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "autoCommitFailureClosesAllResultSets", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "dataDefinitionCausesTransactionCommit", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "dataDefinitionIgnoredInTransactions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "deletesAreDetected", type);
        try {
            boolean ret = chain.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "doesMaxRowSizeIncludeBlobs", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "generatedKeyAlwaysReturned", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getBestRowIdentifier", catalog, schema, table, scope, nullable);
        try {
            ResultSet ret = chain.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogSeparator", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogTerm", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getCatalogTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogs", new Object[0]);
        try {
            ResultSet ret = chain.DatabaseMetaData_getCatalogs(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getClientInfoProperties", new Object[0]);
        try {
            ResultSet ret = chain.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getColumnPrivileges", catalog, schema, table, columnNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getConnection", new Object[0]);
        try {
            Connection ret = chain.DatabaseMetaData_getConnection(databaseMetaData);
            logRecord.setReturnValue(ret);
            Connection connection = ret;
            return connection;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        try {
            ResultSet ret = chain.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseMajorVersion", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseMinorVersion", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseProductName", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseProductVersion", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDefaultTransactionIsolation", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverMajorVersion", new Object[0]);
        int ret = chain.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
        logRecord.setReturnValue(ret);
        return ret;
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverMinorVersion", new Object[0]);
        int ret = chain.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
        logRecord.setReturnValue(ret);
        return ret;
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverName", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getDriverName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverVersion", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getDriverVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getExportedKeys", catalog, schema, table);
        try {
            ResultSet ret = chain.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getExtraNameCharacters", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getFunctions", catalog, schemaPattern, functionNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getIdentifierQuoteString", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getImportedKeys", catalog, schema, table);
        try {
            ResultSet ret = chain.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getIndexInfo", catalog, schema, table, unique, approximate);
        try {
            ResultSet ret = chain.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getJDBCMajorVersion", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getJDBCMinorVersion", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxBinaryLiteralLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCatalogNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCharLiteralLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInGroupBy", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInIndex", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInOrderBy", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInSelect", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInTable", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxConnections", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxConnections(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCursorNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxIndexLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxProcedureNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxRowSize", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxRowSize(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxSchemaNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxStatementLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxStatements", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxStatements(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxTableNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxTablesInSelect", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxUserNameLength", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getNumericFunctions", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getNumericFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getPrimaryKeys", catalog, schema, table);
        try {
            ResultSet ret = chain.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedureTerm", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getProcedureTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedures", catalog, schemaPattern, procedureNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getResultSetHoldability", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getRowIdLifetime", new Object[0]);
        try {
            RowIdLifetime ret = chain.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
            logRecord.setReturnValue((Object)ret);
            RowIdLifetime rowIdLifetime = ret;
            return rowIdLifetime;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSQLKeywords", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getSQLKeywords(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSQLStateType", new Object[0]);
        try {
            int ret = chain.DatabaseMetaData_getSQLStateType(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemaTerm", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getSchemaTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemas", new Object[0]);
        try {
            ResultSet ret = chain.DatabaseMetaData_getSchemas(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemas", catalog, schemaPattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSearchStringEscape", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getStringFunctions", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getStringFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSuperTables", catalog, schemaPattern, tableNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSuperTypes", catalog, schemaPattern, typeNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSystemFunctions", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getSystemFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
        try {
            ResultSet ret = chain.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTableTypes", new Object[0]);
        try {
            ResultSet ret = chain.DatabaseMetaData_getTableTypes(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTables", catalog, schemaPattern, tableNamePattern, types);
        try {
            ResultSet ret = chain.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTimeDateFunctions", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTypeInfo", new Object[0]);
        try {
            ResultSet ret = chain.DatabaseMetaData_getTypeInfo(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getUDTs", catalog, schemaPattern, typeNamePattern, types);
        try {
            ResultSet ret = chain.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getURL", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getURL(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getUserName", new Object[0]);
        try {
            String ret = chain.DatabaseMetaData_getUserName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getVersionColumns", catalog, schema, table);
        try {
            ResultSet ret = chain.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "insertsAreDetected", type);
        try {
            boolean ret = chain.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "isCatalogAtStart", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "isReadOnly", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_isReadOnly(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "locatorsUpdateCopy", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullPlusNonNullIsNull", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedAtEnd", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedAtStart", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedHigh", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedLow", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersDeletesAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersInsertsAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersUpdatesAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownDeletesAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownInsertsAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownUpdatesAreVisible", type);
        try {
            boolean ret = chain.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesLowerCaseIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesLowerCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesMixedCaseIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesMixedCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesUpperCaseIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesUpperCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92EntryLevelSQL", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92FullSQL", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92IntermediateSQL", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsAlterTableWithAddColumn", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsAlterTableWithDropColumn", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsBatchUpdates", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInDataManipulation", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInIndexDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInPrivilegeDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInProcedureCalls", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInTableDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsColumnAliasing", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsConvert", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsConvert(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsConvert", fromType, toType);
        try {
            boolean ret = chain.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCoreSQLGrammar", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCorrelatedSubqueries", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDataDefinitionAndDataManipulationTransactions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDataManipulationTransactionsOnly", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDifferentTableCorrelationNames", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsExpressionsInOrderBy", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsExtendedSQLGrammar", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsFullOuterJoins", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGetGeneratedKeys", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupBy", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsGroupBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupByBeyondSelect", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupByUnrelated", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsIntegrityEnhancementFacility", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsLikeEscapeClause", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsLimitedOuterJoins", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMinimumSQLGrammar", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMixedCaseIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMixedCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleOpenResults", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleResultSets", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleTransactions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsNamedParameters", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsNonNullableColumns", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenCursorsAcrossCommit", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenCursorsAcrossRollback", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenStatementsAcrossCommit", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenStatementsAcrossRollback", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOrderByUnrelated", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOuterJoins", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsPositionedDelete", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsPositionedUpdate", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetConcurrency", type, concurrency);
        try {
            boolean ret = chain.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetHoldability", holdability);
        try {
            boolean ret = chain.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetType", type);
        try {
            boolean ret = chain.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSavepoints", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSavepoints(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInDataManipulation", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInIndexDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInPrivilegeDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInProcedureCalls", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInTableDefinitions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSelectForUpdate", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStatementPooling", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStoredFunctionsUsingCallSyntax", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStoredProcedures", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInComparisons", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInExists", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInIns", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInQuantifieds", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTableCorrelationNames", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTransactionIsolationLevel", level);
        try {
            boolean ret = chain.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTransactions", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsUnion", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsUnion(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsUnionAll", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_supportsUnionAll(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "updatesAreDetected", type);
        try {
            boolean ret = chain.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "usesLocalFilePerTable", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "usesLocalFiles", new Object[0]);
        try {
            boolean ret = chain.DatabaseMetaData_usesLocalFiles(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterClassName", param);
        try {
            String ret = chain.ParameterMetaData_getParameterClassName(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain chain, DmdbParameterMetaData parameterMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterCount", new Object[0]);
        try {
            int ret = chain.ParameterMetaData_getParameterCount(parameterMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterMode", param);
        try {
            int ret = chain.ParameterMetaData_getParameterMode(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterType", param);
        try {
            int ret = chain.ParameterMetaData_getParameterType(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterTypeName", param);
        try {
            String ret = chain.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getPrecision", param);
        try {
            int ret = chain.ParameterMetaData_getPrecision(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getScale", param);
        try {
            int ret = chain.ParameterMetaData_getScale(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "isNullable", param);
        try {
            int ret = chain.ParameterMetaData_isNullable(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "isSigned", param);
        try {
            boolean ret = chain.ParameterMetaData_isSigned(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "addBatch", new Object[0]);
        try {
            try {
                chain.PreparedStatement_addBatch(preparedStatement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "clearParameters", new Object[0]);
        try {
            try {
                chain.PreparedStatement_clearParameters(preparedStatement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_close(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "close", new Object[0]);
        try {
            try {
                chain.PreparedStatement_close(preparedStatement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeBatch", new Object[0]);
        try {
            int[] ret = chain.PreparedStatement_executeBatch(preparedStatement);
            logRecord.setReturnValue(ret);
            int[] nArray = ret;
            return nArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "execute", new Object[0]);
        try {
            boolean ret = chain.PreparedStatement_execute(preparedStatement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeQuery", new Object[0]);
        try {
            ResultSet ret = chain.PreparedStatement_executeQuery(preparedStatement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeUpdate", new Object[0]);
        try {
            int ret = chain.PreparedStatement_executeUpdate(preparedStatement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "getMetaData", new Object[0]);
        try {
            ResultSetMetaData ret = chain.PreparedStatement_getMetaData(preparedStatement);
            logRecord.setReturnValue(ret);
            ResultSetMetaData resultSetMetaData = ret;
            return resultSetMetaData;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "getParameterMetaData", new Object[0]);
        try {
            ParameterMetaData ret = chain.PreparedStatement_getParameterMetaData(preparedStatement);
            logRecord.setReturnValue(ret);
            ParameterMetaData parameterMetaData = ret;
            return parameterMetaData;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setArray(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setArray", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2, length);
        try {
            try {
                chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2, length);
        try {
            try {
                chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBigDecimal", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2, length);
        try {
            try {
                chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2, length);
        try {
            try {
                chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, inputStream);
        try {
            try {
                chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, inputStream, length);
        try {
            try {
                chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBoolean", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setByte(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setByte", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBytes", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader);
        try {
            try {
                chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader, length);
        try {
            try {
                chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader, length);
        try {
            try {
                chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, reader);
        try {
            try {
                chain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, reader, length);
        try {
            try {
                chain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDate", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDate", parameterIndex, x2, cal);
        try {
            try {
                chain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDouble", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setFloat", parameterIndex, Float.valueOf(x2));
        try {
            try {
                chain.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setInt(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setInt", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setLong(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setLong", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNCharacterStream", parameterIndex, value);
        try {
            try {
                chain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNCharacterStream", parameterIndex, value, length);
        try {
            try {
                chain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, value);
        try {
            try {
                chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, reader);
        try {
            try {
                chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, reader, length);
        try {
            try {
                chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNString(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNString", parameterIndex, value);
        try {
            try {
                chain.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNull", parameterIndex, sqlType);
        try {
            try {
                chain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNull", parameterIndex, sqlType, typeName);
        try {
            try {
                chain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType);
        try {
            try {
                chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType, scaleOrLength);
        try {
            try {
                chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setRef(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setRef", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setRowId", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setSQLXML", parameterIndex, xmlObject);
        try {
            try {
                chain.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setShort(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setShort", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setString(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setString", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTime", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTime", parameterIndex, x2, cal);
        try {
            try {
                chain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTimestamp", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTimestamp", parameterIndex, x2, cal);
        try {
            try {
                chain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setURL(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setURL", parameterIndex, x2);
        try {
            try {
                chain.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setUnicodeStream", parameterIndex, x2, length);
        try {
            try {
                chain.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_absolute(FilterChain chain, DmdbResultSet resultSet, int row) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "absolute", row);
        try {
            boolean ret = chain.ResultSet_absolute(resultSet, row);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_afterLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "afterLast", new Object[0]);
        try {
            try {
                chain.ResultSet_afterLast(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "beforeFirst", new Object[0]);
        try {
            try {
                chain.ResultSet_beforeFirst(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "cancelRowUpdates", new Object[0]);
        try {
            try {
                chain.ResultSet_cancelRowUpdates(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "clearWarnings", new Object[0]);
        try {
            try {
                chain.ResultSet_clearWarnings(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_close(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "close", new Object[0]);
        try {
            try {
                chain.ResultSet_close(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_deleteRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "deleteRow", new Object[0]);
        try {
            try {
                chain.ResultSet_deleteRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_findColumn(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "findColumn", columnLabel);
        try {
            int ret = chain.ResultSet_findColumn(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_first(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "first", new Object[0]);
        try {
            boolean ret = chain.ResultSet_first(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getArray", columnLabel);
        try {
            Array ret = chain.ResultSet_getArray(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getArray", columnIndex);
        try {
            Array ret = chain.ResultSet_getArray(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getAsciiStream", columnLabel);
        try {
            InputStream ret = chain.ResultSet_getAsciiStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getAsciiStream", columnIndex);
        try {
            InputStream ret = chain.ResultSet_getAsciiStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnLabel);
        try {
            BigDecimal ret = chain.ResultSet_getBigDecimal(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnLabel, scale);
        try {
            BigDecimal ret = chain.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnIndex);
        try {
            BigDecimal ret = chain.ResultSet_getBigDecimal(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnIndex, scale);
        try {
            BigDecimal ret = chain.ResultSet_getBigDecimal(resultSet, columnIndex, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBinaryStream", columnLabel);
        try {
            InputStream ret = chain.ResultSet_getBinaryStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBinaryStream", columnIndex);
        try {
            InputStream ret = chain.ResultSet_getBinaryStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBlob", columnLabel);
        try {
            Blob ret = chain.ResultSet_getBlob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBlob", columnIndex);
        try {
            Blob ret = chain.ResultSet_getBlob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBoolean", columnLabel);
        try {
            boolean ret = chain.ResultSet_getBoolean(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBoolean", columnIndex);
        try {
            boolean ret = chain.ResultSet_getBoolean(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getByte", columnLabel);
        try {
            byte ret = chain.ResultSet_getByte(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getByte", columnIndex);
        try {
            byte ret = chain.ResultSet_getByte(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBytes", columnLabel);
        try {
            byte[] ret = chain.ResultSet_getBytes(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBytes", columnIndex);
        try {
            byte[] ret = chain.ResultSet_getBytes(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCharacterStream", columnLabel);
        try {
            Reader ret = chain.ResultSet_getCharacterStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCharacterStream", columnIndex);
        try {
            Reader ret = chain.ResultSet_getCharacterStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getClob", columnLabel);
        try {
            Clob ret = chain.ResultSet_getClob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getClob", columnIndex);
        try {
            Clob ret = chain.ResultSet_getClob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getConcurrency", new Object[0]);
        try {
            int ret = chain.ResultSet_getConcurrency(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getCursorName(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCursorName", new Object[0]);
        try {
            String ret = chain.ResultSet_getCursorName(resultSet);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnLabel);
        try {
            Date ret = chain.ResultSet_getDate(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnLabel, cal);
        try {
            Date ret = chain.ResultSet_getDate(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnIndex);
        try {
            Date ret = chain.ResultSet_getDate(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnIndex, cal);
        try {
            Date ret = chain.ResultSet_getDate(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDouble", columnLabel);
        try {
            double ret = chain.ResultSet_getDouble(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDouble", columnIndex);
        try {
            double ret = chain.ResultSet_getDouble(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFetchDirection", new Object[0]);
        try {
            int ret = chain.ResultSet_getFetchDirection(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFetchSize", new Object[0]);
        try {
            int ret = chain.ResultSet_getFetchSize(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFloat", columnLabel);
        try {
            float ret = chain.ResultSet_getFloat(resultSet, columnLabel);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFloat", columnIndex);
        try {
            float ret = chain.ResultSet_getFloat(resultSet, columnIndex);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getHoldability(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getHoldability", new Object[0]);
        try {
            int ret = chain.ResultSet_getHoldability(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getInt", columnLabel);
        try {
            int ret = chain.ResultSet_getInt(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getInt", columnIndex);
        try {
            int ret = chain.ResultSet_getInt(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getLong", columnLabel);
        try {
            long ret = chain.ResultSet_getLong(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getLong", columnIndex);
        try {
            long ret = chain.ResultSet_getLong(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getMetaData", new Object[0]);
        try {
            ResultSetMetaData ret = chain.ResultSet_getMetaData(resultSet);
            logRecord.setReturnValue(ret);
            ResultSetMetaData resultSetMetaData = ret;
            return resultSetMetaData;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNCharacterStream", columnLabel);
        try {
            Reader ret = chain.ResultSet_getNCharacterStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNCharacterStream", columnIndex);
        try {
            Reader ret = chain.ResultSet_getNCharacterStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNClob", columnLabel);
        try {
            NClob ret = chain.ResultSet_getNClob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNClob", columnIndex);
        try {
            NClob ret = chain.ResultSet_getNClob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNString", columnLabel);
        try {
            String ret = chain.ResultSet_getNString(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNString", columnIndex);
        try {
            String ret = chain.ResultSet_getNString(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel);
        try {
            Object ret = chain.ResultSet_getObject(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel, type);
        try {
            T ret = chain.ResultSet_getObject(resultSet, columnLabel, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel, map);
        try {
            Object ret = chain.ResultSet_getObject(resultSet, columnLabel, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex);
        try {
            Object ret = chain.ResultSet_getObject(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex, type);
        try {
            T ret = chain.ResultSet_getObject(resultSet, columnIndex, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex, map);
        try {
            Object ret = chain.ResultSet_getObject(resultSet, columnIndex, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRef", columnLabel);
        try {
            Ref ret = chain.ResultSet_getRef(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRef", columnIndex);
        try {
            Ref ret = chain.ResultSet_getRef(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRow", new Object[0]);
        try {
            int ret = chain.ResultSet_getRow(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRowId", columnLabel);
        try {
            RowId ret = chain.ResultSet_getRowId(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRowId", columnIndex);
        try {
            RowId ret = chain.ResultSet_getRowId(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getSQLXML", columnLabel);
        try {
            SQLXML ret = chain.ResultSet_getSQLXML(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getSQLXML", columnIndex);
        try {
            SQLXML ret = chain.ResultSet_getSQLXML(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getShort", columnLabel);
        try {
            short ret = chain.ResultSet_getShort(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getShort", columnIndex);
        try {
            short ret = chain.ResultSet_getShort(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getStatement", new Object[0]);
        try {
            Statement ret = chain.ResultSet_getStatement(resultSet);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getString(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getString", columnLabel);
        try {
            String ret = chain.ResultSet_getString(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getString(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getString", columnIndex);
        try {
            String ret = chain.ResultSet_getString(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnLabel);
        try {
            Time ret = chain.ResultSet_getTime(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnLabel, cal);
        try {
            Time ret = chain.ResultSet_getTime(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnIndex);
        try {
            Time ret = chain.ResultSet_getTime(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnIndex, cal);
        try {
            Time ret = chain.ResultSet_getTime(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnLabel);
        try {
            Timestamp ret = chain.ResultSet_getTimestamp(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnLabel, cal);
        try {
            Timestamp ret = chain.ResultSet_getTimestamp(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnIndex);
        try {
            Timestamp ret = chain.ResultSet_getTimestamp(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnIndex, cal);
        try {
            Timestamp ret = chain.ResultSet_getTimestamp(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getType(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getType", new Object[0]);
        try {
            int ret = chain.ResultSet_getType(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getURL", columnLabel);
        try {
            URL ret = chain.ResultSet_getURL(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getURL", columnIndex);
        try {
            URL ret = chain.ResultSet_getURL(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getUnicodeStream", columnLabel);
        try {
            InputStream ret = chain.ResultSet_getUnicodeStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getUnicodeStream", columnIndex);
        try {
            InputStream ret = chain.ResultSet_getUnicodeStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = chain.ResultSet_getWarnings(resultSet);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_insertRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "insertRow", new Object[0]);
        try {
            try {
                chain.ResultSet_insertRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isAfterLast", new Object[0]);
        try {
            boolean ret = chain.ResultSet_isAfterLast(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isBeforeFirst", new Object[0]);
        try {
            boolean ret = chain.ResultSet_isBeforeFirst(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isClosed", new Object[0]);
        try {
            boolean ret = chain.ResultSet_isClosed(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isFirst", new Object[0]);
        try {
            boolean ret = chain.ResultSet_isFirst(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isLast", new Object[0]);
        try {
            boolean ret = chain.ResultSet_isLast(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_last(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "last", new Object[0]);
        try {
            boolean ret = chain.ResultSet_last(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "moveToCurrentRow", new Object[0]);
        try {
            try {
                chain.ResultSet_moveToCurrentRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "moveToInsertRow", new Object[0]);
        try {
            try {
                chain.ResultSet_moveToInsertRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_next(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "next", new Object[0]);
        try {
            boolean ret = chain.ResultSet_next(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_previous(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "previous", new Object[0]);
        try {
            boolean ret = chain.ResultSet_previous(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_refreshRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "refreshRow", new Object[0]);
        try {
            try {
                chain.ResultSet_refreshRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_relative(FilterChain chain, DmdbResultSet resultSet, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "relative", rows);
        try {
            boolean ret = chain.ResultSet_relative(resultSet, rows);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowDeleted", new Object[0]);
        try {
            boolean ret = chain.ResultSet_rowDeleted(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowInserted", new Object[0]);
        try {
            boolean ret = chain.ResultSet_rowInserted(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowUpdated", new Object[0]);
        try {
            boolean ret = chain.ResultSet_rowUpdated(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain chain, DmdbResultSet resultSet, int direction) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "setFetchDirection", direction);
        try {
            try {
                chain.ResultSet_setFetchDirection(resultSet, direction);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain chain, DmdbResultSet resultSet, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "setFetchSize", rows);
        try {
            try {
                chain.ResultSet_setFetchSize(resultSet, rows);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateArray", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateArray(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateArray", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateArray(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2, length);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2, length);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBigDecimal", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBigDecimal", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2, length);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2, length);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, inputStream);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, inputStream, length);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, inputStream);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, inputStream, length);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateBlob(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain chain, DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBoolean", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateBoolean(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain chain, DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBoolean", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateBoolean(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain chain, DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateByte", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateByte(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain chain, DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateByte", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateByte(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain chain, DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBytes", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateBytes(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain chain, DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBytes", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateBytes(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader, length);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader, length);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, reader);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnLabel, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, reader, length);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnLabel, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, reader);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnIndex, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, reader, length);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateClob(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDate", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateDate(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDate", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateDate(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain chain, DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDouble", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateDouble(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain chain, DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDouble", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateDouble(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain chain, DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateFloat", columnLabel, Float.valueOf(x2));
        try {
            try {
                chain.ResultSet_updateFloat(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain chain, DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateFloat", columnIndex, Float.valueOf(x2));
        try {
            try {
                chain.ResultSet_updateFloat(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain chain, DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateInt", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateInt(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain chain, DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateInt", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateInt(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain chain, DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateLong", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateLong(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain chain, DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateLong", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateLong(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnLabel, reader);
        try {
            try {
                chain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnLabel, reader, length);
        try {
            try {
                chain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnIndex, x2, length);
        try {
            try {
                chain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, nClob);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnLabel, nClob);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, reader);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnLabel, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, reader, length);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, nClob);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnIndex, nClob);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, reader);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnIndex, reader);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, reader, length);
        try {
            try {
                chain.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain chain, DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNString", columnLabel, nString);
        try {
            try {
                chain.ResultSet_updateNString(resultSet, columnLabel, nString);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain chain, DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNString", columnIndex, nString);
        try {
            try {
                chain.ResultSet_updateNString(resultSet, columnIndex, nString);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNull", columnLabel);
        try {
            try {
                chain.ResultSet_updateNull(resultSet, columnLabel);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNull", columnIndex);
        try {
            try {
                chain.ResultSet_updateNull(resultSet, columnIndex);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateObject(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2, scaleOrLength);
        try {
            try {
                chain.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateObject(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2, scaleOrLength);
        try {
            try {
                chain.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRef", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateRef(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRef", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateRef(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRow", new Object[0]);
        try {
            try {
                chain.ResultSet_updateRow(resultSet);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain chain, DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRowId", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateRowId(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain chain, DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRowId", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateRowId(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain chain, DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateSQLXML", columnLabel, xmlObject);
        try {
            try {
                chain.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain chain, DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateSQLXML", columnIndex, xmlObject);
        try {
            try {
                chain.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain chain, DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateShort", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateShort(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain chain, DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateShort", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateShort(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain chain, DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateString", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateString(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain chain, DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateString", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateString(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTime", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateTime(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTime", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateTime(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTimestamp", columnLabel, x2);
        try {
            try {
                chain.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTimestamp", columnIndex, x2);
        try {
            try {
                chain.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "wasNull", new Object[0]);
        try {
            boolean ret = chain.ResultSet_wasNull(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getCatalogName", column);
        try {
            String ret = chain.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnClassName", column);
        try {
            String ret = chain.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain chain, DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnCount", new Object[0]);
        try {
            int ret = chain.ResultSetMetaData_getColumnCount(resultSetMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnDisplaySize", column);
        try {
            int ret = chain.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnLabel", column);
        try {
            String ret = chain.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnName", column);
        try {
            String ret = chain.ResultSetMetaData_getColumnName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnType", column);
        try {
            int ret = chain.ResultSetMetaData_getColumnType(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnTypeName", column);
        try {
            String ret = chain.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getPrecision", column);
        try {
            int ret = chain.ResultSetMetaData_getPrecision(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getScale", column);
        try {
            int ret = chain.ResultSetMetaData_getScale(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getSchemaName", column);
        try {
            String ret = chain.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getTableName", column);
        try {
            String ret = chain.ResultSetMetaData_getTableName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isAutoIncrement", column);
        try {
            boolean ret = chain.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isCaseSensitive", column);
        try {
            boolean ret = chain.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isCurrency", column);
        try {
            boolean ret = chain.ResultSetMetaData_isCurrency(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isDefinitelyWritable", column);
        try {
            boolean ret = chain.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isNullable", column);
        try {
            int ret = chain.ResultSetMetaData_isNullable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isReadOnly", column);
        try {
            boolean ret = chain.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isSearchable", column);
        try {
            boolean ret = chain.ResultSetMetaData_isSearchable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isSigned", column);
        try {
            boolean ret = chain.ResultSetMetaData_isSigned(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isWritable", column);
        try {
            boolean ret = chain.ResultSetMetaData_isWritable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_addBatch(FilterChain chain, DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "addBatch", sql);
        try {
            try {
                chain.Statement_addBatch(statement, sql);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_cancel(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "cancel", new Object[0]);
        try {
            try {
                chain.Statement_cancel(statement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_clearBatch(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "clearBatch", new Object[0]);
        try {
            try {
                chain.Statement_clearBatch(statement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_clearWarnings(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "clearWarnings", new Object[0]);
        try {
            try {
                chain.Statement_clearWarnings(statement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_close(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "close", new Object[0]);
        try {
            try {
                chain.Statement_close(statement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "closeOnCompletion", new Object[0]);
        try {
            try {
                chain.Statement_closeOnCompletion(statement);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain chain, DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql);
        try {
            this.statementExecuteBefore(statement, "execute", sql);
            boolean ret = chain.Statement_execute(statement, sql);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain chain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, columnNames);
        try {
            this.statementExecuteBefore(statement, "execute", sql, columnNames);
            boolean ret = chain.Statement_execute(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain chain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, autoGeneratedKeys);
        try {
            this.statementExecuteBefore(statement, "execute", sql, autoGeneratedKeys);
            boolean ret = chain.Statement_execute(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain chain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, columnIndexes);
        try {
            this.statementExecuteBefore(statement, "execute", sql, columnIndexes);
            boolean ret = chain.Statement_execute(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public int[] Statement_executeBatch(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeBatch", new Object[0]);
        try {
            this.statementExecuteBefore(statement, "executeBatch", new Object[0]);
            int[] ret = chain.Statement_executeBatch(statement);
            logRecord.setReturnValue(ret);
            int[] nArray = ret;
            return nArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain chain, DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeQuery", sql);
        try {
            this.statementExecuteBefore(statement, "executeQuery", sql);
            ResultSet ret = chain.Statement_executeQuery(statement, sql);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain chain, DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql);
        try {
            this.statementExecuteBefore(statement, "executeUpdate", sql);
            int ret = chain.Statement_executeUpdate(statement, sql);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain chain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, columnNames);
        try {
            this.statementExecuteBefore(statement, "executeUpdate", sql, columnNames);
            int ret = chain.Statement_executeUpdate(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain chain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, autoGeneratedKeys);
        try {
            this.statementExecuteBefore(statement, "executeUpdate", sql, autoGeneratedKeys);
            int ret = chain.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain chain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, columnIndexes);
        try {
            this.statementExecuteBefore(statement, "executeUpdate", sql, columnIndexes);
            int ret = chain.Statement_executeUpdate(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.statementExecuteAfter(statement, logRecord);
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection Statement_getConnection(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getConnection", new Object[0]);
        try {
            Connection ret = chain.Statement_getConnection(statement);
            logRecord.setReturnValue(ret);
            Connection connection = ret;
            return connection;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getFetchDirection(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getFetchDirection", new Object[0]);
        try {
            int ret = chain.Statement_getFetchDirection(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getFetchSize(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getFetchSize", new Object[0]);
        try {
            int ret = chain.Statement_getFetchSize(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getGeneratedKeys", new Object[0]);
        try {
            ResultSet ret = chain.Statement_getGeneratedKeys(statement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getLargeUpdateCount", new Object[0]);
        try {
            long ret = chain.Statement_getLargeUpdateCount(statement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMaxFieldSize", new Object[0]);
        try {
            int ret = chain.Statement_getMaxFieldSize(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getMaxRows(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMaxRows", new Object[0]);
        try {
            int ret = chain.Statement_getMaxRows(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMoreResults", new Object[0]);
        try {
            boolean ret = chain.Statement_getMoreResults(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain chain, DmdbStatement statement, int current) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMoreResults", current);
        try {
            boolean ret = chain.Statement_getMoreResults(statement, current);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getQueryTimeout", new Object[0]);
        try {
            int ret = chain.Statement_getQueryTimeout(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSet", new Object[0]);
        try {
            ResultSet ret = chain.Statement_getResultSet(statement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetConcurrency", new Object[0]);
        try {
            int ret = chain.Statement_getResultSetConcurrency(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetHoldability", new Object[0]);
        try {
            int ret = chain.Statement_getResultSetHoldability(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetType(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetType", new Object[0]);
        try {
            int ret = chain.Statement_getResultSetType(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getUpdateCount(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getUpdateCount", new Object[0]);
        try {
            int ret = chain.Statement_getUpdateCount(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = chain.Statement_getWarnings(statement);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isCloseOnCompletion", new Object[0]);
        try {
            boolean ret = chain.Statement_isCloseOnCompletion(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isClosed(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isClosed", new Object[0]);
        try {
            boolean ret = chain.Statement_isClosed(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isPoolable(FilterChain chain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isPoolable", new Object[0]);
        try {
            boolean ret = chain.Statement_isPoolable(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setCursorName(FilterChain chain, DmdbStatement statement, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setCursorName", name);
        try {
            try {
                chain.Statement_setCursorName(statement, name);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain chain, DmdbStatement statement, boolean enable) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setEscapeProcessing", enable);
        try {
            try {
                chain.Statement_setEscapeProcessing(statement, enable);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setFetchDirection(FilterChain chain, DmdbStatement statement, int direction) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setFetchDirection", direction);
        try {
            try {
                chain.Statement_setFetchDirection(statement, direction);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setFetchSize(FilterChain chain, DmdbStatement statement, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setFetchSize", rows);
        try {
            try {
                chain.Statement_setFetchSize(statement, rows);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain chain, DmdbStatement statement, long max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setLargeMaxRows", max);
        try {
            try {
                chain.Statement_setLargeMaxRows(statement, max);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain chain, DmdbStatement statement, int max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setMaxFieldSize", max);
        try {
            try {
                chain.Statement_setMaxFieldSize(statement, max);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setMaxRows(FilterChain chain, DmdbStatement statement, int max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setMaxRows", max);
        try {
            try {
                chain.Statement_setMaxRows(statement, max);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setPoolable(FilterChain chain, DmdbStatement statement, boolean poolable) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setPoolable", poolable);
        try {
            try {
                chain.Statement_setPoolable(statement, poolable);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain chain, DmdbStatement statement, int seconds) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setQueryTimeout", seconds);
        try {
            try {
                chain.Statement_setQueryTimeout(statement, seconds);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    private void statementExecuteBefore(DmdbStatement statement, String method, Object ... params) {
        if (LOG.isSqlEnabled()) {
            statement.beforeExecute();
        }
    }

    private void statementExecuteAfter(DmdbStatement statement, LogRecord logRecord) {
        if (LOG.isSqlEnabled()) {
            long nanos = System.nanoTime() - statement.getLastExecuteStartNano();
            logRecord.setUsedTime(nanos);
        }
    }

    private void doLog(LogRecord logRecord) {
        try {
            if (logRecord != null) {
                if (logRecord.getThrowable() != null && LOG.isErrorEnabled()) {
                    LOG.error(logRecord.toString(), logRecord.getThrowable());
                } else if (logRecord.getThrowable() == null && LOG.isInfoEnabled()) {
                    LOG.info(logRecord.toString());
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Log failed!", e2);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getLargeMaxRows", new Object[0]);
        try {
            long ret = filterChain.Statement_getLargeMaxRows(statement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeBatch", new Object[0]);
        try {
            long[] ret = filterChain.Statement_executeLargeBatch(statement);
            logRecord.setReturnValue(ret);
            long[] lArray = ret;
            return lArray;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = filterChain.Statement_executeLargeUpdate(statement, sql);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = filterChain.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = filterChain.Statement_executeLargeUpdate(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = filterChain.Statement_executeLargeUpdate(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = filterChain.PreparedStatement_executeLargeUpdate(preparedStatement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    /* synthetic */ LogFilter(LogFilter logFilter) {
        this();
    }

    private static class LogFilterThreadHolder {
        private static final LogFilter instance = new LogFilter(null);

        private LogFilterThreadHolder() {
        }
    }
}

