/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.pool.DmdbConnectionCache_bs;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DmdbConnectionEventListener_bs
implements ConnectionEventListener {
    static final int CLOSED_EVENT = 1;
    static final int ERROROCCURED_EVENT = 2;
    private DataSource dataSource;

    DmdbConnectionEventListener_bs(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DmdbConnectionEventListener_bs() {
        this(null);
    }

    public synchronized void connectionClosed(ConnectionEvent event) {
        if (this.checkDataSource()) {
            DmdbConnectionCache_bs cache = (DmdbConnectionCache_bs)this.dataSource;
            try {
                cache.reusePooledConnection((PooledConnection)event.getSource());
            }
            catch (SQLException sQLException) {}
        }
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent event) {
        if (this.checkDataSource()) {
            DmdbConnectionCache_bs cache = (DmdbConnectionCache_bs)this.dataSource;
            try {
                cache.closePooledConnection((PooledConnection)event.getSource());
            }
            catch (SQLException sQLException) {}
        }
    }

    public void setDataSource(DataSource datasource) {
        this.dataSource = datasource;
    }

    public boolean checkDataSource() {
        return this.dataSource != null && this.dataSource instanceof DmdbConnectionCache_bs;
    }

    DataSource getDataSource() {
        return this.dataSource;
    }
}

