/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.rowset.DmdbRowSetInner;
import dm.jdbc.rowset.DmdbRowSetMetaData;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;

public class DmdbJdbcRowSet
extends DmdbRowSetInner
implements JdbcRowSet {
    private DmdbResultSet m_resultSet;
    private DmdbConnection m_connection;
    private DmdbCallableStatement m_callableStmt;
    private static boolean m_driverManagerInitialized;
    private boolean m_Closed;

    public DmdbJdbcRowSet(DmdbConnection conn) {
        this.initialize(conn);
    }

    public DmdbJdbcRowSet() {
        this.initialize(null);
    }

    private void initialize(DmdbConnection conn) {
        this.m_connection = conn;
        m_driverManagerInitialized = false;
        this.m_Closed = false;
    }

    private void preparedConn() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            return;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(this.getDataSourceName());
                this.m_connection = (DmdbConnection)datasource.getConnection();
            }
            catch (NamingException namingexception) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingexception.getMessage());
            }
        }
        if (!m_driverManagerInitialized) {
            try {
                Class.forName("dm.jdbc.driver.DmDriver");
                this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
            }
            m_driverManagerInitialized = true;
        } else {
            this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        this.m_connection.setTransactionIsolation(this.getTransactionIsolation());
        this.m_connection.setReadOnly(super.isReadOnly());
        this.m_connection.setTypeMap(this.getTypeMap());
    }

    private void preparedStmt(boolean reset) throws SQLException {
        if (this.m_callableStmt != null && !this.m_callableStmt.isClosed()) {
            if (reset) {
                this.m_callableStmt.close();
                this.m_callableStmt = null;
            } else {
                return;
            }
        }
        this.preparedConn();
        this.m_callableStmt = (DmdbCallableStatement)this.m_connection.prepareCall(this.getCommand(), this.getType(), this.getConcurrency());
        this.m_callableStmt.setFetchSize(this.getFetchSize());
        this.m_callableStmt.setFetchDirection(this.getFetchDirection());
        this.m_callableStmt.setMaxFieldSize(this.getMaxFieldSize());
        this.m_callableStmt.setMaxRows(this.getMaxRows());
        this.m_callableStmt.setQueryTimeout(this.getQueryTimeout());
        this.m_callableStmt.setEscapeProcessing(this.getEscapeProcessing());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_callableStmt.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.m_callableStmt.setBoolean(parameterIndex, x2);
    }

    @Override
    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.m_callableStmt.setByte(parameterIndex, x2);
    }

    @Override
    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.m_callableStmt.setShort(parameterIndex, x2);
    }

    @Override
    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.m_callableStmt.setInt(parameterIndex, x2);
    }

    @Override
    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.m_callableStmt.setLong(parameterIndex, x2);
    }

    @Override
    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.m_callableStmt.setFloat(parameterIndex, x2);
    }

    @Override
    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.m_callableStmt.setDouble(parameterIndex, x2);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.m_callableStmt.setBigDecimal(parameterIndex, x2);
    }

    @Override
    public void setString(int parameterIndex, String x2) throws SQLException {
        this.m_callableStmt.setString(parameterIndex, x2);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.m_callableStmt.setBytes(parameterIndex, x2);
    }

    @Override
    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.m_callableStmt.setDate(parameterIndex, x2);
    }

    @Override
    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.m_callableStmt.setTime(parameterIndex, x2);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x2);
    }

    @Override
    public void setRef(int i2, Ref x2) throws SQLException {
        this.m_callableStmt.setRef(i2, x2);
    }

    @Override
    public void setBlob(int i2, Blob x2) throws SQLException {
        this.m_callableStmt.setBlob(i2, x2);
    }

    @Override
    public void setClob(int i2, Clob x2) throws SQLException {
        this.m_callableStmt.setClob(i2, x2);
    }

    @Override
    public void setArray(int i2, Array x2) throws SQLException {
        this.m_callableStmt.setArray(i2, x2);
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setDate(parameterIndex, x2, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setTime(parameterIndex, x2, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterIndex, x2, cal);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.m_callableStmt.clearParameters();
    }

    @Override
    public void execute() throws SQLException {
        this.preparedStmt(false);
        this.m_resultSet = (DmdbResultSet)this.m_callableStmt.executeQuery();
    }

    @Override
    public boolean next() throws SQLException {
        boolean flag = this.m_resultSet.next();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_Closed) {
            return;
        }
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        this.m_resultSet = null;
        if (this.m_callableStmt != null) {
            this.m_callableStmt.close();
        }
        this.m_callableStmt = null;
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.commit();
            this.m_connection.close();
            this.m_connection = null;
        }
        this.m_Closed = true;
        this.notifyRowSetChanged();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_resultSet.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.m_resultSet.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.m_resultSet.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.m_resultSet.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.m_resultSet.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.m_resultSet.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.m_resultSet.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.m_resultSet.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.m_resultSet.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.m_resultSet.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.m_resultSet.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.m_resultSet.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.m_resultSet.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.m_resultSet.getString(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.m_resultSet.getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.m_resultSet.getByte(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.m_resultSet.getShort(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.m_resultSet.getInt(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.m_resultSet.getLong(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.m_resultSet.getFloat(columnName);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.m_resultSet.getDouble(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnName, scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.m_resultSet.getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.m_resultSet.getDate(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.m_resultSet.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.m_resultSet.getTimestamp(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.m_resultSet.getAsciiStream(columnName);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.m_resultSet.getUnicodeStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.m_resultSet.getBinaryStream(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_resultSet.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_resultSet.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.m_resultSet.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DmdbRowSetMetaData((DmdbResultSetMetaData)this.m_resultSet.getMetaData());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.m_resultSet.getObject(columnIndex, this.getTypeMap());
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.m_resultSet.getObject(columnName, this.getTypeMap());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.m_resultSet.getCharacterStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_resultSet.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_resultSet.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_resultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_resultSet.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.m_resultSet.beforeFirst();
            this.notifyCursorMovement();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.m_resultSet.afterLast();
            this.notifyCursorMovement();
        }
    }

    @Override
    public boolean first() throws SQLException {
        boolean flag = this.m_resultSet.first();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean last() throws SQLException {
        boolean flag = this.m_resultSet.last();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_resultSet.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean flag = this.m_resultSet.absolute(row);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean flag = this.m_resultSet.relative(rows);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean flag = this.m_resultSet.previous();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.m_resultSet.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.m_resultSet.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.m_resultSet.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.m_resultSet.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.m_resultSet.updateBoolean(columnIndex, x2);
    }

    @Override
    public void updateByte(int columnIndex, byte x2) throws SQLException {
        this.m_resultSet.updateByte(columnIndex, x2);
    }

    @Override
    public void updateShort(int columnIndex, short x2) throws SQLException {
        this.m_resultSet.updateShort(columnIndex, x2);
    }

    @Override
    public void updateInt(int columnIndex, int x2) throws SQLException {
        this.m_resultSet.updateInt(columnIndex, x2);
    }

    @Override
    public void updateLong(int columnIndex, long x2) throws SQLException {
        this.m_resultSet.updateLong(columnIndex, x2);
    }

    @Override
    public void updateFloat(int columnIndex, float x2) throws SQLException {
        this.m_resultSet.updateFloat(columnIndex, x2);
    }

    @Override
    public void updateDouble(int columnIndex, double x2) throws SQLException {
        this.m_resultSet.updateDouble(columnIndex, x2);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.m_resultSet.updateBigDecimal(columnIndex, x2);
    }

    @Override
    public void updateString(int columnIndex, String x2) throws SQLException {
        this.m_resultSet.updateString(columnIndex, x2);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.m_resultSet.updateBytes(columnIndex, x2);
    }

    @Override
    public void updateDate(int columnIndex, Date x2) throws SQLException {
        this.m_resultSet.updateDate(columnIndex, x2);
    }

    @Override
    public void updateTime(int columnIndex, Time x2) throws SQLException {
        this.m_resultSet.updateTime(columnIndex, x2);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.m_resultSet.updateTimestamp(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        this.m_resultSet.updateObject(columnIndex, x2, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x2) throws SQLException {
        this.m_resultSet.updateObject(columnIndex, x2);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.m_resultSet.updateNull(columnName);
    }

    @Override
    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.m_resultSet.updateBoolean(columnName, x2);
    }

    @Override
    public void updateByte(String columnName, byte x2) throws SQLException {
        this.m_resultSet.updateByte(columnName, x2);
    }

    @Override
    public void updateShort(String columnName, short x2) throws SQLException {
        this.m_resultSet.updateShort(columnName, x2);
    }

    @Override
    public void updateInt(String columnName, int x2) throws SQLException {
        this.m_resultSet.updateInt(columnName, x2);
    }

    @Override
    public void updateLong(String columnName, long x2) throws SQLException {
        this.m_resultSet.updateLong(columnName, x2);
    }

    @Override
    public void updateFloat(String columnName, float x2) throws SQLException {
        this.m_resultSet.updateFloat(columnName, x2);
    }

    @Override
    public void updateDouble(String columnName, double x2) throws SQLException {
        this.m_resultSet.updateDouble(columnName, x2);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.m_resultSet.updateBigDecimal(columnName, x2);
    }

    @Override
    public void updateString(String columnName, String x2) throws SQLException {
        this.m_resultSet.updateString(columnName, x2);
    }

    @Override
    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.m_resultSet.updateBytes(columnName, x2);
    }

    @Override
    public void updateDate(String columnName, Date x2) throws SQLException {
        this.m_resultSet.updateDate(columnName, x2);
    }

    @Override
    public void updateTime(String columnName, Time x2) throws SQLException {
        this.m_resultSet.updateTime(columnName, x2);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.m_resultSet.updateTimestamp(columnName, x2);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnName, x2, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnName, x2, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.m_resultSet.updateObject(columnName, x2, scale);
    }

    @Override
    public void updateObject(String columnName, Object x2) throws SQLException {
        this.m_resultSet.updateObject(columnName, x2);
    }

    @Override
    public void insertRow() throws SQLException {
        this.m_resultSet.insertRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.m_resultSet.updateRow();
        this.notifyUpdateListeners();
        this.notifyRowSetChanged();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.m_resultSet.deleteRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.m_resultSet.refreshRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.m_resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.m_resultSet.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.m_resultSet.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_resultSet.getStatement();
    }

    @Override
    public Object getObject(int i2, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            return this.m_resultSet.getObject(i2, map);
        }
        return this.m_resultSet.getObject(i2, this.getTypeMap());
    }

    @Override
    public Ref getRef(int i2) throws SQLException {
        return this.m_resultSet.getRef(i2);
    }

    @Override
    public Blob getBlob(int i2) throws SQLException {
        return this.m_resultSet.getBlob(i2);
    }

    @Override
    public Clob getClob(int i2) throws SQLException {
        return this.m_resultSet.getClob(i2);
    }

    @Override
    public Array getArray(int i2) throws SQLException {
        return this.m_resultSet.getArray(i2);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            return this.m_resultSet.getObject(colName, map);
        }
        return this.m_resultSet.getObject(colName, this.getTypeMap());
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.m_resultSet.getRef(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.m_resultSet.getBlob(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.m_resultSet.getClob(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.m_resultSet.getArray(colName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getDate(columnName, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getTimestamp(columnName, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.m_resultSet.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.m_resultSet.getURL(columnName);
    }

    @Override
    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.m_resultSet.updateRef(columnIndex, x2);
    }

    @Override
    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.m_resultSet.updateRef(columnName, x2);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, x2);
    }

    @Override
    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.m_resultSet.updateBlob(columnName, x2);
    }

    @Override
    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, x2);
    }

    @Override
    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.m_resultSet.updateClob(columnName, x2);
    }

    @Override
    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.m_resultSet.updateArray(columnIndex, x2);
    }

    @Override
    public void updateArray(String columnName, Array x2) throws SQLException {
        this.m_resultSet.updateArray(columnName, x2);
    }

    @Override
    public void setShowDeleted(boolean b2) throws SQLException {
        if (b2) {
            DBError.throwSQLException(20016);
        }
        super.setShowDeleted(b2);
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public void commit() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.commit();
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            return this.m_connection.getAutoCommit();
        }
        DBError.throwSQLException(6060);
        return false;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.setAutoCommit(autoCommit);
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.rollback();
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public void rollback(Savepoint s2) throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.rollback(s2);
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.m_resultSet.findColumn(columnName);
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        super.setCommand(cmd);
        this.preparedStmt(true);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.m_callableStmt.setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        this.m_callableStmt.setBoolean(parameterName, x2);
    }

    @Override
    public void setByte(String parameterName, byte x2) throws SQLException {
        this.m_callableStmt.setByte(parameterName, x2);
    }

    @Override
    public void setShort(String parameterName, short x2) throws SQLException {
        this.m_callableStmt.setShort(parameterName, x2);
    }

    @Override
    public void setInt(String parameterName, int x2) throws SQLException {
        this.m_callableStmt.setInt(parameterName, x2);
    }

    @Override
    public void setLong(String parameterName, long x2) throws SQLException {
        this.m_callableStmt.setLong(parameterName, x2);
    }

    @Override
    public void setFloat(String parameterName, float x2) throws SQLException {
        this.m_callableStmt.setFloat(parameterName, x2);
    }

    @Override
    public void setDouble(String parameterName, double x2) throws SQLException {
        this.m_callableStmt.setDouble(parameterName, x2);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        this.m_callableStmt.setBigDecimal(parameterName, x2);
    }

    @Override
    public void setString(String parameterName, String x2) throws SQLException {
        this.m_callableStmt.setString(parameterName, x2);
    }

    @Override
    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        this.m_callableStmt.setBytes(parameterName, x2);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterName, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterName, x2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterIndex, x2);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterName, x2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x2) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x2);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.m_callableStmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x2) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, x2);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setClob(parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x2) throws SQLException {
        this.m_callableStmt.setClob(parameterName, x2);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setClob(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x2) throws SQLException {
        this.m_callableStmt.setDate(parameterName, x2);
    }

    @Override
    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setDate(parameterName, x2, cal);
    }

    @Override
    public void setTime(String parameterName, Time x2) throws SQLException {
        this.m_callableStmt.setTime(parameterName, x2);
    }

    @Override
    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setTime(parameterName, x2, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterName, x2, cal);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.setSQLXML(parameterName, xmlObject);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x2) throws SQLException {
        this.m_callableStmt.setRowId(parameterIndex, x2);
    }

    @Override
    public void setRowId(String parameterName, RowId x2) throws SQLException {
        this.m_callableStmt.setRowId(parameterName, x2);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.m_callableStmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.m_callableStmt.setNString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.m_callableStmt.setURL(parameterIndex, x2);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.m_resultSet.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.m_resultSet.getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.m_resultSet.updateRowId(columnIndex, x2);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.m_resultSet.updateRowId(columnLabel, x2);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_resultSet.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_Closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.m_resultSet.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.m_resultSet.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.m_resultSet.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.m_resultSet.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.m_resultSet.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.m_resultSet.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.m_resultSet.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.m_resultSet.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.m_resultSet.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnLabel, x2, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnLabel, x2, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x2);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x2);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnLabel, x2);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnLabel, x2);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.m_resultSet.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.m_resultSet.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.m_resultSet.isWrapperFor(iface);
    }

    public void setINTERVALYM(int i2, DmdbIntervalYM ym) throws SQLException {
        this.m_callableStmt.setINTERVALYM(i2, ym);
    }

    public void setINTERVALDT(int i2, DmdbIntervalDT dt) throws SQLException {
        this.m_callableStmt.setINTERVALDT(i2, dt);
    }

    public void setTIMESTAMP(int i2, DmdbTimestamp t2) throws SQLException {
        this.m_callableStmt.setTIMESTAMP(i2, t2);
    }

    public void updateINTERVALYM(int i2, DmdbIntervalYM ym) throws SQLException {
        this.m_resultSet.updateINTERVALYM(i2, ym);
    }

    public void updateINTERVALYM(String s2, DmdbIntervalYM ym) throws SQLException {
        this.m_resultSet.updateINTERVALYM(s2, ym);
    }

    public void updateINTERVALDT(int i2, DmdbIntervalDT dt) throws SQLException {
        this.m_resultSet.updateINTERVALDT(i2, dt);
    }

    public void updateINTERVALDT(String s2, DmdbIntervalDT dt) throws SQLException {
        this.m_resultSet.updateINTERVALDT(s2, dt);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }
}

