/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class DmdbSerialClob
implements Serializable,
Cloneable,
Clob {
    private char[] m_buffer;
    private long m_length;

    DmdbSerialClob(char[] buf) {
        this.m_length = buf != null ? (long)buf.length : 0L;
        if (this.m_length <= 0L) {
            return;
        }
        this.m_buffer = new char[(int)this.m_length];
        System.arraycopy(buf, 0, this.m_buffer, 0, (int)this.m_length);
    }

    DmdbSerialClob(Clob clob) throws SQLException {
        if (clob == null) {
            return;
        }
        this.m_length = clob.length();
        if (this.m_length > Integer.MAX_VALUE) {
            throw new SQLException(DmSvcConf.res.getString("error.dataTooLarge"));
        }
        this.m_buffer = new char[(int)this.m_length];
        String ret = clob.getSubString(1L, (int)this.m_length);
        ret.getChars(0, ret.length(), this.m_buffer, 0);
    }

    public long length() throws SQLException {
        return this.m_length;
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || pos + (long)length > this.m_length) {
            DBError.throwSQLException(6057);
        }
        char[] dest = new char[length];
        System.arraycopy(this.m_buffer, (int)(pos - 1L), dest, 0, length);
        return new String(dest);
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.m_buffer);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(new String(this.m_buffer));
    }

    public long position(String searchstr, long start) throws SQLException {
        if (searchstr == null || searchstr.length() == 0 || start > this.m_length || start < 1L) {
            return -1L;
        }
        long posRet = -1L;
        int ptnsize = searchstr.length();
        int i2 = (int)(start - 1L);
        while ((long)i2 < this.m_length) {
            int j2 = 0;
            while (j2 < ptnsize) {
                if (this.m_buffer[i2] != searchstr.charAt(j2)) break;
                ++i2;
                ++j2;
            }
            if (j2 == ptnsize) {
                posRet = i2 + 1;
                break;
            }
            j2 = 0;
            ++i2;
        }
        return posRet;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return this.position(searchstr.getSubString(0L, (int)searchstr.length()), start);
    }

    public int setString(long pos, String str) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return -1;
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return -1;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void truncate(long len) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void free() throws SQLException {
        if (this.m_buffer != null || this.m_length != 0L) {
            this.m_buffer = null;
            this.m_length = 0L;
        }
    }
}

