/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.stat.StatService;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.stat.TableFormator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatReader {
    private static final String[] sqlRowTitle = new String[]{"", "Connection", "SQL", "ExecCount", "ExecTime", "ExecMax", "Txn", "Error", "Update", "FetchRow", "Running", "Concurrent", "ExecHisto", "ExecRsHisto", "FetchRowHisto", "UpdateHisto"};
    private static final String[] sqlRowField = new String[]{"rowNum", "DataSource", "SQL", "ExecuteCount", "TotalTime", "MaxTimespan", "InTransactionCount", "ErrorCount", "EffectedRowCount", "FetchRowCount", "RunningCount", "ConcurrentMax", "ExecuteHoldTimeHistogram", "ExecuteAndResultHoldTimeHistogram", "FetchRowCountHistogram", "EffectedRowCountHistogram"};
    private static final String[] sqlColField = new String[]{"ID", "DataSource", "SQL", "ExecuteCount", "ErrorCount", "TotalTime", "LastTime", "MaxTimespan", "LastError", "EffectedRowCount", "FetchRowCount", "MaxTimespanOccurTime", "BatchSizeMax", "BatchSizeTotal", "ConcurrentMax", "RunningCount", "Name", "File", "LastErrorMessage", "LastErrorClass", "LastErrorStackTrace", "LastErrorTime", "DbType", "URL", "InTransactionCount", "Histogram", "LastSlowParameters", "ResultSetHoldTime", "ExecuteAndResultSetHoldTime", "FetchRowCountHistogram", "EffectedRowCountHistogram", "ExecuteAndResultHoldTimeHistogram", "EffectedRowCountMax", "FetchRowCountMax", "ClobOpenCount"};
    private static final String[] dsRowTitle = new String[]{"", "Connection", "ActiveConnCount", "MaxActiveConnCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount"};
    private static final String[] dsRowField = new String[]{"rowNum", "Url", "ActiveConnCount", "MaxActiveConnCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount"};
    private static final String[] dsColField = new String[]{"ID", "ConnCount", "ActiveConnCount", "MaxActiveConnCount", "StmtCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount", "ClobOpenCount", "BlobOpenCount"};
    private List<Map<String, Object>> connStat;
    private int[] connStatColLens;
    private List<Map<String, Object>> highFreqSqlStat;
    private int[] highFreqSqlStatColLens;
    private List<Map<String, Object>> slowSqlStat;
    private int[] slowSqlStatColLens;

    public boolean readConnStat(List<String> retList, int maxCount) {
        String[] titles = dsRowTitle;
        String[] fields = dsRowField;
        boolean isAppend = false;
        if (this.connStat == null) {
            this.connStat = this.getConnStat(null, titles, fields);
            this.connStatColLens = TableFormator.calcColLens(this.connStat, fields, 32);
            isAppend = false;
        } else {
            isAppend = true;
        }
        List<Map<String, Object>> retContent = null;
        if (maxCount > 0 && this.connStat.size() > maxCount) {
            retContent = this.connStat.subList(0, maxCount);
            this.connStat = this.connStat.subList(maxCount, this.connStat.size());
        } else {
            retContent = this.connStat;
            this.connStat = null;
        }
        retList.add(this.getFormattedOutput(retContent, fields, this.connStatColLens, isAppend));
        return this.connStat != null;
    }

    public boolean readHighFreqSqlStat(List<String> retList, int maxCount) {
        boolean isAppend = false;
        if (this.highFreqSqlStat == null) {
            this.highFreqSqlStat = this.getHighFreqSqlStat(DmSvcConf.statHighFreqSqlCount, -1, sqlRowTitle, sqlRowField);
            this.highFreqSqlStatColLens = TableFormator.calcColLens(this.highFreqSqlStat, sqlRowField, 32);
            isAppend = false;
        } else {
            isAppend = true;
        }
        List<Map<String, Object>> retContent = null;
        if (maxCount > 0 && this.highFreqSqlStat.size() > maxCount) {
            retContent = this.highFreqSqlStat.subList(0, maxCount);
            this.highFreqSqlStat = this.highFreqSqlStat.subList(maxCount, this.highFreqSqlStat.size());
        } else {
            retContent = this.highFreqSqlStat;
            this.highFreqSqlStat = null;
        }
        retList.add(this.getFormattedOutput(retContent, sqlRowField, this.highFreqSqlStatColLens, isAppend));
        return this.highFreqSqlStat != null;
    }

    public List<Map<String, Object>> getHighFreqSqlStat(int topCount, int sqlId, String[] titles, String[] fields) {
        Properties parameters = new Properties();
        parameters.put("field", "ExecuteCount");
        parameters.put("direction", "desc");
        parameters.put("pageNum", "1");
        parameters.put("pageSize", String.valueOf(topCount));
        List<Map<String, Object>> content = StatService.getInstance().service("/sql.json", parameters);
        if (sqlId != -1) {
            ArrayList<Map<String, Object>> matchedContent = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> sqlStat : content) {
                Integer idStr = (Integer)sqlStat.get("ID");
                if (idStr != sqlId) continue;
                matchedContent.add(sqlStat);
                break;
            }
            content = matchedContent;
        }
        if (content == null) {
            content = new ArrayList<Map<String, Object>>();
        } else {
            int i2 = 1;
            for (Map<String, Object> map : content) {
                map.put("rowNum", i2);
                ++i2;
            }
        }
        TableFormator.addTitles(content, titles, fields);
        return content;
    }

    public boolean readSlowSqlStat(List<String> retList, int maxCount) {
        boolean isAppend = false;
        if (this.slowSqlStat == null) {
            this.slowSqlStat = this.getSlowSqlStat(DmSvcConf.statSlowSqlCount, -1, sqlRowTitle, sqlRowField);
            this.slowSqlStatColLens = TableFormator.calcColLens(this.slowSqlStat, sqlRowField, 32);
            isAppend = false;
        } else {
            isAppend = true;
        }
        List<Map<String, Object>> retContent = null;
        if (maxCount > 0 && this.slowSqlStat.size() > maxCount) {
            retContent = this.slowSqlStat.subList(0, maxCount);
            this.slowSqlStat = this.slowSqlStat.subList(maxCount, this.slowSqlStat.size());
        } else {
            retContent = this.slowSqlStat;
            this.slowSqlStat = null;
        }
        retList.add(this.getFormattedOutput(retContent, sqlRowField, this.slowSqlStatColLens, isAppend));
        return this.slowSqlStat != null;
    }

    private List<Map<String, Object>> getSlowSqlStat(int topCount, int sqlId, String[] titles, String[] fields) {
        Properties parameters = new Properties();
        parameters.put("field", "MaxTimespan");
        parameters.put("direction", "desc");
        parameters.put("pageNum", "1");
        parameters.put("pageSize", String.valueOf(topCount));
        List<Map<String, Object>> content = StatService.getInstance().service("/sql.json", parameters);
        if (sqlId != -1) {
            ArrayList<Map<String, Object>> matchedContent = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> sqlStat : content) {
                Integer idStr = (Integer)sqlStat.get("ID");
                if (idStr != sqlId) continue;
                matchedContent.add(sqlStat);
                break;
            }
            content = matchedContent;
        }
        if (content == null) {
            content = new ArrayList<Map<String, Object>>();
        } else {
            int i2 = 1;
            for (Map<String, Object> map : content) {
                map.put("rowNum", i2);
                ++i2;
            }
        }
        TableFormator.addTitles(content, titles, fields);
        return content;
    }

    private List<Map<String, Object>> getConnStat(String connId, String[] titles, String[] fileds) {
        List<Map<String, Object>> content = StatService.getInstance().service("/dataSource.json");
        if (StringUtil.isNotEmpty(connId)) {
            ArrayList<Map<String, Object>> matchedContent = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> dsStat : content) {
                String idStr = dsStat.get("Identity").toString();
                if (!connId.equals(idStr)) continue;
                matchedContent.add(dsStat);
                break;
            }
            content = matchedContent;
        }
        if (content == null) {
            content = new ArrayList<Map<String, Object>>();
        } else {
            int i2 = 1;
            for (Map<String, Object> map : content) {
                map.put("rowNum", i2);
                ++i2;
            }
        }
        TableFormator.addTitles(content, titles, fileds);
        return content;
    }

    private String getFormattedOutput(List<Map<String, Object>> content, String[] fields, int[] colLens, boolean isAppend) {
        return TableFormator.toTable(content, fields, colLens, true, isAppend);
    }
}

