/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class ByteArray {
    private Queue<Element> byteArrayList = new LinkedBlockingQueue<Element>();
    private Element current;
    private int length = 0;

    public int length() {
        return this.length;
    }

    public void addBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        Element e2 = new Element(bytes, offset, len);
        if (this.current == null) {
            this.current = e2;
        } else {
            this.byteArrayList.add(e2);
        }
        this.length += len;
    }

    public int writeBytes(OutputStream out, int len) throws IOException {
        int readLen = 0;
        int iLen = 0;
        while (readLen < len && this.current != null) {
            iLen = this.current.writeBytes(out, len - readLen);
            if (this.current.length == 0) {
                this.next();
            }
            readLen += iLen;
            this.length -= iLen;
        }
        return readLen;
    }

    public int writeBytes(byte[] buffer, int offset, int len) {
        int readLen = 0;
        int iLen = 0;
        while (readLen < len && this.current != null) {
            iLen = this.current.writeBytes(buffer, offset, len - readLen);
            if (this.current.length == 0) {
                this.next();
            }
            readLen += iLen;
            this.length -= iLen;
            offset += iLen;
        }
        return readLen;
    }

    public byte getByte(int offset) {
        int leaveLen = offset;
        Element e2 = this.current;
        while (leaveLen > 0 && e2 != null) {
            if (e2.length == 0) continue;
            if (leaveLen <= e2.length - 1) break;
            leaveLen -= e2.length;
            e2 = this.byteArrayList.peek();
        }
        return e2.getByte(leaveLen);
    }

    public void append(ByteArray buffer) {
        if (buffer.length() == 0) {
            return;
        }
        Element e2 = null;
        while ((e2 = buffer.current) != null) {
            this.addElement(e2);
            buffer.next();
        }
        buffer.length = 0;
    }

    private void addElement(Element e2) {
        if (e2.length == 0) {
            return;
        }
        if (this.current == null) {
            this.current = e2;
        } else {
            this.byteArrayList.add(e2);
        }
        this.length += e2.length;
    }

    private void next() {
        this.current = this.byteArrayList.poll();
    }

    public byte[] toBytes() {
        byte[] ret = new byte[this.length];
        Element e2 = this.current;
        int offset = 0;
        int leaveLen = ret.length;
        int iLen = 0;
        while (e2 != null) {
            if (e2.length > 0) {
                iLen = leaveLen > e2.length ? e2.length : leaveLen;
                System.arraycopy(e2.bytes, e2.start, ret, offset, iLen);
                offset += iLen;
                leaveLen -= iLen;
            }
            e2 = this.byteArrayList.peek();
        }
        return ret;
    }

    class Element {
        byte[] bytes;
        int start;
        int length;

        public Element(byte[] bytes, int offset, int len) {
            this.bytes = bytes;
            this.start = offset;
            this.length = len;
        }

        public int writeBytes(OutputStream out, int len) throws IOException {
            len = this.length > len ? len : this.length;
            out.write(this.bytes, this.start, len);
            this.start += len;
            this.length -= len;
            return len;
        }

        public int writeBytes(byte[] buffer, int offset, int len) {
            len = this.length > len ? len : this.length;
            System.arraycopy(this.bytes, this.start, buffer, offset, len);
            this.start += len;
            this.length -= len;
            return len;
        }

        public byte getByte(int offset) {
            return this.bytes[this.start + offset];
        }
    }
}

