/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DmDriver_bs;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.util.ReflectUtil;
import dm.jdbc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;

public class DmJdbcUtil {
    public static final int DEFAULT_READ_BUFFER_SIZE = 4096;

    public static DmdbConnection_bs getBaseConnection(Connection connAgent) {
        DmdbConnection_bs retConn = null;
        if (connAgent != null) {
            retConn = !(connAgent instanceof DmdbConnection_bs) ? (DmdbConnection_bs)ReflectUtil.executeMethod(connAgent, "getBaseObject") : (DmdbConnection_bs)connAgent;
        }
        return retConn;
    }

    public static void executeUpdate(DmdbConnection_bs conn, String sql) throws SQLException {
        DmdbStatement_bs stmt = null;
        try {
            stmt = (DmdbStatement_bs)conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Throwable throwable) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void executeForRw(DmdbConnection_bs conn, String sql, int rwDestType) throws SQLException {
        DmdbStatement_bs stmt = null;
        try {
            stmt = (DmdbStatement_bs)conn.createStatement();
            stmt.executeForRw(sql, rwDestType);
        }
        catch (Throwable throwable) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static ResultSet executeQuery(DmdbConnection_bs conn, String sql) throws SQLException {
        ResultSet resultSet;
        block7: {
            DmdbStatement_bs stmt = null;
            try {
                stmt = (DmdbStatement_bs)conn.createStatement(1004, 1007, 1);
                resultSet = stmt.executeQuery(sql, -1);
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return resultSet;
    }

    public static String executeAndGetExplain(DmdbConnection_bs conn, String sql) throws SQLException {
        String string;
        block7: {
            DmdbStatement_bs stmt = null;
            try {
                stmt = (DmdbStatement_bs)conn.createStatement();
                stmt.execute(sql);
                string = stmt.getExplain();
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static DmdbConnection_bs createConnection(String host, String port, String userName, String password, Properties props) throws SQLException {
        DmDriver_bs driver = new DmDriver_bs();
        return (DmdbConnection_bs)driver.connect("jdbc:dm://" + host + ":" + port + "?username=" + userName + "&password=" + password, props);
    }

    public static String formatTime() {
        return StringUtil.formatDateTimeString(new Timestamp(System.currentTimeMillis()), 2);
    }

    public static String formatTime(String prefix, String suffix) {
        return String.valueOf(prefix) + DmJdbcUtil.formatTime() + suffix;
    }

    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block3: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block3;
            }
            catch (Throwable throwable) {
                DmJdbcUtil.close(in);
                throw throwable;
            }
            DmJdbcUtil.close(in);
            return null;
        }
        byte[] byArray = DmJdbcUtil.readByteArray(in);
        DmJdbcUtil.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DmJdbcUtil.copy(input, output);
        return output.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n2 = 0;
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            count += (long)n2;
        }
        return count;
    }

    public static String read(InputStream in) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2.getMessage(), e2);
        }
        return DmJdbcUtil.read(reader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n2 = 0;
            while (-1 != (n2 = reader.read(buffer))) {
                writer.write(buffer, 0, n2);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block4: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = DmJdbcUtil.class.getResourceAsStream("/" + resource);
                }
                if (in != null) break block4;
            }
            catch (Throwable throwable) {
                DmJdbcUtil.close(in);
                throw throwable;
            }
            DmJdbcUtil.close(in);
            return null;
        }
        String string = text = DmJdbcUtil.read(in);
        DmJdbcUtil.close(in);
        return string;
    }

    public static void close(Closeable x2) {
        if (x2 == null) {
            return;
        }
        try {
            x2.close();
        }
        catch (Exception exception) {}
    }

    public static void printRs(ResultSet rs) throws SQLException {
        System.out.println("---------RS---------");
        ResultSetMetaData rsmd = rs.getMetaData();
        ArrayList<String> colNameList = new ArrayList<String>();
        String format = "";
        int i2 = 1;
        while (i2 <= rsmd.getColumnCount()) {
            format = String.valueOf(format) + "%-20s";
            colNameList.add(rsmd.getColumnName(i2));
            ++i2;
        }
        System.out.println(String.format(format, colNameList.toArray()));
        while (rs.next()) {
            ArrayList<String> valList = new ArrayList<String>();
            int i3 = 1;
            while (i3 <= rsmd.getColumnCount()) {
                valList.add(rs.getString(i3));
                ++i3;
            }
            System.out.println(String.format(format, valList.toArray()));
        }
        rs.close();
    }
}

