/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.accessor.ComplexTypeAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.util.DmJdbcUtil;
import dm.sql.StructDescriptor;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STRUCT
extends TypeData
implements Struct {
    StructDescriptor m_strctDesc;
    TypeData[] m_attribs;
    int m_objCount;
    int m_strCount;

    public STRUCT(TypeData[] atData, TypeDescriptor desc) {
        super(null, null);
        this.m_strctDesc = new StructDescriptor(desc);
        this.m_attribs = atData;
    }

    public TypeData[] getAttribsTypeData() {
        return this.m_attribs;
    }

    public STRUCT(StructDescriptor desc, Connection connAgent, Object[] objArr) throws SQLException {
        super(null, null);
        DmdbConnection_bs conn;
        if (desc == null) {
            DBError.throwSQLException(6036);
        }
        if ((conn = DmJdbcUtil.getBaseConnection(connAgent)) == null || conn.isClosed()) {
            throw new SQLException(DmSvcConf.res.getString("error.connectionClosedOrNotBuild"));
        }
        this.m_strctDesc = desc;
        if (objArr == null) {
            this.m_attribs = new TypeData[desc.getSize()];
        } else {
            if (desc.getSize() != objArr.length && desc.getObjId() != 4) {
                throw new SQLException(DmSvcConf.res.getString("error.structMemNotMatch"));
            }
            this.m_attribs = TypeData.toStruct(objArr, this.m_strctDesc.m_typeDesc);
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.m_strctDesc.m_typeDesc.getFulName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.toJavaArray(this);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        Object[] objs = this.getAttributes();
        if (map == null || map.size() == 0) {
            return objs;
        }
        int i2 = 0;
        while (i2 < objs.length) {
            if (objs[i2] instanceof STRUCT) {
                STRUCT struct = (STRUCT)objs[i2];
                objs[i2] = ComplexTypeAccessor.getStruct_SQLData(map, struct, struct.getSQLTypeName());
            }
            ++i2;
        }
        return objs;
    }

    private void checkCol(int col) throws SQLException {
        if (col < 1 || col > this.m_attribs.length) {
            DBError.throwSQLException(6032);
        }
    }

    TypeData getAttrValue(int col) throws SQLException {
        this.checkCol(col);
        return this.m_attribs[col - 1];
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        try {
            str.append(this.getSQLTypeName()).append("(");
            int i2 = 0;
            while (i2 < this.m_attribs.length) {
                if (i2 == 0) {
                    str.append(this.m_attribs[i2]);
                } else {
                    str.append(", ").append(this.m_attribs[i2]);
                }
                ++i2;
            }
            str.append(")");
        }
        catch (Exception exception) {}
        return str.toString();
    }
}

