/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug;

import java.io.Serializable;

public class Breakpoint
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final int line;

    public Breakpoint(String templateName, int line) {
        this.templateName = templateName;
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int hashCode() {
        return this.templateName.hashCode() + 31 * this.line;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof Breakpoint) {
            Breakpoint b2 = (Breakpoint)o2;
            return b2.templateName.equals(this.templateName) && b2.line == this.line;
        }
        return false;
    }

    public int compareTo(Object o2) {
        Breakpoint b2 = (Breakpoint)o2;
        int r2 = this.templateName.compareTo(b2.templateName);
        return r2 == 0 ? this.line - b2.line : r2;
    }

    public String getLocationString() {
        return this.templateName + ":" + this.line;
    }
}

