/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.create.table.ColDataType;

public class Alias {
    private String name;
    private boolean useAs = true;
    private List<AliasColumn> aliasColumns;

    public Alias(String name) {
        this.name = name;
    }

    public Alias(String name, boolean useAs) {
        this.name = name;
        this.useAs = useAs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseAs() {
        return this.useAs;
    }

    public void setUseAs(boolean useAs) {
        this.useAs = useAs;
    }

    public List<AliasColumn> getAliasColumns() {
        return this.aliasColumns;
    }

    public void setAliasColumns(List<AliasColumn> aliasColumns) {
        this.aliasColumns = aliasColumns;
    }

    public String toString() {
        String alias = (this.useAs ? " AS " : " ") + this.name;
        if (this.aliasColumns != null && !this.aliasColumns.isEmpty()) {
            String ac2 = "";
            for (AliasColumn col : this.aliasColumns) {
                if (ac2.length() > 0) {
                    ac2 = ac2 + ", ";
                }
                ac2 = ac2 + col.name;
                if (col.colDataType == null) continue;
                ac2 = ac2 + " " + col.colDataType.toString();
            }
            alias = alias + "(" + ac2 + ")";
        }
        return alias;
    }

    public static class AliasColumn {
        public final String name;
        public final ColDataType colDataType;

        public AliasColumn(String name, ColDataType colDataType) {
            Objects.requireNonNull(name);
            this.name = name;
            this.colDataType = colDataType;
        }

        public AliasColumn(String name) {
            this(name, null);
        }
    }
}

