/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class Function
extends ASTNodeAccessImpl
implements Expression {
    private List<String> nameparts;
    private ExpressionList parameters;
    private NamedExpressionList namedParameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean isEscaped = false;
    private Expression attribute;
    private String attributeName;
    private KeepExpression keep = null;
    private boolean ignoreNulls = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String getName() {
        return this.nameparts == null ? null : String.join((CharSequence)".", this.nameparts);
    }

    public List<String> getMultipartName() {
        return this.nameparts;
    }

    public void setName(String string) {
        this.nameparts = Arrays.asList(string);
    }

    public void setName(List<String> string) {
        this.nameparts = string;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b2) {
        this.allColumns = b2;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b2) {
        this.distinct = b2;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList list) {
        this.parameters = list;
    }

    public NamedExpressionList getNamedParameters() {
        return this.namedParameters;
    }

    public void setNamedParameters(NamedExpressionList list) {
        this.namedParameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public Expression getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Expression attribute) {
        this.attribute = attribute;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public String toString() {
        String params;
        if (this.parameters != null || this.namedParameters != null) {
            if (this.parameters != null) {
                params = this.parameters.toString();
                if (this.isDistinct()) {
                    params = params.replaceFirst("\\(", "(DISTINCT ");
                } else if (this.isAllColumns()) {
                    params = params.replaceFirst("\\(", "(ALL ");
                }
            } else {
                params = this.namedParameters.toString();
            }
        } else {
            params = this.isAllColumns() ? "(*)" : "()";
        }
        String ans = this.getName() + "" + params + "";
        if (this.attribute != null) {
            ans = ans + "." + this.attribute.toString();
        } else if (this.attributeName != null) {
            ans = ans + "." + this.attributeName;
        }
        if (this.keep != null) {
            ans = ans + " " + this.keep.toString();
        }
        if (this.isEscaped) {
            ans = "{fn " + ans + "}";
        }
        return ans;
    }
}

