/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression.operators.relational;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class InExpression
extends ASTNodeAccessImpl
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private ItemsList leftItemsList;
    private ItemsList rightItemsList;
    private boolean not = false;
    private Expression rightExpression;
    private MultiExpressionList multiExpressionList;
    private int oldOracleJoinSyntax = 0;

    public InExpression() {
    }

    public InExpression(Expression leftExpression, ItemsList itemsList) {
        this.setLeftExpression(leftExpression);
        this.setRightItemsList(itemsList);
    }

    @Override
    public void setOldOracleJoinSyntax(int oldOracleJoinSyntax) {
        this.oldOracleJoinSyntax = oldOracleJoinSyntax;
        if (oldOracleJoinSyntax < 0 || oldOracleJoinSyntax > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + oldOracleJoinSyntax + ")");
        }
    }

    @Override
    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public ItemsList getRightItemsList() {
        return this.rightItemsList;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public final void setRightItemsList(ItemsList list) {
        this.rightItemsList = list;
    }

    public final void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean b2) {
        this.not = b2;
    }

    public ItemsList getLeftItemsList() {
        return this.leftItemsList;
    }

    public void setLeftItemsList(ItemsList leftItemsList) {
        this.leftItemsList = leftItemsList;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        StringBuilder statementBuilder = new StringBuilder();
        if (this.leftExpression == null) {
            statementBuilder.append(this.leftItemsList);
        } else {
            statementBuilder.append(this.getLeftExpressionString());
        }
        statementBuilder.append(" ");
        if (this.not) {
            statementBuilder.append("NOT ");
        }
        statementBuilder.append("IN ");
        if (this.multiExpressionList != null) {
            statementBuilder.append("(");
            statementBuilder.append(this.multiExpressionList);
            statementBuilder.append(")");
        } else if (this.rightExpression == null) {
            statementBuilder.append(this.rightItemsList);
        } else {
            statementBuilder.append(this.rightExpression);
        }
        return statementBuilder.toString();
    }

    @Override
    public int getOraclePriorPosition() {
        return 0;
    }

    @Override
    public void setOraclePriorPosition(int priorPosition) {
        if (priorPosition != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }

    public MultiExpressionList getMultiExpressionList() {
        return this.multiExpressionList;
    }

    public void setMultiExpressionList(MultiExpressionList multiExpressionList) {
        this.multiExpressionList = multiExpressionList;
    }
}

