/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.util.TreeSet;
import net.sf.jsqlparser.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String INDENT = "    ";
    protected static String EOL = "\n";
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        this(currentTokenVal, expectedTokenSequencesVal, tokenImageVal, null);
    }

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, String lexicalStateName) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal, lexicalStateName));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage, String lexicalStateName) {
        StringBuilder sb = new StringBuilder();
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        for (int i2 = 0; i2 < expectedTokenSequences.length; ++i2) {
            if (maxSize < expectedTokenSequences[i2].length) {
                maxSize = expectedTokenSequences[i2].length;
            }
            for (int j2 = 0; j2 < expectedTokenSequences[i2].length; ++j2) {
                sortedOptions.add(tokenImage[expectedTokenSequences[i2][j2]]);
            }
        }
        for (String option : sortedOptions) {
            expected.append(INDENT).append(option).append(EOL);
        }
        sb.append("Encountered unexpected token:");
        Token tok = currentToken.next;
        for (int i3 = 0; i3 < maxSize; ++i3) {
            String tokenText = tok.image;
            String escapedTokenText = ParseException.add_escapes(tokenText);
            if (i3 != 0) {
                sb.append(" ");
            }
            if (tok.kind == 0) {
                sb.append(tokenImage[0]);
                break;
            }
            sb.append(" \"");
            sb.append(escapedTokenText);
            sb.append("\"");
            sb.append(" " + tokenImage[tok.kind]);
            tok = tok.next;
        }
        sb.append(EOL).append(INDENT).append("at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn);
        sb.append(".").append(EOL);
        if (expectedTokenSequences.length != 0) {
            int numExpectedTokens = expectedTokenSequences.length;
            sb.append(EOL).append("Was expecting" + (numExpectedTokens == 1 ? ":" : " one of:") + EOL + EOL);
            sb.append(expected.toString());
        }
        return sb.toString();
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block10: for (int i2 = 0; i2 < str.length(); ++i2) {
            switch (str.charAt(i2)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i2);
                    if (ch < ' ' || ch > '~') {
                        String s2 = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s2.substring(s2.length() - 4, s2.length()));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

