/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public abstract class CreateFunctionalStatement
implements Statement {
    private String kind;
    private List<String> functionDeclarationParts;

    protected CreateFunctionalStatement(String kind, List<String> functionDeclarationParts) {
        this.kind = kind;
        this.functionDeclarationParts = functionDeclarationParts;
    }

    public List<String> getFunctionDeclarationParts() {
        return this.functionDeclarationParts;
    }

    public String getKind() {
        return this.kind;
    }

    public String formatDeclaration() {
        StringBuilder declaration = new StringBuilder();
        for (int currIndex = 0; currIndex < this.functionDeclarationParts.size(); ++currIndex) {
            String nextToken;
            String token = this.functionDeclarationParts.get(currIndex);
            declaration.append(token);
            if (currIndex + 1 >= this.functionDeclarationParts.size() || (nextToken = this.functionDeclarationParts.get(currIndex + 1)).equals(";")) continue;
            declaration.append(" ");
        }
        return declaration.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return "CREATE " + this.kind + " " + this.formatDeclaration();
    }
}

