/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.statement.DeclareType;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;

public final class DeclareStatement
implements Statement {
    private UserVariable userVariable = null;
    private DeclareType type = DeclareType.TYPE;
    private String typeName;
    private List<TypeDefExpr> typeDefExprList = new ArrayList<TypeDefExpr>();
    private List<ColumnDefinition> colDefs = new ArrayList<ColumnDefinition>();

    public void setUserVariable(UserVariable userVariable) {
        this.userVariable = userVariable;
    }

    public UserVariable getUserVariable() {
        return this.userVariable;
    }

    public DeclareType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setDeclareType(DeclareType type) {
        this.type = type;
    }

    public void addType(ColDataType colDataType, Expression defaultExpr) {
        this.typeDefExprList.add(new TypeDefExpr(colDataType, defaultExpr));
    }

    public void addType(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
        this.typeDefExprList.add(new TypeDefExpr(userVariable, colDataType, defaultExpr));
    }

    public void addColumnDefinition(ColumnDefinition colDef) {
        this.colDefs.add(colDef);
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.colDefs;
    }

    public List<TypeDefExpr> getTypeDefinitions() {
        return this.typeDefExprList;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("DECLARE ");
        if (this.type == DeclareType.AS) {
            b2.append(this.userVariable.toString());
            b2.append(" AS ").append(this.typeName);
        } else if (this.type == DeclareType.TABLE) {
            b2.append(this.userVariable.toString());
            b2.append(" TABLE (");
            for (int i2 = 0; i2 < this.colDefs.size(); ++i2) {
                if (i2 > 0) {
                    b2.append(", ");
                }
                b2.append(this.colDefs.get(i2).toString());
            }
            b2.append(")");
        } else {
            for (int i3 = 0; i3 < this.typeDefExprList.size(); ++i3) {
                if (i3 > 0) {
                    b2.append(", ");
                }
                TypeDefExpr type = this.typeDefExprList.get(i3);
                if (type.userVariable != null) {
                    b2.append(type.userVariable.toString()).append(" ");
                }
                b2.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                b2.append(" = ").append(type.defaultExpr.toString());
            }
        }
        return b2.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public static class TypeDefExpr {
        public final UserVariable userVariable;
        public final ColDataType colDataType;
        public final Expression defaultExpr;

        public TypeDefExpr(ColDataType colDataType, Expression defaultExpr) {
            this(null, colDataType, defaultExpr);
        }

        public TypeDefExpr(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
            this.userVariable = userVariable;
            this.colDataType = colDataType;
            this.defaultExpr = defaultExpr;
        }
    }
}

