/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.delete;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Delete
implements Statement {
    private Table table;
    private List<Table> tables;
    private List<Join> joins;
    private Expression where;
    private Limit limit;
    private List<OrderByElement> orderByElements;

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("DELETE");
        if (this.tables != null && this.tables.size() > 0) {
            b2.append(" ");
            b2.append(this.tables.stream().map(t2 -> t2.toString()).collect(Collectors.joining(", ")));
        }
        b2.append(" FROM ");
        b2.append(this.table);
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    b2.append(", ").append(join);
                    continue;
                }
                b2.append(" ").append(join);
            }
        }
        if (this.where != null) {
            b2.append(" WHERE ").append(this.where);
        }
        if (this.orderByElements != null) {
            b2.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b2.append(this.limit);
        }
        return b2.toString();
    }
}

