/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.merge;

import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.merge.MergeInsert;
import net.sf.jsqlparser.statement.merge.MergeUpdate;
import net.sf.jsqlparser.statement.select.SubSelect;

public class Merge
implements Statement {
    private Table table;
    private Table usingTable;
    private SubSelect usingSelect;
    private Alias usingAlias;
    private Expression onCondition;
    private MergeInsert mergeInsert;
    private MergeUpdate mergeUpdate;
    private boolean insertFirst = false;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public Table getUsingTable() {
        return this.usingTable;
    }

    public void setUsingTable(Table usingTable) {
        this.usingTable = usingTable;
    }

    public SubSelect getUsingSelect() {
        return this.usingSelect;
    }

    public void setUsingSelect(SubSelect usingSelect) {
        this.usingSelect = usingSelect;
        if (this.usingSelect != null) {
            this.usingSelect.setUseBrackets(false);
        }
    }

    public Alias getUsingAlias() {
        return this.usingAlias;
    }

    public void setUsingAlias(Alias usingAlias) {
        this.usingAlias = usingAlias;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public void setOnCondition(Expression onCondition) {
        this.onCondition = onCondition;
    }

    public MergeInsert getMergeInsert() {
        return this.mergeInsert;
    }

    public void setMergeInsert(MergeInsert insert) {
        this.mergeInsert = insert;
    }

    public MergeUpdate getMergeUpdate() {
        return this.mergeUpdate;
    }

    public void setMergeUpdate(MergeUpdate mergeUpdate) {
        this.mergeUpdate = mergeUpdate;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    public void setInsertFirst(boolean insertFirst) {
        this.insertFirst = insertFirst;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("MERGE INTO ");
        b2.append(this.table);
        b2.append(" USING ");
        if (this.usingTable != null) {
            b2.append(this.usingTable.toString());
        } else if (this.usingSelect != null) {
            b2.append("(").append(this.usingSelect.toString()).append(")");
        }
        if (this.usingAlias != null) {
            b2.append(this.usingAlias.toString());
        }
        b2.append(" ON (");
        b2.append(this.onCondition);
        b2.append(")");
        if (this.insertFirst && this.mergeInsert != null) {
            b2.append(this.mergeInsert.toString());
        }
        if (this.mergeUpdate != null) {
            b2.append(this.mergeUpdate.toString());
        }
        if (!this.insertFirst && this.mergeInsert != null) {
            b2.append(this.mergeInsert.toString());
        }
        return b2.toString();
    }
}

