/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.upsert;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class Upsert
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setUseSelectBrackets(boolean useSelectBrackets) {
        this.useSelectBrackets = useSelectBrackets;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseDuplicate(boolean useDuplicate) {
        this.useDuplicate = useDuplicate;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.duplicateUpdateColumns = duplicateUpdateColumns;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.duplicateUpdateExpressionList = duplicateUpdateExpressionList;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPSERT INTO ");
        sb.append(this.table).append(" ");
        if (this.columns != null) {
            sb.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            sb.append("VALUES ");
        }
        if (this.itemsList != null) {
            sb.append(this.itemsList);
        } else {
            if (this.useSelectBrackets) {
                sb.append("(");
            }
            if (this.select != null) {
                sb.append(this.select);
            }
            if (this.useSelectBrackets) {
                sb.append(")");
            }
        }
        if (this.useDuplicate) {
            sb.append(" ON DUPLICATE KEY UPDATE ");
            for (int i2 = 0; i2 < this.getDuplicateUpdateColumns().size(); ++i2) {
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append(this.duplicateUpdateColumns.get(i2)).append(" = ");
                sb.append(this.duplicateUpdateExpressionList.get(i2));
            }
        }
        return sb.toString();
    }
}

