/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.ObjectTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class ResultSetWrapper {
    private final ResultSet resultSet;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> classNames = new ArrayList<String>();
    private final List<JdbcType> jdbcTypes = new ArrayList<JdbcType>();
    private final Map<String, Map<Class<?>, TypeHandler<?>>> typeHandlerMap = new HashMap();
    private final Map<String, List<String>> mappedColumnNamesMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> unMappedColumnNamesMap = new HashMap<String, List<String>>();

    public ResultSetWrapper(ResultSet rs, Configuration configuration) throws SQLException {
        this.typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        this.resultSet = rs;
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            this.columnNames.add(configuration.isUseColumnLabel() ? metaData.getColumnLabel(i2) : metaData.getColumnName(i2));
            this.jdbcTypes.add(JdbcType.forCode(metaData.getColumnType(i2)));
            this.classNames.add(metaData.getColumnClassName(i2));
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getClassNames() {
        return Collections.unmodifiableList(this.classNames);
    }

    public List<JdbcType> getJdbcTypes() {
        return this.jdbcTypes;
    }

    public JdbcType getJdbcType(String columnName) {
        for (int i2 = 0; i2 < this.columnNames.size(); ++i2) {
            if (!this.columnNames.get(i2).equalsIgnoreCase(columnName)) continue;
            return this.jdbcTypes.get(i2);
        }
        return null;
    }

    public TypeHandler<?> getTypeHandler(Class<?> propertyType, String columnName) {
        TypeHandler<Object> handler = null;
        Map<Class<?>, TypeHandler<?>> columnHandlers = this.typeHandlerMap.get(columnName);
        if (columnHandlers == null) {
            columnHandlers = new HashMap();
            this.typeHandlerMap.put(columnName, columnHandlers);
        } else {
            handler = columnHandlers.get(propertyType);
        }
        if (handler == null) {
            JdbcType jdbcType = this.getJdbcType(columnName);
            handler = this.typeHandlerRegistry.getTypeHandler(propertyType, jdbcType);
            if (handler == null || handler instanceof UnknownTypeHandler) {
                int index = this.columnNames.indexOf(columnName);
                Class<?> javaType = this.resolveClass(this.classNames.get(index));
                if (javaType != null && jdbcType != null) {
                    handler = this.typeHandlerRegistry.getTypeHandler(javaType, jdbcType);
                } else if (javaType != null) {
                    handler = this.typeHandlerRegistry.getTypeHandler(javaType);
                } else if (jdbcType != null) {
                    handler = this.typeHandlerRegistry.getTypeHandler(jdbcType);
                }
            }
            if (handler == null || handler instanceof UnknownTypeHandler) {
                handler = new ObjectTypeHandler();
            }
            columnHandlers.put(propertyType, handler);
        }
        return handler;
    }

    private Class<?> resolveClass(String className) {
        try {
            if (className != null) {
                return Resources.classForName(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void loadMappedAndUnmappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
        ArrayList<String> mappedColumnNames = new ArrayList<String>();
        ArrayList<String> unmappedColumnNames = new ArrayList<String>();
        String upperColumnPrefix = columnPrefix == null ? null : columnPrefix.toUpperCase(Locale.ENGLISH);
        Set<String> mappedColumns = this.prependPrefixes(resultMap.getMappedColumns(), upperColumnPrefix);
        for (String columnName : this.columnNames) {
            String upperColumnName = columnName.toUpperCase(Locale.ENGLISH);
            if (mappedColumns.contains(upperColumnName)) {
                mappedColumnNames.add(upperColumnName);
                continue;
            }
            unmappedColumnNames.add(columnName);
        }
        this.mappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), mappedColumnNames);
        this.unMappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), unmappedColumnNames);
    }

    public List<String> getMappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
        List<String> mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        if (mappedColumnNames == null) {
            this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
            mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        }
        return mappedColumnNames;
    }

    public List<String> getUnmappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
        List<String> unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        if (unMappedColumnNames == null) {
            this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
            unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        }
        return unMappedColumnNames;
    }

    private String getMapKey(ResultMap resultMap, String columnPrefix) {
        return resultMap.getId() + ":" + columnPrefix;
    }

    private Set<String> prependPrefixes(Set<String> columnNames, String prefix) {
        if (columnNames == null || columnNames.isEmpty() || prefix == null || prefix.length() == 0) {
            return columnNames;
        }
        HashSet<String> prefixed = new HashSet<String>();
        for (String columnName : columnNames) {
            prefixed.add(prefix + columnName);
        }
        return prefixed;
    }
}

