/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import com.zenith.support.xmltags.AbsSqlNode;
import com.zenith.support.xmltags.AdddateSqlNode;
import com.zenith.support.xmltags.AvgSqlNode;
import com.zenith.support.xmltags.ConcatStrSqlNode;
import com.zenith.support.xmltags.CountSqlNode;
import com.zenith.support.xmltags.DateCompareSqlNode;
import com.zenith.support.xmltags.DefDateSqlNode;
import com.zenith.support.xmltags.ExtractSqlNode;
import com.zenith.support.xmltags.FieldLengthSqlNode;
import com.zenith.support.xmltags.GroupConcatSqlNode;
import com.zenith.support.xmltags.LowerSqlNode;
import com.zenith.support.xmltags.MaxSqlNode;
import com.zenith.support.xmltags.MinSqlNode;
import com.zenith.support.xmltags.SelectTopSqlNode;
import com.zenith.support.xmltags.SubstrSqlNode;
import com.zenith.support.xmltags.SumSqlNode;
import com.zenith.support.xmltags.ToNumberSqlNode;
import com.zenith.support.xmltags.TocharSqlNode;
import com.zenith.support.xmltags.TodateSqlNode;
import com.zenith.support.xmltags.TrimStrSqlNode;
import com.zenith.support.xmltags.UpperSqlNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SetSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

public class XMLScriptBuilder
extends BaseBuilder {
    private final XNode context;
    private boolean isDynamic;
    private final Class<?> parameterType;
    private final Map<String, NodeHandler> nodeHandlerMap = new HashMap<String, NodeHandler>();

    public XMLScriptBuilder(Configuration configuration, XNode context) {
        this(configuration, context, null);
    }

    public XMLScriptBuilder(Configuration configuration, XNode context, Class<?> parameterType) {
        super(configuration);
        this.context = context;
        this.parameterType = parameterType;
        this.initNodeHandlerMap();
    }

    private void initNodeHandlerMap() {
        this.nodeHandlerMap.put("trim", new TrimHandler());
        this.nodeHandlerMap.put("where", new WhereHandler());
        this.nodeHandlerMap.put("set", new SetHandler());
        this.nodeHandlerMap.put("foreach", new ForEachHandler());
        this.nodeHandlerMap.put("if", new IfHandler());
        this.nodeHandlerMap.put("choose", new ChooseHandler());
        this.nodeHandlerMap.put("when", new IfHandler());
        this.nodeHandlerMap.put("otherwise", new OtherwiseHandler());
        this.nodeHandlerMap.put("bind", new BindHandler());
        this.nodeHandlerMap.put("defdate", new DefDateHandler());
        this.nodeHandlerMap.put("fielength", new FieldLengthHandler());
        this.nodeHandlerMap.put("substr", new SubstrHandler());
        this.nodeHandlerMap.put("concatstr", new ConcatStrHandler());
        this.nodeHandlerMap.put("tochar", new TocharHandler());
        this.nodeHandlerMap.put("todate", new TodateHandler());
        this.nodeHandlerMap.put("lower", new LowerHandler());
        this.nodeHandlerMap.put("upper", new UpperHandler());
        this.nodeHandlerMap.put("sum", new SumHandler());
        this.nodeHandlerMap.put("avg", new AvgHandler());
        this.nodeHandlerMap.put("max", new MaxHandler());
        this.nodeHandlerMap.put("min", new MinHandler());
        this.nodeHandlerMap.put("count", new CountHandler());
        this.nodeHandlerMap.put("abs", new AbsHandler());
        this.nodeHandlerMap.put("trimstr", new TrimStrHandler());
        this.nodeHandlerMap.put("dateCompare", new DateCompareHandler());
        this.nodeHandlerMap.put("tonumber", new ToNumberHandler());
        this.nodeHandlerMap.put("extract", new ExtractHandler());
        this.nodeHandlerMap.put("adddate", new AdddateHandler());
        this.nodeHandlerMap.put("groupConcat", new GroupConcatHandler());
    }

    public SqlSource parseScriptNode() {
        MixedSqlNode rootSqlNode = this.parseDynamicTags(this.context);
        SqlSource sqlSource = this.isDynamic ? new DynamicSqlSource(this.configuration, rootSqlNode) : new RawSqlSource(this.configuration, rootSqlNode, this.parameterType);
        return sqlSource;
    }

    protected MixedSqlNode parseDynamicTags(XNode node) {
        ArrayList<SqlNode> contents = new ArrayList<SqlNode>();
        NodeList children = node.getNode().getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            XNode child = node.newXNode(children.item(i2));
            if (child.getNode().getNodeType() == 4 || child.getNode().getNodeType() == 3) {
                String data = child.getStringBody("");
                TextSqlNode textSqlNode = new TextSqlNode(data);
                if (textSqlNode.isDynamic()) {
                    contents.add(textSqlNode);
                    this.isDynamic = true;
                    continue;
                }
                contents.add(new StaticTextSqlNode(data));
                continue;
            }
            if (child.getNode().getNodeType() != 1) continue;
            String nodeName = child.getNode().getNodeName();
            NodeHandler handler = this.nodeHandlerMap.get(nodeName);
            if (handler == null) {
                throw new BuilderException("Unknown element <" + nodeName + "> in SQL statement.");
            }
            handler.handleNode(child, contents);
            this.isDynamic = true;
        }
        return new MixedSqlNode(contents);
    }

    private class GroupConcatHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            String separator = nodeToHandle.getStringAttribute("separator");
            GroupConcatSqlNode groupConcatSqlNode = new GroupConcatSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, separator);
            targetContents.add(groupConcatSqlNode);
        }
    }

    private class AdddateHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            String num = nodeToHandle.getStringAttribute("num");
            String type = nodeToHandle.getStringAttribute("type");
            AdddateSqlNode dateSqlNode = new AdddateSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, num, type);
            targetContents.add(dateSqlNode);
        }
    }

    private class ExtractHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String type = nodeToHandle.getStringAttribute("type");
            String column = nodeToHandle.getStringAttribute("column");
            ExtractSqlNode dateSqlNode = new ExtractSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, type, column);
            targetContents.add(dateSqlNode);
        }
    }

    private class ToNumberHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            ToNumberSqlNode dateSqlNode = new ToNumberSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class DateCompareHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            String operation = nodeToHandle.getStringAttribute("operation");
            String str = nodeToHandle.getStringAttribute("str");
            DateCompareSqlNode dateSqlNode = new DateCompareSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, str, operation);
            targetContents.add(dateSqlNode);
        }
    }

    private class TrimStrHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            TrimStrSqlNode dateSqlNode = new TrimStrSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class AbsHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            AbsSqlNode dateSqlNode = new AbsSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class CountHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            CountSqlNode dateSqlNode = new CountSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class MinHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            MinSqlNode dateSqlNode = new MinSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class MaxHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            MaxSqlNode dateSqlNode = new MaxSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class AvgHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            AvgSqlNode dateSqlNode = new AvgSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class SumHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            SumSqlNode dateSqlNode = new SumSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class UpperHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            UpperSqlNode dateSqlNode = new UpperSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class LowerHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            LowerSqlNode dateSqlNode = new LowerSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class TodateHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            TodateSqlNode dateSqlNode = new TodateSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class TocharHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            TocharSqlNode dateSqlNode = new TocharSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, null);
            targetContents.add(dateSqlNode);
        }
    }

    private class ConcatStrHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column1 = nodeToHandle.getStringAttribute("column1");
            String column2 = nodeToHandle.getStringAttribute("column2");
            ConcatStrSqlNode dateSqlNode = new ConcatStrSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column1, column2);
            targetContents.add(dateSqlNode);
        }
    }

    private class SubstrHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            String index = nodeToHandle.getStringAttribute("index");
            String length = nodeToHandle.getStringAttribute("length");
            SubstrSqlNode dateSqlNode = new SubstrSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, index, length);
            targetContents.add(dateSqlNode);
        }
    }

    private class SelectTopHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String num = nodeToHandle.getStringAttribute("num");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            SelectTopSqlNode dateSqlNode = new SelectTopSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, num, suffix);
            targetContents.add(dateSqlNode);
        }
    }

    private class FieldLengthHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String column = nodeToHandle.getStringAttribute("column");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            FieldLengthSqlNode dateSqlNode = new FieldLengthSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, column, suffix);
            targetContents.add(dateSqlNode);
        }
    }

    private class DefDateHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String prefix = nodeToHandle.getStringAttribute("prefix");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            DefDateSqlNode dateSqlNode = new DefDateSqlNode(mixedSqlNode, XMLScriptBuilder.this.configuration, prefix, suffix);
            targetContents.add(dateSqlNode);
        }
    }

    private class ChooseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            ArrayList<SqlNode> whenSqlNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> otherwiseSqlNodes = new ArrayList<SqlNode>();
            this.handleWhenOtherwiseNodes(nodeToHandle, whenSqlNodes, otherwiseSqlNodes);
            SqlNode defaultSqlNode = this.getDefaultSqlNode(otherwiseSqlNodes);
            ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, defaultSqlNode);
            targetContents.add(chooseSqlNode);
        }

        private void handleWhenOtherwiseNodes(XNode chooseSqlNode, List<SqlNode> ifSqlNodes, List<SqlNode> defaultSqlNodes) {
            List<XNode> children = chooseSqlNode.getChildren();
            for (XNode child : children) {
                String nodeName = child.getNode().getNodeName();
                NodeHandler handler = (NodeHandler)XMLScriptBuilder.this.nodeHandlerMap.get(nodeName);
                if (handler instanceof IfHandler) {
                    handler.handleNode(child, ifSqlNodes);
                    continue;
                }
                if (!(handler instanceof OtherwiseHandler)) continue;
                handler.handleNode(child, defaultSqlNodes);
            }
        }

        private SqlNode getDefaultSqlNode(List<SqlNode> defaultSqlNodes) {
            SqlNode defaultSqlNode = null;
            if (defaultSqlNodes.size() == 1) {
                defaultSqlNode = defaultSqlNodes.get(0);
            } else if (defaultSqlNodes.size() > 1) {
                throw new BuilderException("Too many default (otherwise) elements in choose statement.");
            }
            return defaultSqlNode;
        }
    }

    private class OtherwiseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            targetContents.add(mixedSqlNode);
        }
    }

    private class IfHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String test = nodeToHandle.getStringAttribute("test");
            IfSqlNode ifSqlNode = new IfSqlNode(mixedSqlNode, test);
            targetContents.add(ifSqlNode);
        }
    }

    private class ForEachHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String collection = nodeToHandle.getStringAttribute("collection");
            String item = nodeToHandle.getStringAttribute("item");
            String index = nodeToHandle.getStringAttribute("index");
            String open = nodeToHandle.getStringAttribute("open");
            String close = nodeToHandle.getStringAttribute("close");
            String separator = nodeToHandle.getStringAttribute("separator");
            ForEachSqlNode forEachSqlNode = new ForEachSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode, collection, index, item, open, close, separator);
            targetContents.add(forEachSqlNode);
        }
    }

    private class SetHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            SetSqlNode set = new SetSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode);
            targetContents.add(set);
        }
    }

    private class WhereHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            WhereSqlNode where = new WhereSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode);
            targetContents.add(where);
        }
    }

    private class TrimHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String prefix = nodeToHandle.getStringAttribute("prefix");
            String prefixOverrides = nodeToHandle.getStringAttribute("prefixOverrides");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            String suffixOverrides = nodeToHandle.getStringAttribute("suffixOverrides");
            TrimSqlNode trim = new TrimSqlNode(XMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode, prefix, prefixOverrides, suffix, suffixOverrides);
            targetContents.add(trim);
        }
    }

    private class BindHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            String name = nodeToHandle.getStringAttribute("name");
            String expression = nodeToHandle.getStringAttribute("value");
            VarDeclSqlNode node = new VarDeclSqlNode(name, expression);
            targetContents.add(node);
        }
    }

    private static interface NodeHandler {
        public void handleNode(XNode var1, List<SqlNode> var2);
    }
}

