/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

public abstract class Pack {
    public static int bigEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] << 24;
        n2 |= (bs[++off] & 0xFF) << 16;
        n2 |= (bs[++off] & 0xFF) << 8;
        return n2 |= bs[++off] & 0xFF;
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Pack.bigEndianToInt(bs, off);
        int lo = Pack.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n2, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n2 >>> 32), bs, off);
        Pack.intToBigEndian((int)(n2 & 0xFFFFFFFFL), bs, off + 4);
    }

    public static byte[] longToBigEndian(long[] ns) {
        byte[] bs = new byte[8 * ns.length];
        Pack.longToBigEndian(ns, bs, 0);
        return bs;
    }

    public static void longToBigEndian(long[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.longToBigEndian(ns[i2], bs, off);
            off += 8;
        }
    }

    public static short littleEndianToShort(byte[] bs, int off) {
        int n2 = bs[off] & 0xFF;
        return (short)(n2 |= (bs[++off] & 0xFF) << 8);
    }

    public static void intToBigEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)(n2 >>> 24);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)n2;
    }
}

