/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.generator;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import top.tanmw.generator.ColumnClass;
import top.tanmw.generator.FreeMarkerTemplateUtils;
import top.tanmw.generator.GeneratorModel;
import top.tanmw.generator.ProjectPattern;
import top.tanmw.generator.db.DbFactory;
import top.tanmw.generator.db.DbQuery;

public class CodeGenerateUtils {
    private String url;
    private String driver;
    private String user;
    private String password;
    private String basePath;
    private String projectName;
    private String author;
    private String packageName;
    private Set<String> includeSet;
    private Set<String> includeSetComment;
    private Map<String, String> includeMapName;
    private Set<String> excludeSet;
    private Set<String> excludePrefix;
    private String basePackageName;
    private String basePackagePath;
    private String baseControllerPath;
    private String baseApiPath;
    private String baseServicePath;
    private String baseDaoPath;
    private String baseModelPath;
    private String baseMapperPath;
    private DbQuery dbQuery;
    private Boolean isReplace;
    private ProjectPattern projectPattern;
    private final List<ColumnClass> columnClassList = new ArrayList<ColumnClass>();
    private String tableName;
    private List<Integer> fileType;
    private String primaryKeyColumnName;
    private String primaryKeyFieldName;
    private String primaryKeyFieldMethodName;
    private String changeTableName;
    private String tableDescribe;

    public void initTableMapName() {
        this.includeMapName = new HashMap<String, String>();
        if (CollUtil.isNotEmpty(this.includeSet) && CollUtil.isNotEmpty(this.includeSetComment) && this.includeSet.size() == this.includeSetComment.size()) {
            AtomicInteger count = new AtomicInteger(0);
            this.includeSet.forEach(table -> this.includeMapName.put((String)table, this.includeSetComment.toArray(new String[0])[count.getAndIncrement()]));
        }
    }

    public Connection getConnection() throws Exception {
        Class.forName(this.driver);
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public void init(GeneratorModel generatorModel) {
        this.url = generatorModel.getUrl();
        this.driver = generatorModel.getDriver();
        this.user = generatorModel.getUser();
        this.password = generatorModel.getPassword();
        this.basePath = generatorModel.getBasePath();
        this.projectName = generatorModel.getProjectName();
        this.packageName = generatorModel.getPackageName();
        this.includeSet = generatorModel.getIncludeSet();
        this.includeSetComment = generatorModel.getIncludeSetComment();
        this.excludeSet = generatorModel.getExcludeSet();
        this.excludePrefix = generatorModel.getExcludePrefix();
        this.isReplace = generatorModel.isReplace();
        this.fileType = generatorModel.getFileType();
        this.author = generatorModel.getAuthor();
        if (StrUtil.isBlank(this.author)) {
            this.author = "TMW";
        }
        this.basePackageName = this.packageName;
        this.basePackagePath = this.basePackageName.replaceAll("\\.", "/");
        this.projectPattern = ProjectPattern.getPattern(generatorModel.getPattern());
        if (Objects.equals((Object)ProjectPattern.SINGLE, (Object)this.projectPattern)) {
            this.baseControllerPath = "/src/main/java/" + this.basePackagePath;
            this.baseApiPath = "/src/main/java/" + this.basePackagePath;
            this.baseServicePath = "/src/main/java/" + this.basePackagePath;
            this.baseDaoPath = "/src/main/java/" + this.basePackagePath;
            this.baseModelPath = "/src/main/java/" + this.basePackagePath;
            this.baseMapperPath = "/src/main/resources/";
        } else {
            this.baseControllerPath = this.projectName + "-" + "web" + "/src/main/java/" + this.basePackagePath;
            this.baseApiPath = this.projectName + "-" + "api" + "/src/main/java/" + this.basePackagePath;
            this.baseServicePath = this.projectName + "-" + "service" + "/src/main/java/" + this.basePackagePath;
            this.baseDaoPath = this.projectName + "-" + "dao" + "/src/main/java/" + this.basePackagePath;
            this.baseMapperPath = this.projectName + "-" + "dao" + "/src/main/resources/";
            this.baseModelPath = this.projectName + "-" + "model" + "/src/main/java/" + this.basePackagePath;
        }
        this.dbQuery = DbFactory.getDbQuery(generatorModel.getUrl());
    }

    public void generate() throws Exception {
        try (Connection connection = null;){
            connection = this.getConnection();
            Set<String> tables = this.findTables(connection);
            Map<String, String> tableCommentMap = this.findTableComment(connection);
            Set<String> lowerCaseSet = this.includeSet;
            if (lowerCaseSet.size() > 0) {
                tables = tables.stream().filter(lowerCaseSet::contains).collect(Collectors.toSet());
            }
            if (this.excludeSet.size() > 0) {
                tables = tables.stream().filter(tableNameStr -> !this.excludeSet.contains(tableNameStr)).collect(Collectors.toSet());
            }
            if (tables.size() < 1) {
                throw new RuntimeException("\u672a\u53d1\u73b0\u53ef\u751f\u6210\u8868");
            }
            for (String tableNameStr2 : tables) {
                this.primaryKeyFieldName = null;
                this.primaryKeyFieldMethodName = null;
                this.tableName = tableNameStr2;
                String string = this.tableDescribe = tableCommentMap.get(tableNameStr2) == null ? this.tableName : tableCommentMap.get(tableNameStr2);
                if (StrUtil.isNotBlank(this.includeMapName.get(this.tableName)) && (StrUtil.isBlank(this.tableDescribe) || StrUtil.equals(this.tableDescribe, this.tableName))) {
                    this.tableDescribe = this.includeMapName.get(this.tableName);
                }
                String noPrefixName = tableNameStr2.toLowerCase();
                if (CollUtil.isNotEmpty(this.excludePrefix)) {
                    for (String prefix : this.excludePrefix) {
                        if (!noPrefixName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                        noPrefixName = noPrefixName.replaceFirst(prefix.toLowerCase(), "");
                        break;
                    }
                }
                this.changeTableName = this.replaceUnderLineAndUpperCase(noPrefixName);
                this.columnClassList.clear();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet = this.dbQuery.getResultSet(databaseMetaData, this.tableName);
                ResultSet primaryKeys = databaseMetaData.getPrimaryKeys(null, null, this.tableName);
                while (primaryKeys.next()) {
                    this.primaryKeyColumnName = primaryKeys.getString("COLUMN_NAME");
                    this.primaryKeyFieldName = this.replaceUnderLineAndUpperCase(this.primaryKeyColumnName);
                }
                try {
                    if (this.fileType.contains(1)) {
                        this.generateModelFile(resultSet);
                    }
                    if (this.fileType.contains(2)) {
                        this.generateDTOFile(resultSet);
                    }
                    if (this.fileType.contains(3)) {
                        this.generateListDTOFile(resultSet);
                    }
                    if (this.fileType.contains(4)) {
                        this.generateVOFile(resultSet);
                    }
                    if (this.fileType.contains(5)) {
                        this.generateConverterFile(resultSet);
                    }
                    if (this.fileType.contains(6)) {
                        this.generateMapperFile(resultSet);
                    }
                    if (this.fileType.contains(7)) {
                        this.generateDaoFile(resultSet);
                    }
                    if (this.fileType.contains(8)) {
                        this.generateServiceInterfaceFile(resultSet);
                    }
                    if (this.fileType.contains(9)) {
                        this.generateServiceImplFile(resultSet);
                    }
                    if (!this.fileType.contains(10)) continue;
                    this.generateControllerFile(resultSet);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public Set<String> findTables(Connection connection) throws SQLException {
        HashSet<String> set = new HashSet<String>();
        PreparedStatement ps = connection.prepareStatement(this.dbQuery.getShowTablesSql());
        ResultSet resultSet = ps.executeQuery();
        while (resultSet.next()) {
            String tableName = resultSet.getString(1);
            set.add(tableName);
        }
        if (set.size() <= 0) {
            throw new RuntimeException("\u672a\u5728\u6307\u5b9a\u6570\u636e\u5e93\u4e2d\u53d1\u73b0\u53ef\u7528\u8868\uff01");
        }
        return set;
    }

    public Map<String, String> findTableComment(Connection connection) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>(16);
        PreparedStatement ps = connection.prepareStatement(this.dbQuery.getShowTablesCommentSql());
        ResultSet resultSet = ps.executeQuery();
        while (resultSet.next()) {
            String tableName = resultSet.getString(1);
            String tableComment = resultSet.getString(2);
            map.put(tableName, tableComment);
        }
        return map;
    }

    private String getCreatePath(String baseFilePath, String filePath, String suffix) {
        String path = this.basePath + File.separator + baseFilePath + File.separator + filePath + File.separator + this.changeTableName + suffix;
        return path.replace("\\", "/");
    }

    private String getSuffixPackageName(String packagePath) {
        if (StrUtil.isBlank(packagePath)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (packagePath.contains("/")) {
            String[] split;
            for (String str : split = packagePath.split("/")) {
                sb.append(str).append(".");
            }
            return this.basePackageName + "." + sb.substring(0, sb.length() - 1);
        }
        return this.basePackageName + "." + packagePath;
    }

    private void generateModelFile(ResultSet resultSet) throws Exception {
        String suffix = ".java";
        String path = this.getCreatePath(this.baseModelPath, "model/entity", ".java");
        String templateName = "Model.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        this.generateModelAndDTOAndVoFile(resultSet, "Model.ftl", mapperFile, "model/entity");
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + ".java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateModelAndDTOAndVoFile(ResultSet resultSet, String templateName, File createFile, String packageName) throws Exception {
        if (this.columnClassList.size() < 1) {
            ColumnClass columnClass = null;
            while (resultSet.next()) {
                columnClass = new ColumnClass();
                String columnName = resultSet.getString("COLUMN_NAME");
                columnClass.setColumnName(columnName);
                columnClass.setColumnType(resultSet.getString("TYPE_NAME").toLowerCase());
                if (StrUtil.isUpperCase(columnName)) {
                    columnName = columnName.toLowerCase();
                }
                columnName = columnName.replaceAll("#", "");
                columnClass.setChangeColumnName(this.replaceUnderLineAndUpperCase(columnName));
                String remarks = resultSet.getString("REMARKS");
                if (StrUtil.isNotBlank(remarks) && (remarks.contains("\r") || remarks.contains("\n"))) {
                    remarks = remarks.replace("\r", " ").replace("\n", " ");
                }
                columnClass.setColumnComment(remarks);
                boolean equals = StrUtil.equals(columnClass.getColumnName(), this.primaryKeyColumnName);
                if (equals) {
                    this.primaryKeyFieldMethodName = StrUtil.upperFirst(columnClass.getChangeColumnName());
                }
                columnClass.setPrimaryKey(equals);
                this.columnClassList.add(columnClass);
            }
        }
        ArrayList<ColumnClass> relColumnClassList = StrUtil.equalsAny((CharSequence)templateName, "Model.ftl") ? new ArrayList<ColumnClass>(this.columnClassList) : new ArrayList<ColumnClass>(this.columnClassList);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("model_column", relColumnClassList);
        this.generateFileByTemplate(templateName, packageName, createFile, dataMap);
    }

    private void generateListDTOFile(ResultSet resultSet) throws Exception {
        String suffix = "ListDTO.java";
        String path = this.getCreatePath(this.baseModelPath, "model/dto", "ListDTO.java");
        String templateName = "ListDTO.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        this.generateModelAndDTOAndVoFile(resultSet, "ListDTO.ftl", mapperFile, "model/dto");
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "ListDTO.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateVOFile(ResultSet resultSet) throws Exception {
        String suffix = "VO.java";
        String path = this.getCreatePath(this.baseModelPath, "model/vo", "VO.java");
        String templateName = "VO.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        this.generateModelAndDTOAndVoFile(resultSet, "VO.ftl", mapperFile, "model/vo");
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "VO.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateDTOFile(ResultSet resultSet) throws Exception {
        String suffix = "DTO.java";
        String path = this.getCreatePath(this.baseModelPath, "model/dto", "DTO.java");
        String templateName = "DTO.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        this.generateModelAndDTOAndVoFile(resultSet, "DTO.ftl", mapperFile, "model/dto");
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "DTO.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateConverterFile(ResultSet resultSet) throws Exception {
        String suffix = "Converter.java";
        String path = this.getCreatePath(this.baseModelPath, "model/converter", "Converter.java");
        String templateName = "Converter.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Converter.ftl", "model/converter", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "Converter.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateControllerFile(ResultSet resultSet) throws Exception {
        String suffix = "Controller.java";
        String path = this.getCreatePath(this.baseControllerPath, "controller", "Controller.java");
        String templateName = "Controller.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Controller.ftl", "controller", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "Controller.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateServiceImplFile(ResultSet resultSet) throws Exception {
        String suffix = "ServiceImpl.java";
        String path = this.getCreatePath(this.baseServicePath, "service", "ServiceImpl.java");
        String templateName = "ServiceImpl.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("ServiceImpl.ftl", "service", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "ServiceImpl.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateServiceInterfaceFile(ResultSet resultSet) throws Exception {
        String suffix = "Service.java";
        String path = this.getCreatePath(this.baseApiPath, "api", "Service.java");
        String templateName = "Service.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Service.ftl", "api", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "Service.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateRepositoryFile(ResultSet resultSet) throws Exception {
        String suffix = "Repository.java";
        String path = this.basePath + this.changeTableName + "Repository.java";
        String templateName = "Repository.ftl";
        File mapperFile = new File(path);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Repository.ftl", mapperFile, dataMap);
    }

    private void generateDaoFile(ResultSet resultSet) throws Exception {
        String suffix = "Mapper.java";
        String path = this.getCreatePath(this.baseDaoPath, "dao", "Mapper.java");
        String templateName = "Mapper.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Mapper.ftl", "dao", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "Mapper.java \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateMapperFile(ResultSet resultSet) throws Exception {
        String suffix = "Mapper.xml";
        String path = this.getCreatePath(this.baseMapperPath, "mapper", "Mapper.xml");
        String templateName = "Mapper.xml.ftl";
        File mapperFile = new File(path);
        this.checkFilePath(mapperFile);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        this.generateFileByTemplate("Mapper.xml.ftl", mapperFile, dataMap);
        System.out.println("<<<<<<<<<<<< \u751f\u6210 " + this.changeTableName + "Mapper.xml \u5b8c\u6210 >>>>>>>>>>>");
    }

    private void generateFileByTemplate(String templateName, File file, Map<String, Object> dataMap) throws Exception {
        this.generateFileByTemplate(templateName, null, file, dataMap);
    }

    private void generateFileByTemplate(String templateName, String packagePath, File file, Map<String, Object> dataMap) throws Exception {
        Template template = FreeMarkerTemplateUtils.getTemplate(templateName);
        FileOutputStream fos = new FileOutputStream(file);
        dataMap.put("serialVersionUID", this.getSerialVersionUID());
        dataMap.put("table_name_small", this.tableName);
        dataMap.put("table_name", this.changeTableName);
        dataMap.put("lower_table_name", StrUtil.lowerFirst(this.changeTableName));
        dataMap.put("author", this.author);
        dataMap.put("table_describe", this.tableDescribe);
        dataMap.put("date", DateUtil.formatDateTime(new Date()));
        dataMap.put("primary_key_field", this.primaryKeyFieldName);
        dataMap.put("primary_key_field_method", this.primaryKeyFieldMethodName);
        dataMap.put("dto_package_name", this.getSuffixPackageName("model/dto"));
        dataMap.put("vo_package_name", this.getSuffixPackageName("model/vo"));
        dataMap.put("entity_package_name", this.getSuffixPackageName("model/entity"));
        dataMap.put("package_name", this.getSuffixPackageName(packagePath));
        dataMap.put("api_package_name", this.getSuffixPackageName("api"));
        dataMap.put("service_package_name", this.getSuffixPackageName("service"));
        dataMap.put("converter_package_name", this.getSuffixPackageName("model/converter"));
        dataMap.put("dao_package_name", this.getSuffixPackageName("dao"));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), 10240);
        template.process(dataMap, out);
    }

    private void checkFilePath(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        if (!this.isReplace.booleanValue() && file.exists()) {
            throw new RuntimeException(String.format("\u8def\u5f84\u4e0b\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u9700\u66ff\u6362\u8bf7\u4fee\u6539\u914d\u7f6e\uff01\r\n %s", file.getAbsolutePath()));
        }
    }

    protected String getSerialVersionUID() {
        return String.valueOf(Math.abs(UUID.randomUUID().getMostSignificantBits())) + "L";
    }

    public String replaceUnderLineAndUpperCase(String str) {
        return StrUtil.upperFirst(StrUtil.toCamelCase(str));
    }
}

